% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{window_order}
\alias{window_order}
\alias{window_frame}
\title{Override window order and frame}
\usage{
window_order(.data, ...)

window_frame(.data, from = -Inf, to = Inf)
}
\arguments{
\item{.data}{A remote tibble}

\item{...}{Name-value pairs of expressions.}

\item{from, to}{Bounds of the frame.}
}
\description{
Override window order and frame
}
\examples{
library(dplyr)
df <- lazy_frame(g = rep(1:2, each = 5), y = runif(10), z = 1:10)

df \%>\%
  window_order(y) \%>\%
  mutate(z = cumsum(y)) \%>\%
  sql_build()

df \%>\%
  group_by(g) \%>\%
  window_frame(-3, 0) \%>\%
  window_order(z) \%>\%
  mutate(z = sum(x)) \%>\%
  sql_build()
}
