% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depth.fd.R
\name{depth.sample}
\alias{depth.sample}
\title{Fast Depth Computation for Univariate and Bivariate Random Samples}
\usage{
depth.sample(A, B)
}
\arguments{
\item{A}{Univariate or bivariate points whose depth is computed, represented by a matrix of 
size \code{m*2}. \code{m} stands for the number of points, \code{d} is 1 for univariate and 2 
for bivariate data.}

\item{B}{Random sample points with respect to which the depth of \code{A} is computed. 
\code{B} is represented by a matrix of size \code{n*2}, where \code{n} is the sample size.}
}
\value{
Vector of length \code{m} of depth halfspace depth values is returned.
}
\description{
Faster implementation of the halfspace and the simplicial depth. Computes the depth 
of a whole random sample of a univariate or a bivariate data in one run.
}
\details{
The function returns vectors of sample halfspace and simplicial depth values.
}
\examples{
n = 100
m = 150
A = matrix(rnorm(2*n),ncol=2)
B = matrix(rnorm(2*m),ncol=2)
depth.sample(A,B)
system.time(D1<-depth.halfspace(A,B))
system.time(D2<-depth.sample(A,B))
max(D1-D2$Half)

A = rnorm(100)
B = rnorm(150)
depth.sample(A,B)
# depth.halfspace(matrix(A,ncol=1),matrix(B,ncol=1))

}
\seealso{
\code{\link{depth.halfspace}}

\code{\link{depth.simplicial}}
}
\author{
Stanislav Nagy, \email{nagy at karlin.mff.cuni.cz}
}
\keyword{depth}
