% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select-utils.R
\name{select_helpers}
\alias{contains}
\alias{current_vars}
\alias{ends_with}
\alias{everything}
\alias{matches}
\alias{num_range}
\alias{one_of}
\alias{select_helpers}
\alias{starts_with}
\title{Select helpers}
\usage{
current_vars()

starts_with(match, ignore.case = TRUE, vars = current_vars())

ends_with(match, ignore.case = TRUE, vars = current_vars())

contains(match, ignore.case = TRUE, vars = current_vars())

matches(match, ignore.case = TRUE, vars = current_vars())

num_range(prefix, range, width = NULL, vars = current_vars())

one_of(..., vars = current_vars())

everything(vars = current_vars())
}
\arguments{
\item{match}{A string.}

\item{ignore.case}{If \code{TRUE}, the default, ignores case when matching
names.}

\item{vars}{A character vector of variable names. When called from inside
\code{\link{select}()} these are automatically set to the names of the
table.}

\item{prefix}{A prefix that starts the numeric range.}

\item{range}{A sequence of integers, like \code{1:5}}

\item{width}{Optionally, the "width" of the numeric range. For example,
a range of 2 gives "01", a range of three "001", etc.}

\item{...}{One or more character vectors.}
}
\value{
An integer vector given the position of the matched variables.
}
\description{
These functions allow you to select variables based on their names.
\itemize{
 \item \code{starts_with()}: starts with a prefix
 \item \code{ends_with()}: ends with a prefix
 \item \code{contains()}: contains a literal string
 \item \code{matches()}: matches a regular expression
 \item \code{num_range()}: a numerical range like x01, x02, x03.
 \item \code{one_of()}: variables in character vector.
 \item \code{everything()}: all variables.
}
}
\examples{
iris <- tbl_df(iris) # so it prints a little nicer
select(iris, starts_with("Petal"))
select(iris, ends_with("Width"))
select(iris, contains("etal"))
select(iris, matches(".t."))
select(iris, Petal.Length, Petal.Width)
select(iris, everything())
vars <- c("Petal.Length", "Petal.Width")
select(iris, one_of(vars))
}

