% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniprocessFuture-class.R
\name{UniprocessFuture-class}
\alias{UniprocessFuture-class}
\alias{UniprocessFuture}
\alias{SequentialFuture}
\title{An uniprocess future is a future whose value will be resolved synchronously in the current process}
\usage{
UniprocessFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  globals = TRUE, packages = NULL, lazy = FALSE, local = TRUE, ...)

SequentialFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  lazy = FALSE, globals = TRUE, local = TRUE, ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done (or inherits from if \code{local} is TRUE).}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{(optional) a named list of global objects needed in order
for the future to be resolved correctly.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the R environment evaluating the future.}

\item{lazy}{If \code{FALSE} (default), then the setup and validation of
global variables are done for eager evaluation, otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{\dots}{Additional named elements passed to \code{\link{Future}()}.}
}
\value{
An object of class \code{UniprocessFuture}.
}
\description{
An uniprocess future is a future whose value will be resolved synchronously in the current process
}
\seealso{
To evaluate an expression using "uniprocess future", see functions
\code{\link{uniprocess}()}.
}
\keyword{internal}
