% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiprocess.R
\name{multiprocess}
\alias{multiprocess}
\title{Create a multiprocess future whose value will be resolved asynchronously using multicore or a multisession evaluation}
\usage{
multiprocess(expr, envir = parent.frame(), substitute = TRUE,
  lazy = FALSE, seed = NULL, globals = TRUE, workers = availableCores(),
  gc = FALSE, earlySignal = FALSE, label = NULL, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression} to be evaluated.}

\item{envir}{The \link{environment} from where global
objects should be identified.  Depending on the future
strategy (the \code{evaluator}), it may also be the environment
in which the expression is evaluated.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{If \code{FALSE} (default), the future is resolved eagerly
(immediately), otherwise not.}

\item{seed}{(optional) A L'Ecuyer-CMRG RNG seed.}

\item{globals}{(optional) a logical, a character vector,
or a named list for controlling how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link{future}()}.}

\item{workers}{The maximum number of multiprocess futures that
can be active at the same time before blocking.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) after the value of the future is collected.}

\item{earlySignal}{Specified whether conditions should be signaled
as soon as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{...}{Not used.}
}
\value{
A \link{MultiprocessFuture} implemented as either a
\link{MulticoreFuture} or a \link{MultisessionFuture}.
}
\description{
A multiprocess future is a future that uses \link{multicore} evaluation
if supported, otherwise it uses \link{multisession} evaluation.
Regardless, its \emph{value is computed and resolved in
parallel in another process}.
}
\examples{
\donttest{

## Use multiprocess futures
plan(multiprocess)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multiprocess future is evaluated in a separate R process.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

}
}
\seealso{
Internally \code{\link{multicore}()} and \code{\link{multisession}()}
are used.
}
