% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.r
\docType{methods}
\name{show,git_commit-method}
\alias{show,git_commit-method}
\alias{show,git_commit-methods}
\title{Brief summary of commit}
\usage{
\S4method{show}{git_commit}(object)
}
\arguments{
\item{object}{The commit \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Displays the first seven characters of the sha, the date and the
summary of the commit message:
\code{[shortened sha] yyyy-mm-dd: summary}
}
\examples{
\dontrun{
## Initialize a repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user
config(repo, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of commit in repository
show(commits(repo)[[1]])
}
}
\keyword{methods}
