% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/attributes.R
\name{graph_attr<-}
\alias{graph.attributes<-}
\alias{graph_attr<-}
\title{Set all or some graph attributes}
\usage{
graph_attr(graph, name) <- value
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the attribute to set. If missing, then
\code{value} should be a named list, and all list members
are set as attributes.}

\item{value}{The value of the attribute to set}
}
\value{
The graph, with the attribute(s) added.
}
\description{
Set all or some graph attributes
}
\examples{
g <- make_graph(~ A - B:C:D)
graph_attr(g, "name") <- "4-star"
g

graph_attr(g) <- list(layout = layout_with_fr(g),
                       name = "4-star layed out")
plot(g)
}
\seealso{
Other graph attributes: \code{\link{$.igraph.vs}},
  \code{\link{$<-.igraph.vs}}, \code{\link{V<-}},
  \code{\link{[<-.igraph.vs}},
  \code{\link{[[<-.igraph.vs}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}},
  \code{\link{igraph-vs-attributes}};
  \code{\link{$.igraph}}, \code{\link{$<-.igraph}},
  \code{\link{igraph-dollar}}, \code{\link{igraph-dollar}};
  \code{\link{attributes}}, \code{\link{graph_attr_names}},
  \code{\link{list.graph.attributes}};
  \code{\link{delete_edge_attr}},
  \code{\link{remove.edge.attribute}};
  \code{\link{delete_graph_attr}},
  \code{\link{remove.graph.attribute}};
  \code{\link{delete_vertex_attr}},
  \code{\link{remove.vertex.attribute}};
  \code{\link{edge.attributes<-}},
  \code{\link{edge_attr<-}}; \code{\link{edge.attributes}},
  \code{\link{edge_attr}},
  \code{\link{get.edge.attribute}};
  \code{\link{edge_attr_names}},
  \code{\link{list.edge.attributes}};
  \code{\link{get.graph.attribute}},
  \code{\link{graph.attributes}}, \code{\link{graph_attr}};
  \code{\link{get.vertex.attribute}},
  \code{\link{vertex.attributes}},
  \code{\link{vertex_attr}};
  \code{\link{list.vertex.attributes}},
  \code{\link{vertex_attr_names}};
  \code{\link{set.edge.attribute}},
  \code{\link{set_edge_attr}};
  \code{\link{set.graph.attribute}},
  \code{\link{set_graph_attr}};
  \code{\link{set.vertex.attribute}},
  \code{\link{set_vertex_attr}};
  \code{\link{vertex.attributes<-}},
  \code{\link{vertex_attr<-}}
}

