% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/conversion.R
\name{as_adj_list}
\alias{as_adj_edge_list}
\alias{as_adj_list}
\alias{get.adjedgelist}
\alias{get.adjlist}
\title{Adjacency lists}
\usage{
as_adj_list(graph, mode = c("all", "out", "in", "total"))

as_adj_edge_list(graph, mode = c("all", "out", "in", "total"))
}
\arguments{
\item{graph}{The input graph.}

\item{mode}{Character scalar, it gives what kind of adjacent edges/vertices
to include in the lists. \sQuote{\code{out}} is for outgoing edges/vertices,
\sQuote{\code{in}} is for incoming edges/vertices, \sQuote{\code{all}} is
for both. This argument is ignored for undirected graphs.}
}
\value{
A list of numeric vectors.
}
\description{
Create adjacency lists from a graph, either for adjacent edges or for
neighboring vertices
}
\details{
\code{as_adj_list} returns a list of numeric vectors, which include the ids
of neighbor vertices (according to the \code{mode} argument) of all
vertices.

\code{as_adj_edge_list} returns a list of numeric vectors, which include the
ids of adjacent edgs (according to the \code{mode} argument) of all
vertices.
}
\examples{
g <- make_ring(10)
as_adj_list(g)
as_adj_edge_list(g)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\seealso{
\code{\link{as_edgelist}}, \code{\link{as_adj}}
}
\keyword{graphs}

