% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/games.R
\name{sample_grg}
\alias{grg}
\alias{grg.game}
\alias{sample_grg}
\title{Geometric random graphs}
\usage{
sample_grg(nodes, radius, torus = FALSE, coords = FALSE)

grg(...)
}
\arguments{
\item{nodes}{The number of vertices in the graph.}

\item{radius}{The radius within which the vertices will be connected by an
edge.}

\item{torus}{Logical constant, whether to use a torus instead of a square.}

\item{coords}{Logical scalar, whether to add the positions of the vertices
as vertex attributes called \sQuote{\code{x}} and \sQuote{\code{y}}.}

\item{...}{Passed to \code{sample_grg}.}
}
\value{
A graph object. If \code{coords} is \code{TRUE} then with vertex
attributes \sQuote{\code{x}} and \sQuote{\code{y}}.
}
\description{
Generate a random graph based on the distance of random point on a unit
square
}
\details{
First a number of points are dropped on a unit square, these points
correspond to the vertices of the graph to create. Two points will be
connected with an undirected edge if they are closer to each other in
Euclidean norm than a given radius. If the \code{torus} argument is
\code{TRUE} then a unit area torus is used instead of a square.
}
\examples{
g <- sample_grg(1000, 0.05, torus=FALSE)
g2 <- sample_grg(1000, 0.05, torus=TRUE)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}, first version was
written by Keith Briggs (\url{http://keithbriggs.info/}).
}
\seealso{
\code{\link{sample_gnp}}
}
\keyword{graphs}

