% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plot_geo}
\alias{plot_geo}
\title{Initiate a plotly-geo object}
\usage{
plot_geo(data = data.frame(), ...)
}
\arguments{
\item{data}{A data frame (optional).}

\item{...}{arguments passed along to \code{\link[=plot_ly]{plot_ly()}}.}
}
\description{
Use this function instead of \code{\link[=plot_ly]{plot_ly()}} to initialize
a plotly-geo object. This enforces the entire plot so use
the scattergeo trace type, and enables higher level geometries
like \code{\link[=add_polygons]{add_polygons()}} to work
}
\examples{

map_data("world", "canada") \%>\%
  group_by(group) \%>\%
  plot_geo(x = ~long, y = ~lat) \%>\%
  add_markers(size = I(1))

}
\seealso{
\code{\link[=plot_ly]{plot_ly()}}, \code{\link[=plot_mapbox]{plot_mapbox()}}, \code{\link[=ggplotly]{ggplotly()}}
}
\author{
Carson Sievert
}
