% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map2-pmap.R
\name{map2}
\alias{map2}
\alias{map2_lgl}
\alias{map2_int}
\alias{map2_dbl}
\alias{map2_chr}
\alias{map2_dfr}
\alias{map2_dfc}
\alias{map2_df}
\alias{walk2}
\alias{pmap}
\alias{pmap_lgl}
\alias{pmap_int}
\alias{pmap_dbl}
\alias{pmap_chr}
\alias{pmap_dfr}
\alias{pmap_dfc}
\alias{pmap_df}
\alias{pwalk}
\title{Map over multiple inputs simultaneously.}
\usage{
map2(.x, .y, .f, ...)

map2_lgl(.x, .y, .f, ...)

map2_int(.x, .y, .f, ...)

map2_dbl(.x, .y, .f, ...)

map2_chr(.x, .y, .f, ...)

map2_dfr(.x, .y, .f, ..., .id = NULL)

map2_dfc(.x, .y, .f, ...)

walk2(.x, .y, .f, ...)

pmap(.l, .f, ...)

pmap_lgl(.l, .f, ...)

pmap_int(.l, .f, ...)

pmap_dbl(.l, .f, ...)

pmap_chr(.l, .f, ...)

pmap_dfr(.l, .f, ..., .id = NULL)

pmap_dfc(.l, .f, ...)

pwalk(.l, .f, ...)
}
\arguments{
\item{.x, .y}{Vectors of the same length. A vector of length 1 will
be recycled.}

\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}

\item{.l}{A list of lists. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\value{
An atomic vector, list, or data frame, depending on the suffix.
Atomic vectors and lists will be named if \code{.x} or the first
element of \code{.l} is named.

If all input is length 0, the output will be length 0. If any
input is length 1, it will be recycled to the length of the longest.
}
\description{
These functions are variants of \code{map()} iterate over multiple
arguments in parallel. \code{map2()} and \code{walk2()} are specialised for the two
argument case; \code{pmap()} and \code{pwalk()} allow you to provide any number of
arguments in a list.
}
\details{
Note that arguments to be vectorised over come before the \code{.f},
and arguments that are supplied to every call come after \code{.f}.
}
\examples{
x <- list(1, 10, 100)
y <- list(1, 2, 3)
z <- list(5, 50, 500)

map2(x, y, ~ .x + .y)
# Or just
map2(x, y, `+`)

# Split into pieces, fit model to each piece, then predict
by_cyl <- mtcars \%>\% split(.$cyl)
mods <- by_cyl \%>\% map(~ lm(mpg ~ wt, data = .))
map2(mods, by_cyl, predict)

pmap(list(x, y, z), sum)

# Matching arguments by position
pmap(list(x, y, z), function(a, b ,c) a / (b + c))

# Matching arguments by name
l <- list(a = x, b = y, c = z)
pmap(l, function(c, b, a) a / (b + c))

# Vectorizing a function over multiple arguments
df <- data.frame(
  x = c("apple", "banana", "cherry"),
  pattern = c("p", "n", "h"),
  replacement = c("x", "f", "q"),
  stringsAsFactors = FALSE
  )
pmap(df, gsub)
pmap_chr(df, gsub)

## Use `...` to absorb unused components of input list .l
df <- data.frame(
  x = 1:3 + 0.1,
  y = 3:1 - 0.1,
  z = letters[1:3]
)
plus <- function(x, y) x + y
\dontrun{
## this won't work
pmap(df, plus)
}
## but this will
plus2 <- function(x, y, ...) x + y
pmap_dbl(df, plus2)

}
\seealso{
Other map variants: \code{\link{imap}},
  \code{\link{invoke}}, \code{\link{lmap}},
  \code{\link{map}}, \code{\link{modify}}
}
