% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roles.R
\name{add_role}
\alias{add_role}
\title{Manually Add Roles}
\usage{
add_role(recipe, ..., new_role = "predictor")
}
\arguments{
\item{recipe}{An existing \code{\link[=recipe]{recipe()}}.}

\item{...}{One or more selector functions to choose which variables are
being assigned a role. See \code{\link[=selections]{selections()}} for more details.}

\item{new_role}{A character string for a single role.}
}
\value{
An updated recipe object.
}
\description{
\code{add_role} can add a role definition to an existing variable in the
recipe.
}
\details{
If a variable is selected that currently has a role, the role is
changed and a warning is issued.
}
\examples{

data(biomass)

# Create the recipe manually
rec <- recipe(x = biomass)
rec
summary(rec)

rec <- rec \%>\%
  add_role(carbon, contains("gen"), sulfur, new_role = "predictor") \%>\%
  add_role(sample, new_role = "id variable") \%>\%
  add_role(dataset, new_role = "splitting variable") \%>\%
  add_role(HHV, new_role = "outcome")
rec

}
\concept{
preprocessing model_specification
}
\keyword{datagen}
