% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jurisdiction.R
\name{jurisdiction}
\alias{jurisdiction}
\alias{jurisdictional_origin}
\alias{jurisdiction_origin_values}
\alias{jurisdiction_values}
\title{Get jurisdictional origin from tsn}
\usage{
jurisdictional_origin(tsn, wt = "json", raw = FALSE, ...)

jurisdiction_origin_values(wt = "json", raw = FALSE, ...)

jurisdiction_values(wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
\itemize{
\item jurisdictional_origin: data.frame
\item jurisdiction_origin_values: data.frame
\item jurisdiction_values: character vector
}
}
\description{
Get jurisdictional origin from tsn
}
\details{
Jurisdiction methods:
\itemize{
\item jurisdictional_origin: Get jurisdictional origin from tsn
\item jurisdiction_origin_values: Get jurisdiction origin values
\item jurisdiction_values: Get all possible jurisdiction values
}
}
\examples{
\dontrun{
jurisdictional_origin(tsn=180543)
jurisdictional_origin(tsn=180543, wt = "xml")

jurisdiction_origin_values()

jurisdiction_values()
}
}
