% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{bare-type-predicates}
\alias{bare-type-predicates}
\alias{is_bare_list}
\alias{is_bare_atomic}
\alias{is_bare_vector}
\alias{is_bare_double}
\alias{is_bare_integer}
\alias{is_bare_numeric}
\alias{is_bare_character}
\alias{is_bare_logical}
\alias{is_bare_raw}
\alias{is_bare_string}
\alias{is_bare_bytes}
\title{Bare type predicates}
\usage{
is_bare_list(x, n = NULL)

is_bare_atomic(x, n = NULL)

is_bare_vector(x, n = NULL)

is_bare_double(x, n = NULL)

is_bare_integer(x, n = NULL)

is_bare_numeric(x, n = NULL)

is_bare_character(x, n = NULL, encoding = NULL)

is_bare_logical(x, n = NULL)

is_bare_raw(x, n = NULL)

is_bare_string(x, n = NULL)

is_bare_bytes(x, n = NULL)
}
\arguments{
\item{x}{Object to be tested.}

\item{n}{Expected length of a vector.}

\item{encoding}{Expected encoding of a string or character
vector. One of \code{UTF-8}, \code{latin1}, or \code{unknown}.}
}
\description{
These predicates check for a given type but only return \code{TRUE} for
bare R objects. Bare objects have no class attributes. For example,
a data frame is a list, but not a bare list.
}
\details{
\itemize{
\item The predicates for vectors include the \code{n} argument for
pattern-matching on the vector length.
\item Like \code{\link[=is_atomic]{is_atomic()}} and unlike base R \code{is.atomic()},
\code{is_bare_atomic()} does not return \code{TRUE} for \code{NULL}.
\item Unlike base R \code{is.numeric()}, \code{is_bare_double()} only returns
\code{TRUE} for floating point numbers.
}
}
\seealso{
\link{type-predicates}, \link{scalar-type-predicates}
}
