% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{scoped_env}
\alias{scoped_env}
\alias{pkg_env}
\alias{pkg_env_name}
\alias{scoped_names}
\alias{scoped_envs}
\alias{is_scoped}
\alias{base_env}
\alias{global_env}
\title{Scoped environments}
\usage{
scoped_env(nm)

pkg_env(pkg)

pkg_env_name(pkg)

scoped_names()

scoped_envs()

is_scoped(nm)

base_env()

global_env()
}
\arguments{
\item{nm}{The name of an environment attached to the search
path. Call \code{\link[base:search]{base::search()}} to see what is currently on the path.}

\item{pkg}{The name of a package.}
}
\description{
Scoped environments are named environments which form a
parent-child hierarchy called the search path. They define what
objects you can see (are in scope) from your workspace. They
typically are package environments, i.e. special environments
containing all exported functions from a package (and whose parent
environment is the package namespace, which also contains
unexported functions). Package environments are attached to the
search path with \code{\link[base:library]{base::library()}}. Note however that any
environment can be attached to the search path, for example with
the unrecommended \code{\link[base:attach]{base::attach()}} base function which transforms
vectors to scoped environments.
\itemize{
\item You can list all scoped environments with \code{scoped_names()}. Unlike
\code{\link[base:search]{base::search()}}, it also mentions the empty environment that
terminates the search path (it is given the name \code{"NULL"}).
\item \code{scoped_envs()} returns all environments on the search path,
including the empty environment.
\item \code{pkg_env()} takes a package name and returns the scoped
environment of packages if they are attached to the search path,
and throws an error otherwise.
\item \code{is_scoped()} allows you to check whether a named environment is
on the search path.
}
}
\section{Search path}{


The search path is a chain of scoped environments where newly
attached environments are the childs of earlier ones. However, the
global environment, where everything you define at top-level ends
up, is pinned as the head of that linked chain. Likewise, the base
package environment is pinned as the tail of the chain. You can
retrieve those environments with \code{global_env()} and \code{base_env()}
respectively. The global environment is also the environment of the
very first evaluation frame on the stack, see \code{\link[=global_frame]{global_frame()}} and
\code{\link[=ctxt_stack]{ctxt_stack()}}.
}

\examples{
# List the names of scoped environments:
nms <- scoped_names()
nms

# The global environment is always the first in the chain:
scoped_env(nms[[1]])

# And the scoped environment of the base package is always the last:
scoped_env(nms[[length(nms)]])

# These two environments have their own shortcuts:
global_env()
base_env()

# Packages appear in the search path with a special name. Use
# pkg_env_name() to create that name:
pkg_env_name("rlang")
scoped_env(pkg_env_name("rlang"))

# Alternatively, get the scoped environment of a package with
# pkg_env():
pkg_env("utils")
}
