% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solr_stats.r
\name{solr_stats}
\alias{solr_stats}
\title{Solr stats}
\usage{
solr_stats(name = NULL, q = "*:*", stats.field = NULL,
  stats.facet = NULL, wt = "json", start = 0, rows = 0, key = NULL,
  callopts = list(), raw = FALSE, parsetype = "df")
}
\arguments{
\item{name}{Name of a collection or core. Or leave as \code{NULL} if not needed.}

\item{q}{Query terms, defaults to '*:*', or everything.}

\item{stats.field}{The number of similar documents to return for each result.}

\item{stats.facet}{You can not facet on multi-valued fields.}

\item{wt}{(character) Data type returned, defaults to 'json'. One of json or xml. If json, 
uses \code{\link[jsonlite]{fromJSON}} to parse. If xml, uses \code{\link[XML]{xmlParse}} to 
parse. csv is only supported in \code{\link{solr_search}} and \code{\link{solr_all}}.}

\item{start}{Record to start at, default to beginning.}

\item{rows}{Number of records to return. Defaults to 10.}

\item{key}{API key, if needed.}

\item{callopts}{Call options passed on to httr::GET}

\item{raw}{(logical) If TRUE, returns raw data in format specified by wt param}

\item{parsetype}{(character) One of 'list' or 'df'}
}
\value{
XML, JSON, a list, or data.frame
}
\description{
Returns only stat items
}
\details{
The \code{verbose} parameter dropped. See \code{\link{solr_connect}}, which
can be used to set verbose status.
}
\examples{
\dontrun{
# connect
solr_connect('http://api.plos.org/search')

# get stats
solr_stats(q='science', stats.field='counter_total_all', raw=TRUE)
solr_stats(q='title:"ecology" AND body:"cell"',
   stats.field=c('counter_total_all','alm_twitterCount'))
solr_stats(q='ecology', stats.field=c('counter_total_all','alm_twitterCount'),
   stats.facet='journal')
solr_stats(q='ecology', stats.field=c('counter_total_all','alm_twitterCount'),
   stats.facet=c('journal','volume'))

# Get raw data, then parse later if you feel like it
## json
out <- solr_stats(q='ecology', stats.field=c('counter_total_all','alm_twitterCount'),
   stats.facet=c('journal','volume'), raw=TRUE)
library("jsonlite")
jsonlite::fromJSON(out)
solr_parse(out) # list
solr_parse(out, 'df') # data.frame

## xml
out <- solr_stats(q='ecology', stats.field=c('counter_total_all','alm_twitterCount'),
   stats.facet=c('journal','volume'), raw=TRUE, wt="xml")
library("xml2")
xml2::read_xml(unclass(out))
solr_parse(out) # list
solr_parse(out, 'df') # data.frame

# Get verbose http call information
library("httr")
solr_stats(q='ecology', stats.field='alm_twitterCount',
   callopts=verbose())
}
}
\references{
See \url{http://wiki.apache.org/solr/StatsComponent} for
more information on Solr stats.
}
\seealso{
\code{\link{solr_highlight}}, \code{\link{solr_facet}},
\code{\link{solr_search}}, \code{\link{solr_mlt}}
}

