% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_removerole.R
\name{collection_removerole}
\alias{collection_removerole}
\title{Remove a role from a node}
\usage{
collection_removerole(role = "overseer", node, raw = FALSE, ...)
}
\arguments{
\item{role}{(character) Required. The name of the role. The only supported role
as of now is overseer (set as default).}

\item{node}{(character) Required. The name of the node.}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{...}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Remove an assigned role. This API is used to undo the roles
assigned using \code{\link{collection_addrole}}
}
\examples{
\dontrun{
solr_connect()

# get list of nodes
nodes <- collection_clusterstatus()$cluster$live_nodes
collection_addrole(node = nodes[1])
collection_removerole(node = nodes[1])
}
}

