% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifiers.r
\name{modifiers}
\alias{boundary}
\alias{coll}
\alias{fixed}
\alias{modifiers}
\alias{regex}
\title{Control matching behaviour with modifier functions.}
\usage{
fixed(pattern, ignore_case = FALSE)

coll(pattern, ignore_case = FALSE, locale = NULL, ...)

regex(pattern, ignore_case = FALSE, multiline = FALSE, comments = FALSE,
  dotall = FALSE, ...)

boundary(type = c("character", "line_break", "sentence", "word"),
  skip_word_none = NA, ...)
}
\arguments{
\item{pattern}{Pattern to modify behaviour.}

\item{ignore_case}{Should case differences be ignored in the match?}

\item{locale}{Locale to use for comparisons. See
\code{\link[stringi]{stri_locale_list}()} for all possible options.}

\item{...}{Other less frequently used arguments passed on to
\code{\link[stringi]{stri_opts_collator}},
\code{\link[stringi]{stri_opts_regex}}, or
\code{\link[stringi]{stri_opts_brkiter}}}

\item{multiline}{If \code{TRUE}, \code{$} and \code{^} match
the beginning and end of each line. If \code{FALSE}, the
default, only match the start and end of the input.}

\item{comments}{If \code{TRUE}, white space and comments beginning with
\code{#} are ignored. Escape literal spaces with \code{\\ }.}

\item{dotall}{If \code{TRUE}, \code{.} will also match line terminators.}

\item{type}{Boundary type to detect.}

\item{skip_word_none}{Ignore "words" that don't contain any characters
or numbers - i.e. punctuation. Default \code{NA} will skip such "words"
only when splitting on \code{word} boundaries.}
}
\description{
\describe{
 \item{fixed}{Compare literal bytes in the string. This is very fast, but
   not usually what you want for non-ASCII character sets.}
 \item{coll}{Compare strings respecting standard collation rules.}
 \item{regex}{The default. Uses ICU regular expressions.}
 \item{boundary}{Match boundaries between things.}
}
}
\examples{
pattern <- "a.b"
strings <- c("abb", "a.b")
str_detect(strings, pattern)
str_detect(strings, fixed(pattern))
str_detect(strings, coll(pattern))

# coll() is useful for locale-aware case-insensitive matching
i <- c("I", "\\u0130", "i")
i
str_detect(i, fixed("i", TRUE))
str_detect(i, coll("i", TRUE))
str_detect(i, coll("i", TRUE, locale = "tr"))

# Word boundaries
words <- c("These are   some words.")
str_count(words, boundary("word"))
str_split(words, " ")[[1]]
str_split(words, boundary("word"))[[1]]

# Regular expression variations
str_extract_all("The Cat in the Hat", "[a-z]+")
str_extract_all("The Cat in the Hat", regex("[a-z]+", TRUE))

str_extract_all("a\\nb\\nc", "^.")
str_extract_all("a\\nb\\nc", regex("^.", multiline = TRUE))

str_extract_all("a\\nb\\nc", "a.")
str_extract_all("a\\nb\\nc", regex("a.", dotall = TRUE))
}

