% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-that.R
\docType{package}
\name{testthat}
\alias{testthat}
\alias{testthat-package}
\title{R package to make testing fun!}
\description{
Try the example below. Have a look at the references and learn more
from function documentation such as \code{\link{expect_that}}.
}
\details{
Software testing is important, but, in part because
it is frustrating and boring, many of us avoid it.

testthat is a new testing framework for R that is easy learn and use,
and integrates with your existing workflow.
}
\section{Options}{

\code{testthat.use_colours}: Should the output be coloured? (Default:
\code{TRUE}).

\code{testthat.summary.max_reports}: The maximum number of detailed test
reports printed for the summary reporter (default: 15).
}
\examples{
library(testthat)
a <- 9
expect_that(a, is_less_than(10))
expect_less_than(a, 10)
}
\references{
Wickham, H (2011). testthat: Get Started with Testing.
\strong{The R Journal} \emph{3/1} 5-10.
\url{http://journal.r-project.org/archive/2011-1/RJournal_2011-1_Wickham.pdf}

\url{https://github.com/hadley/testthat}

\url{http://adv-r.had.co.nz/Testing.html}
}

