% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repair-names.R
\name{set_tidy_names}
\alias{set_tidy_names}
\alias{tidy_names}
\alias{repair_names}
\title{Repair object names}
\usage{
set_tidy_names(x, syntactic = FALSE, quiet = FALSE)

tidy_names(name, syntactic = FALSE, quiet = FALSE)

repair_names(x, prefix = "V", sep = "")
}
\arguments{
\item{x}{A named vector.}

\item{syntactic}{Should all names be made syntactically valid via \code{\link[=make.names]{make.names()}}?}

\item{quiet}{If \code{TRUE} suppresses output from this function}

\item{name}{A character vector representing names.}

\item{prefix}{A string, the prefix to use for new column names.}

\item{sep}{A string inserted between the column name and de-duplicating
number.}
}
\value{
\code{x} with valid names.
}
\description{
\code{set_tidy_names()} ensures its input has non-missing and
unique names (duplicated names get a suffix of the format \code{..#}
where \code{#} is the position in the vector).
Valid names are left unchanged, with the exception that existing suffixes
are reorganized.

\code{tidy_names()} is the workhorse behind \code{set_tidy_names()}, it treats the
argument as a string to be used to name a data frame or a vector.

\code{repair_names()} is an older version with different renaming heuristics,
kept for backward compatibility.  New code should prefer \code{tidy_names()}.
}
\examples{
# Works for lists and vectors, too:
set_tidy_names(3:5)
set_tidy_names(list(3, 4, 5))

# Clean data frames are left unchanged:
set_tidy_names(mtcars)

# By default, all rename operations are printed to the console:
tbl <- as_tibble(structure(list(3, 4, 5), class = "data.frame"),
                 validate = FALSE)
set_tidy_names(tbl)

# Optionally, names can be made syntactic:
tidy_names("a b", syntactic = TRUE)
}
