#!/usr/bin/perl
# Copyright (C) 2008-2011, The Perl Foundation.

use strict;
use warnings;
use 5.008;

binmode STDOUT, ':utf8';

my @files = @ARGV;

print <<"END_HEAD";
# This file automatically generated by $0

END_HEAD

foreach my $file (@files) {
    print "# From $file\n\n";
    open(my $fh, "<:utf8",  $file) or die "$file: $!";
    local $/;
    my $x = <$fh>;
    close $fh;
    print $x;
}

print "\n# vim: set ft=perl6 nomodifiable :\n";
