# Announce: Rakudo Perl 6 compiler, Development Release #88 ("Dresden")

On behalf of the Rakudo development team, I'm happy to announce the May
2015 release of Rakudo Perl 6 #88 "Dresden". Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1] and the Java Virtual Machine. The
tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it's announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The Rakudo Perl compiler follows a monthly release cycle, with each
release named after a Perl Mongers group. This month's release is named after
Dresden, where this year's German Perl Workshop happened.

Some of the changes in this release are outlined below:

* NFG, NFC, NFD, Uni
* Implemented CLIENT:: (nearest CALLER:: from different package)
* Implemented "is nodal" for signalling behaviour under hypers
* Rudimentary tab completion available via the Linenoise module
* "unit" declaration needed for blockless packages
* Various API changes for the Great List Refactor, such as...
  + 'for' loops not longer flatten; use 'for flat' for that
  + .map no longer flattens, map as a listop does. Use .flatmap to get the
     old behavior
  + Likewise other methods that used to flatten their invocant no longer do:
    all, any, one, none, unique, squish, min, max, minmax, classify, and categorize
  + Nil no longer iterates like the empty List. Use () or Empty instead.
* .pick($n)/roll($n) now always return lists, even when $n == 1
* $?FILE is now always an absolute path
* The "is cached" trait no longer works on methods, throws a NYI instead
* Method .map should be used instead of .for
* Test.pm functions are now kebab-cased (e.g. throws_like -> throws-like)
* Hashes use much less memory on Moar
* The REPL is strict by default now, that leaves only '-e' lines to be lax
* site/lib is now in the C library (.dll/.so/.dylib etc) search path
* generating backtraces is now lazy, improving the speed of e.g. warnings
* Implement new @*INC handling (about 30% faster startup time)
  (bare startup time is now below 100 ms on some machines)
* Implemented CUnions which map to the union C type definition for NativeCall
* Implemented HAS declarator for attributes to mark it embedded into the
  CStruct or CUnion

These are only some of the changes in this release. For a more
detailed list, see "docs/ChangeLog".

The development team thanks all of our contributors and sponsors for
making Rakudo Perl possible, as well as those people who worked on
Parrot, the Perl 6 test suite, MoarVM and the specification.

The following people contributed to this release:

Elizabeth Mattijsen, Jonathan Worthington, Tobias Leich, Sterling Hanenkamp,
Arne Skjærholt, Paul Cochrane, Larry Wall, Rob Hoelz, Carl Masak, raydiak,
Timo Paulssen, Christian Bartolomäus, Will "Coke" Coleda, Bart Wiegmans,
Moritz Lenz, Jonathan Stowe, skids, Pepe Schwarz, Brent Laabs, Steve Mynott,
Jeffrey Goff, Solomon Foster, Radek Slupik, Elise, tony-o, Stefan Seifert,
Jimmy Zhuo, Nicholas Clark, Brad Gilbert, Nick Logan, ven, lembark,
Justin DeVuyst, David Warring, Xinyuan Wang, David Farrell

If you would like to contribute, see <http://rakudo.org/how-to-help>,
ask on the <perl6-compiler@perl.org> mailing list, or ask on IRC #perl6
on freenode.

The next release of Rakudo (#89), is scheduled for 18 June 2015.
A list of the other planned release dates and code names for future
releases is available in the "docs/release_guide.pod" file. A Rakudo
development release typically occurs a few days (often two) after the
third Tuesday of each month.

The development team appreciates feedback! If you're using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

[^1]: See <http://moarvm.org/>

[^2]: What's the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the "Using Perl 6" book, and other software that can
be used with the Rakudo compiler to enhance its utility.  Rakudo Star
is meant for early adopters who wish to explore what's possible with
Rakudo Perl 6 and provide feedback on what works, what doesn't, and
what else they would like to see included in the distribution.
