#
# Write a pkg-config pc file for given "name" with "decription"
# Arguments:
#   name: a library name (withoud "lib" prefix and "so" suffixes
#   desc: a desription string
#
macro (create_pkgconfig_file name desc)
    set(_pkgfname "${CMAKE_CURRENT_BINARY_DIR}/${name}.pc")
    message(STATUS "${name}: writing pkgconfig file ${_pkgfname}")

    file(WRITE "${_pkgfname}" "# file generated by razor-qt cmake build
prefix=${CMAKE_INSTALL_PREFIX}
libdir=\${prefix}/lib${LIB_SUFFIX}
includedir=\${prefix}/include

Name: ${name}
Description: ${desc}
Version: ${RAZOR_VERSION}
Libs: -L\${libdir} -l${name}
Cflags: -I\${includedir}

")

    install(FILES ${_pkgfname} DESTINATION lib${LIB_SUFFIX}/pkgconfig)
endmacro()
