#!/bin/bash

re2c_srcdir=".."

for fre in unicode_{blocks,group_*}.{8,x,u}--encoding-policy\({ignore,substitute,fail}\).re
do
    echo $fre
    fc=${fre/.re/.c}
    fe=${fre/.re/}
    re2c_switches=`printf "%s" "$fre" | sed -E -e 's/[^.]+.([a-z0-9]+)--encoding-policy\((ignore|substitute|fail)\).*/-\1 --encoding-policy \2/'`

    # compile re2c source
    ../re2c $re2c_switches $fre 2>&1 \
    | sed -e "s,/\* Generated by re2c .*\*/,/\* Generated by re2c \*/,g" 1> $fc

    read line < $fc
    if [[ $line == "re2c: error:"* ]]
    then
        echo "*** re2c error, skipping ***"
        continue
    fi

    # compile C source
    g++ -I $re2c_srcdir -W -Wall -Wextra $fc $re2c_srcdir/utf8.cc $re2c_srcdir/utf16.cc -o $fe

    # execute (runs silently if OK, otherwize report an error)
    ./$fe

    rm -f $fe
done
