/* dbfncs.h header file for dbfncs.c */
/* markus@mhoenicka.de 2002-08-06 */
/* $Id: dbfncs.h,v 1.6.2.5 2005/09/11 19:58:10 mhoenicka Exp $ */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, see <http://www.gnu.org/licenses/>

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

struct db_caps {
  char multiple_db[2]; /* if t, SELECT can address tables in more than
			  one db */
  char sql_enum[2]; /* if t, the db engine supports an enum type */
  char rlike[13]; /* what SELECT uses to implement a regexp like */
  char not_rlike[17]; /* what SELECT uses to implement a regexp not like */
  char transaction[2]; /* if t, the db engine supports transactions */
  char localhost[10]; /* the string used to access the db engine on
			 localhost */
  char encoding[16]; /* command fragment to request char encodings */
  char groups[3]; /* if t, db engine uses groups to manage users */
  char admin_systable[11]; /* a table that only the admin may access */
  char listall[3]; /* the string used in SELECT to list all entries */
  char bigint[2]; /* if t, db engine supports unsigned long long */
  char sql_union[2]; /* if t, the db engine supports UNION in SELECT */
  char named_seq[2]; /* if t, sequence_last() needs seq name */
  char charlength[12]; /* the SQL function returning the length of a string */
  char substring[10]; /* the SQL function used to retrieve a substring */
  char substring_from[7]; /* the from part of the substring function */
  char substring_for[6]; /* the for part of the substring function */
  char sql_except[2]; /* if t, supports EXCEPT in SELECT clauses */
  char defval[2]; /* default return value if nothing else helps */
  char unix_regexp[2]; /* if t, supports unix regular expressions */
  int has_versioninfo; /* if non-zero, struct was updated with db
			  engine version-specific information */
};

struct db_caps* new_db_caps(struct CLIENT_REQUEST* ptr_clrequest);
void free_db_caps(struct db_caps* ptr_caps);
int create_tables_mysql(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest, int is_temp);
int create_xdup_tables_mysql(dbi_conn conn);
int create_tables_pgsql(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest, int is_temp);
int create_xdup_tables_pgsql(dbi_conn conn);
int create_tables_sqlite(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest, int is_temp);
int create_xdup_tables_sqlite(dbi_conn conn);
int create_tables_sqlite3(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest, int is_temp);
int create_xdup_tables_sqlite3(dbi_conn conn);
int is_user_pgsql(dbi_conn conn, const char* username);
int is_group_pgsql(dbi_conn conn, const char* dbname, int is_readonly);
int create_temporary_tables(dbi_conn conn, struct CLIENT_REQUEST* ptr_clrequest);
const char* my_dbi_driver_regexp(dbi_driver driver, int like);
int my_dbi_conn_begin(dbi_conn conn);
int my_dbi_conn_rollback(dbi_conn conn);
int my_dbi_conn_commit(dbi_conn conn);
int my_dbi_conn_lock(dbi_conn conn, int replace_ref);
int my_dbi_conn_lock_note(dbi_conn conn);
int my_dbi_conn_unlock(dbi_conn conn);
const char* my_dbi_conn_get_cap(dbi_conn conn, const char* cap);
const char* my_dbi_driver_get_cap(dbi_driver driver, const char* cap);
unsigned long long my_dbi_result_get_idval(dbi_result dbires, const char* fieldname);
unsigned long long my_dbi_result_get_idval_idx(dbi_result dbires, unsigned int idx);
unsigned int my_dbi_result_get_int_idval(dbi_result dbires, const char* fieldname);
unsigned int my_dbi_result_get_int_idval_idx(dbi_result dbires, unsigned int idx);
int my_dbi_conn_get_versioninfo(dbi_conn conn, struct VERSIONINFO* ptr_ver);
int my_dbi_initialize(const char *driverdir, dbi_inst *pInst);
void my_dbi_shutdown(dbi_inst Inst);
dbi_driver my_dbi_driver_list(dbi_driver Current, dbi_inst Inst);
dbi_conn my_dbi_conn_new(const char *name, dbi_inst Inst);
int my_dbi_conn_error_flag(dbi_conn Conn);



