#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "cosinusprod_helmholtz.icc"
int main(int argc, char**argv) {
  environment rheolef(argc, argv);
  geo omega (argv[1]);
  size_t d = omega.dimension();
  space Xh (omega, argv[2]);
  form m (Xh, Xh, "mass");
  form a (Xh, Xh, "grad_grad");
  a = m + a;
  field lh = riesz(Xh, f(d));
  field uh (Xh);
  solver sa (a.uu());
  uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
  dout << uh;
}
