// TODO: extensions
//  approx P1 -> P0 and P2 -> P1d
//  option -x i ==> "d_dxi" i=1,2,3
//
/*P:d_dx
NAME: Computing the Gradient
\cindex{gradient}
\cindex{discontinuous approximation}
\cindex{block-diagonal matrix}
\foindex{mass}

   Remark that the gradient ${\bf q}_h = \nabla u_h$ of a continuous picewise linear function $u_h$
   is a discontinuous piecewise constant function.
   Conversely, the gradient of a continuous picewise quadratic
   function is a discontinuous piecewise linear function.
\subsection{Formulation}
   For all $i=1\ldots N$, the $i$-th component $q_{h,i}$ of the gradient belongs to the space:
   $$
       T_h \ \{ \phi_h \in L^2(\Omega); \ 
           \phi_{h/K} \in P_{k-1}, \ 
	   \forall K \in {\cal T}_h 
	   \}
   $$
   By introducing the two following bilinear forms:
   $$
       m_T(\psi_h,\phi_h) = \int_\Omega \psi_h \phi_h \, dx
   $$
   $$
       b_i(u_h,\phi_h) = \int_\Omega \frac{\partial u_h}{\partial x_i} \phi_h \, dx
   $$
   the gradient satisfies the following variational formulation:
   $$
       m_T(q_{h,i},\phi_h) = b_i(u_h, \phi_h), \ \forall \psi_h \in Th
   $$
   Remark that the matrix associated to the $m_T(.,,)$ bilinear form 
   is block-diagonal. Each block is associated to an element, and can
   be inverted at the element level.
   The following code uses this property on step (e), 
   as the \code{"inv\\_mass"} form.
END:
*/
//<d_dx:
#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

string get_approx_grad (const space &Vh)
{
    string Pk = Vh.get_approx();
    if (Pk == "P1") return "P0";
    if (Pk == "P2") return "P1d";
    cerr << "unexpected approximation " << Pk << endl;
    exit (1);
}
int main(int argc, char**argv)
{
    field uh;
    cin >> uh;
    space Vh      = uh.get_space();
    geo   omega_h = Vh.get_geo();
    string approx_grad = get_approx_grad(Vh);
    space Th (omega_h, approx_grad);
    form b(Vh, Th, "d_dx0");
    form inv_mass (Th, Th, "inv_mass");
    field du_dx0 = inv_mass*(b*uh);
    int digits10 = numeric_limits<Float>::digits10;
    cout << setprecision(digits10) << du_dx0;
}
//>d_dx:
