#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
#include "old-cavity.h"
using namespace rheolef;
using namespace std;
field solve (const field& fh, Float lambda) {
    const space& Vh = fh.get_space ();
    space Qh (fh.get_geo(), "P1");
    field uh = cavity_field (Vh, 1);
    field ph (Qh, 0.);
    form m (Vh, Vh, "mass");
    form a (Vh, Vh, "2D_D");
    a = lambda*m + a;
    form b (Vh, Qh, "div"); b = -b;
    size_t max_iter = 5;
    Float tol       = 1e-12;
    Float r         = 1e+7;
    form ar = a + r*trans(b)*b;
    ssk<Float> fact = ldlt(ar.uu);
    uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, (m*fh).u - ar.ub*uh.b,
        -(b.ub*uh.b), r, max_iter, tol, 0);
    return uh;
}
field criteria (Float Re, const field& uh) {
  space Xh  (uh.get_geo(), "P1d");
  form inv_m  (Xh, Xh, "inv_mass");
  form mpt   (Xh, uh.get_space()[0], "mass");
  form p = inv_m * trans(mpt);
  field c1 = sqr(p*uh[0]) + sqr(p*uh[1]);
  space Th  (uh.get_geo(), "P1d", "tensor");
  form two_D (uh.get_space(), Th, "2D");
  form inv_mt (Th, Th, "inv_mass");
  field two_Duh = inv_mt*(two_D*uh);
  field c2 = sqr(field(two_Duh(0,0))) + sqr(field(two_Duh(1,1))) + 2*sqr(field(two_Duh(0,1)));
  return sqrt(Re*c1 + c2);
}
int main (int argc, char**argv) {
  if (argc < 2) {
    cerr << "usage: " << argv[0] << " <geo> <Re> <Delta t> <T> <hcoef> <hmin>" << endl;
    exit (1);
  }
  geo  omega_h (argv[1]);
  Float Re      = (argc > 2) ? atof(argv[2]) : 100;
  Float delta_t = (argc > 3) ? atof(argv[3]) : 0.2;
  Float T       = (argc > 4) ? Float(atof(argv[4])) : Re/5;
  adapt_option_type options;
  options.hcoef = (argc > 5) ? atof(argv[5]) :  2;
  options.hmin  = (argc > 6) ? atof(argv[6]) :  0.004;
  size_t n_max = int (T/delta_t + 0.5);
  cerr << noverbose
       << "# omega_h = " << omega_h.name() 
       << " delta_t = " << delta_t
       << " T = " << T
       << " hcoef = " << options.hcoef 
       << " hmin = " << options.hmin 
       << endl
       << "# t   |u|   nelt" << endl;
  space Vh = cavity_space (omega_h, "P2");
  field uh = cavity_field (Vh, 1);
  field  fh (Vh, 0.);
  branch event ("t","u");
  for (size_t n = 0; n <= n_max; n++) { 
    Float t = Float(n)*delta_t;
    uh = solve (fh, Re/delta_t);
    form m (Vh, Vh, "mass");
    cerr << t << " " << sqrt(m(uh,uh)) << " " << omega_h.size() << endl;
    cout << event (t, uh);
    if (n == n_max) break;
    field ch = criteria(Re, uh);
    omega_h  = geo_adapt(ch, options);
    omega_h.save();
    Vh = cavity_space (omega_h, "P2");
    uh = interpolate (Vh, uh);
    geomap X (Vh, -delta_t*uh);
    fh = (Re/delta_t)*compose (uh, X);
  }
}
