//
// ** necessite rheolef-3.42 ou plus ***
//
// usage:
//	stokes-micro micro > micro.mfield
//	mfield -u -velocity micro
//
// authors: Jerome Monnier and Pierre saramito
//
// date: february 2001
//
#include "rheolef/rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

const float Us = -0.1;
Float g( const point& x ) { return -10; }

int main(int argc, char**argv) {

  geo  omega (argv[1]);
  bool have_micro = omega.has_domain("micro");
  bool have_libre = omega.has_domain("libre");

  space Vh (omega, "P2", "vector") ;
  space Qh (omega, "P1") ;
  Vh.block("adherence");
  Vh.block("adherence");
  Vh.block("plaque"); 
  Vh.block("plaque");
  if (have_micro) {
    Vh[0].block("micro") ;
  }
  field uh (Vh);
  uh["adherence"] = 0;
  uh[0]["plaque"] = 0;
  uh[1]["plaque"] = Us;
  if (have_micro) {  
     uh[0]["micro"] = 0;
  }
  space V0 = space(Vh[0]);
  space V1 = space(Vh[1]);
  field f0h(V0,0.);
  field f1h(V1,0.);
  if (have_micro) { 
    // --  CL de glissement sur partie micro
    //             => terme source du type: \int g * u2 ds 
    //              avec g = -(beta*Us + 1/2*grad(sigma))
    space V_micro (omega,omega["micro"],"P2");
    form mb (V_micro,V1,"mass");  
    field gh = interpolate(V_micro,g);
    f1h["micro"] = mb*gh; 
    V_micro.check();
  }
  if (have_libre) { 
    // --  CL de pression exterieure
    //             => terme source du type: \int -pext * u1 ds
    space V_libre (omega,omega["libre"],"P2");
    field pext (V_libre, -1.);
    form mb (V_libre,V0,"mass");
    f0h["libre"] = mb*pext;
  }
  field fh = fld_cat2 (f0h,f1h);

  field ph (Qh, 0.);
  form a (Vh, Vh, "2D_D");
  if (have_micro){
    form ab;
    form ab00 = form_nul (V0,V0);
    form ab01 = form_nul (V1,V0);
    form ab11 (V1,V1,"mass",omega["micro"]);
    form_manip ab_manip;
    ab_manip << size(2,2) 
  	     <<    ab00     << ab01
    	     << trans(ab01) << ab11;
    ab_manip >> ab;
    a = a + ab;
  }
  form b (Vh, Qh, "div");
  int   max_iter  = 50;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, fh.u-(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
}
