#include "rheolef/rheolef.h"
using namespace rheolef;
using namespace std;

Float g (const point& x) { return -x[1];}

int main (int argc, char** argv) {
  field wh;
  cin >> wh;
  string option =  (wh.n_component() == 3) ? "vector" : "scalar";
  const geo& omega = wh.get_geo();
  space Ph (omega, "P2", option);
  Ph.block("adherence");
  Ph.block("plaque");
  form m (wh.get_space(), Ph, "mass");
  form c (Ph,  Ph, "grad_grad");
  field psih (Ph);
  psih["adherence"] = 0;
  space P_plaque (omega, omega["plaque"], "P2");
  psih["plaque"] = interpolate(P_plaque, g);
  ssk<Float> fact_c (c.uu);
  psih.u = fact_c.solve (m.uu*wh.u + m.ub*wh.b - c.ub*psih.b);
  cout << catchmark("psi") << psih;
  return 0;
}

