#ifndef _RHEO_GRAD_GRAD_H
#define _RHEO_GRAD_GRAD_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:grad_grad
NAME: @code{grad_grad} -- -Laplacian operator
@bfindex grad_grad
@cindex Laplacian
@apindex P1
@apindex P2
@apindex P1d
SYNOPSIS:
    @example
      form(const space V, const space& V, "grad_grad");
    @end example
DESCRIPTION:       
    @noindent
    Assembly the form associated to the
    Laplacian operator on a finite element space @code{V}:
@iftex  
@tex
    $$ 
      a(u,v) = \int_\Omega \nabla u . \nabla v \, dx
    $$ 
@end tex
@end iftex  
@ifnottex  
    @example
               /
               |
      a(u,v) = |  grad(u).grad(v) dx
               |
               / Omega
    @end example
@end ifnottex  
    @noindent
    The V space may be a either
    @code{P1} , @code{P2}  or @code{P1d}  finite element space.
    See also @ref{form class} and @ref{space class}.

EXAMPLE:
    @noindent
    The following piece of code build the Laplacian form
    associated to the @code{P1} approximation:
    @example
   	geo g("square");
   	space V(g, "P1");
   	form a(V, V, "grad_grad");
    @end example
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
DATE:
    28 november 1997
End:
*/

#include "rheolef/form_element_rep.h"
namespace rheolef { 

class grad_grad: public form_element_rep {

public:
// allocator:

    grad_grad() : form_element_rep() {}

// virtual accessor:

    void operator() (const geo_element& K, ublas::matrix<Float>& m) const;
    size_type n_derivative() const;
    void check_after_initialize () const;
};
}// namespace rheolef
#endif // _RHEO_GRAD_GRAD_H
