///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// mass matrix on a surface, as defined by a level set
//
#include "grad_grad_s.h"
#include "rheolef/ublas_matrix_range.h"
namespace rheolef {
extern void compute_matrix_a (const geo_element& K, const ublas::vector<point>& x, const ublas::vector<Float>& f, ublas::matrix<Float>& mk);
} // namespace rheolef
using namespace rheolef;
using namespace std;
using namespace ublas;

void 
grad_grad_s::operator() (const geo_element& K, ublas::matrix<Float>& m) const
{
    size_type nloc = K.size();
    ublas::vector<point> x (nloc);
    ublas::vector<Float> f (nloc);
    tiny_vector<size_t> bgd_idof (nloc);
    m.resize (nloc, nloc);
    const space& Bh = get_first_space();
    Bh.set_global_dof (K, bgd_idof);
    const field& phi_h = _wh;
    const geo& bgd_lambda = phi_h.get_geo();
    for (size_t iloc = 0; iloc < nloc; iloc++) {
      x[iloc] = bgd_lambda.vertex(K[iloc]);
      f[iloc] = phi_h.at (bgd_idof[iloc]);
    }
    compute_matrix_a (K, x, f, m);
}
void
grad_grad_s::check_after_initialize () const
{
  // suppose also that multi-component spaces are homogeneous,
  // i.e. that all components have the same approx
  check_macro (get_first_space() == get_second_space(), "incompatible spaces for the `grad_grad_s' form.");
  check_macro (get_first_space().n_component() == get_second_space().n_component(),
    "incompatible spaces for the `grad_grad_s' form.");
  check_macro (get_first_space().n_component() == 1,
    "incompatible non-scalar spaces for the `grad_grad_s' form.");
  check_macro (get_first_space().get_approx() == "P1", "`grad_grad_s' form: P1 approx required");
  check_macro (is_weighted(), "`grad_grad_s' form may specify the level set function");
}
