#ifndef _RHEOLEF_TENSOR_EIG3_H
#define _RHEOLEF_TENSOR_EIG3_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
namespace rheolef { 
// Eigen-decomposition for symmetric 3x3 real matrices.
// inspirated from the public domain Java library JAMA

// Symmetric matrix A => eigenvectors in columns of V, corresponding
//   eigenvalues in d
template<class T>
void eigen_decomposition (const tensor_basic<T>& A, tensor_basic<T>& V, point_basic<T>& d);

}// namespace rheolef
#endif // _RHEOLEF_TENSOR_EIG3_H
