#ifndef _RHEO_CAD_DOMAIN_H
#define _RHEO_CAD_DOMAIN_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/cad_element.h"
namespace rheolef { 

struct cad_domain : public std::vector<cad_element> {

// typedefs:

	typedef cad_element::size_type size_type;

// allocators:

	cad_domain();

// accessors:

	std::string name() const;

// input/outputs:

	void put_rheo(std::ostream& os) const;

// data:
        size_type           	 _dim;
	std::string              _name;
	std::vector<std::string> _boundary;
	std::vector<std::string> _lowdim;
};
// --------------------------------------------------------------------------
// inlined
// --------------------------------------------------------------------------
inline
cad_domain::cad_domain()
 : std::vector<cad_element>(), 
   _dim(0), 
   _name(), 
   _boundary(), 
   _lowdim() 
{
}
inline
std::string
cad_domain::name() const
{
	return _name;
}
}// namespace rheolef
#endif // _RHEO_CAD_DOMAIN_H
