///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "bubble_numbering.h"
#include "rheolef/geo.h"
namespace rheolef {
using namespace std;

template <class T, class M>
std::string
numbering_bubble<T,M>::name() const
{
  return "bubble";
}
template <class T, class M>
typename numbering_bubble<T,M>::size_type
numbering_bubble<T,M>::degree () const
{
  return 0;
}
template <class T, class M>
void
numbering_bubble<T,M>::set_degree (size_type degree) const
{
    check_macro (degree == 0, "cannot change `"<<name()<<"' degree to " << degree);
}
template <class T, class M>
bool
numbering_bubble<T,M>::is_continuous () const
{
  return false;
}
template <class T, class M>
typename numbering_bubble<T,M>::size_type
numbering_bubble<T,M>::ndof (
        const geo_size& gs, 
        size_type       map_dim) const
{
  return gs.ownership_by_dimension [map_dim].size();
}
template <class T, class M>
typename numbering_bubble<T,M>::size_type
numbering_bubble<T,M>::dis_ndof (
        const geo_size& gs, 
        size_type       map_dim) const
{
  return gs.ownership_by_dimension [map_dim].dis_size();
}
template <class T, class M>
void
numbering_bubble<T,M>::dis_idof (
        const geo_size&       gs, 
	const geo_element&    K, 
	std::vector<size_type>&    dis_idof) const
{
  dis_idof.resize (1);
  dis_idof [0] = K.dis_ie();
}
// -------------------------------------------------------------
// permut to/from ios dof numbering, for distributed environment
// -------------------------------------------------------------
template <class T, class M>
static 
void
bubble_set_ios_permutations (
    const geo_basic<T,M>& omega,
    array<distributor::size_type,M>&   idof2ios_dis_idof,
    array<distributor::size_type,M>&   ios_idof2dis_idof)
{
}
#ifdef _RHEOLEF_HAVE_MPI
template <class T>
static 
void
bubble_set_ios_permutations (
    const geo_basic<T,distributed>& omega,
    array<distributor::size_type,distributed>&   idof2ios_dis_idof,
    array<distributor::size_type,distributed>&   ios_idof2dis_idof)
{
  typedef distributor::size_type size_type;
  size_type idof_dim = omega.map_dimension(); // dof are located on elements of dim=map_dimension
  distributor ownership = omega.geo_element_ownership(idof_dim);
  distributor ios_ownership = omega.geo_element_ios_ownership(idof_dim);
  idof2ios_dis_idof.resize  (ownership);
  ios_idof2dis_idof.resize  (ios_ownership);
  for (size_type idof = 0, ndof = ownership.size(); idof < ndof; idof++) {
    idof2ios_dis_idof [idof] = omega.ige2ios_dis_ige (idof_dim, idof);
  }
  for (size_type ios_idof = 0, ios_ndof = ios_ownership.size(); ios_idof < ios_ndof; ios_idof++) {
    ios_idof2dis_idof [ios_idof] = omega.ios_ige2dis_ige (idof_dim, ios_idof);
  }
}
#endif // _RHEOLEF_HAVE_MPI
template <class T, class M>
void
numbering_bubble<T,M>::set_ios_permutations (
    const geo_basic<T,M>& omega,
    array<size_type,M>&   idof2ios_dis_idof,
    array<size_type,M>&   ios_idof2dis_idof) const
{
    bubble_set_ios_permutations (omega, idof2ios_dis_idof, ios_idof2dis_idof);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------

template class numbering_bubble<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class numbering_bubble<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
