///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/mass.h"

namespace rheolef {
using namespace std;
using namespace ublas;

template<class T, class M>
void 
mass<T,M>::operator() (const geo_element& K, ublas::matrix<T>& m) const
{
  base::build_general_mass (K, m);
}
template<class T, class M>
void
mass<T,M>::initialize () const
{
  // suppose also that multi-component spaces are homogeneous,
  // i.e. that all components have the same approx
  check_macro (base::get_first_space().size() == base::get_second_space().size(),
    "incompatible spaces for the `mass' form.");

  base::set_n_derivative(0);
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template class mass<Float,sequential>;

#ifdef _RHEOLEF_HAVE_MPI
template class mass<Float,distributed>;
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
