#ifndef _RHEOLEF_DISTO_H
#define _RHEOLEF_DISTO_H
#include "rheolef/point.h"
namespace rheolef {
// P_order piola-triangle transformation here
template <class T>
struct disto_t : std::unary_function<point_basic<T>,point_basic<T> > {
  point_basic<T> operator() (const point_basic<T>& x) const {
    point_basic<T> Fx;
    Fx[0] = x[0] + a*pow(x[0]+  x[1], order);
    Fx[1] = x[1] + b*pow(x[0]+2*x[1], order);
    return Fx;
  }
  disto_t(size_t order1) : order(order1), a(T(1)/T(10*order)), b(T(1)/T(7*order)) {}
  size_t order; T a, b;
};
} // namespace rheolef
#endif // _RHEOLEF_DISTO_H
