#ifndef _SKIT_BLAS1_MIXT_TMPL_H
#define _SKIT_BLAS1_MIXT_TMPL_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// blas 1 
// sparse vectors / dense vector
// expressions with template expression
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 march 1997
//
# include "rheolef/config.h"

namespace rheolef { 
// ===================[ SPARSE VEC MUL DENSE VEC ]===============================
template<class SX, class Y>
class sxmuly {
  public:
    typedef mul_op<typename SX::element_type,
	           typename Y::element_type>::result_type element_type;
    typedef pair<Index, element_type> value_type;
    typedef typename SX::const_iterator sx_const_iterator;
    typedef typename Y::const_iterator  y_const_iterator;
    class const_iterator {
      public:
        pair<Index,Float> operator*()
        { 
	    pair<Index,Float> p = *ITER_SX;
	    return pair<Index,Float>( p.first, p.second*RAND_Y[p.first]);
	}
        void operator++() { ++ITER_SX; }
	friend bool operator == (const_iterator p, const_iterator q)
	  { return p.ITER_SX == q.ITER_SX; }
#ifndef TOCLEAN
	friend bool operator != (const_iterator p, const_iterator q)
	  { return p.ITER_SX != q.ITER_SX; }
#endif // TOCLEAN
        const_iterator (sx_const_iterator iter_sx, y_const_iterator rand_y)
          : ITER_SX(iter_sx), RAND_Y(rand_y) {}
      private:
	  sx_const_iterator ITER_SX;
	  y_const_iterator  RAND_Y;
    };
    Index size() const { return SIZE; }
    Index n() const { return N; }
    const_iterator begin() const { return const_iterator(SX_BEGIN, Y_BEGIN); }
    const_iterator end() const { return const_iterator(SX_END, Y_BEGIN); }
    sxmuly (sx_const_iterator sx_begin, sx_const_iterator sx_end, 
	    y_const_iterator y_begin, Index m, Index sz) 
      : SX_BEGIN(sx_begin),   SX_END(sx_end), Y_BEGIN(y_begin), N(m), SIZE(sz) {}
  private:
    sx_const_iterator SX_BEGIN;
    sx_const_iterator SX_END;
    y_const_iterator  Y_BEGIN;
    const Index       N; 
    const Index       SIZE; 
};
// ------------------------------------------------------------------------------
}// namespace rheolef
#endif // _SKIT_BLAS1_MIXT_TMPL_H
