#include "rheolef.h"
using namespace std;
using namespace rheolef;
Float phi (const point& x) { return norm(x) - 1; }
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  geo lambda (argv[1]);
  space Xh (lambda, "P1");
  field phi_h = interpolate(Xh, phi);
  band gh (phi_h);
  space Bh (gh.band(), "P1");
  Bh.block ("isolated");
  Bh.unblock ("zero");
  // it was a bug when a geo_domain was used as a domain:
  field phi_h_band = phi_h [gh.band()];
  dout << catchmark("phi")      << phi_h
       << catchmark("phi_band") << phi_h_band;
}
