//rolestack.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _ROLESTACK_H_
#define _ROLESTACK_H_

#include <roaraudio.h>

enum rs_action {
 RS_ERROR = -1,
 RS_MIX = 0,
 RS_KICK,
 RS_MUTE,
 RS_PAUSE
};

struct rolestack {
 int index;
 int role;
 enum rs_action action;
};

void rolestack_init(void);
void print_rolestack(void);

const struct rolestack * rolestack_get_role(int role);
int rolestack_push(const struct rolestack * role);

enum rs_action rolestack_str2action(const char * str);
const char * rolestack_action2str(enum rs_action action);

const struct rolestack * rolestack_parse(const char * str);

#endif

//ll
