
#line 3 "lexer/theme-lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 1
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yynoreturn yy_fatal_error (yyconst char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 78
#define YY_END_OF_BUFFER 79
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_acclist[381] =
    {   0,
       79,   73,   78,   21,   73,   78,   71,   78,   73,   78,
       13,   73,   78,    9,   73,   78,   73,   78,   73,   78,
       73,   78,    7,   78,    5,    7,   78,    7,   78,    7,
       78,    7,   78,   76,   78,   22,   76,   78,   76,   78,
       76,   78,   76,   78,   33,   76,   78,   46,   76,   78,
       47,   76,   78,   76,   78,   48,   76,   78,   51,   76,
       78,   27,   76,   78,   24,   76,   78,   76,   78,   70,
       76,   78,   70,   76,   78,   70,   76,   78,   70,   76,
       78,   70,   76,   78,   70,   76,   78,   70,   76,   78,
       70,   76,   78,   70,   76,   78,   70,   76,   78,   70,

       76,   78,   70,   76,   78,   70,   76,   78,   70,   76,
       78,   70,   76,   78,   49,   76,   78,   70,   76,   78,
       70,   76,   78,   70,   76,   78,   70,   76,   78,   70,
       76,   78,   70,   76,   78,   70,   76,   78,   75,   76,
       78,   76,   78,   50,   76,   78,   77,   78,   16,   77,
       78,   77,   78,   17,   77,   78,   20,   77,   78,   77,
       78,   14,   77,   78,   74,   78,   21,   74,   78,   74,
       78,   19,   74,   78,   74,   78,   23,   74,   78,   19,
       74,   78,   15,   74,   78,   12,   78,   10,   12,   78,
       12,   78,   12,   78,   11,   12,   78,   21,   72,    2,

        1,    6,   22,   28,   27,   29,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       31,   70,   30,   70,   70,   70,   32,   70,   70,   75,
       17,   20,   19,   19,   26,   70,   70,   70,   70,   63,
       70,   70,   70,   70,   43,   70,   44,   70,   70,   70,
       70,   64,   70,   42,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   70,   19,   39,
       58,   70,   70,   45,   70,   35,   70,   53,   70,   65,
       70,   70,   43,   70,   70,   57,   70,   70,   42,   70,

       70,   70,   70,   70,   70,   66,   70,   70,   70,   54,
       70,   70,   70,   70,   25,   70,   19,   40,   70,   70,
       70,   56,   70,   70,   34,   70,   55,   70,   70,   70,
       70,   70,   70,   18,   19,    4,   52,   70,   70,   59,
       70,   70,   70,   70,   70,   70,    3,   38,   70,   70,
       70,   70,   70,   36,   70,   70,   70,   70,   70,   68,
       70,   37,   70,   70,   70,   60,   70,   67,   70,   62,
       70,   70,   70,   69,   70,   70,    8,   61,   70,   41
    } ;

static yyconst flex_int16_t yy_accept[295] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    2,    4,    7,    9,   11,
       14,   17,   19,   21,   23,   25,   28,   30,   32,   34,
       36,   39,   41,   43,   45,   48,   51,   54,   56,   59,
       62,   65,   68,   70,   73,   76,   79,   82,   85,   88,
       91,   94,   97,  100,  103,  106,  109,  112,  115,  118,
      121,  124,  127,  130,  133,  136,  139,  142,  144,  147,
      149,  152,  154,  157,  160,  162,  165,  167,  170,  172,
      175,  177,  180,  183,  186,  188,  191,  193,  195,  198,
      199,  200,  201,  202,  202,  202,  202,  202,  203,  203,

      203,  203,  204,  204,  205,  205,  205,  205,  205,  206,
      206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
      216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
      226,  227,  228,  229,  230,  231,  233,  235,  236,  237,
      239,  240,  241,  242,  243,  244,  245,  245,  245,  245,
      245,  245,  245,  245,  245,  246,  247,  248,  249,  250,
      252,  253,  254,  255,  257,  259,  260,  261,  262,  264,
      266,  267,  268,  269,  270,  271,  272,  273,  274,  275,
      276,  277,  278,  279,  280,  280,  280,  280,  280,  280,
      281,  283,  284,  286,  288,  290,  292,  293,  295,  296,

      298,  299,  301,  302,  303,  304,  305,  306,  308,  309,
      310,  312,  313,  314,  315,  317,  318,  318,  318,  318,
      319,  320,  321,  322,  324,  325,  327,  329,  330,  331,
      332,  333,  333,  334,  336,  336,  337,  337,  337,  339,
      340,  342,  342,  343,  344,  345,  346,  346,  347,  348,
      348,  349,  350,  350,  351,  352,  353,  354,  354,  356,
      356,  356,  357,  357,  358,  359,  360,  362,  362,  362,
      363,  364,  364,  365,  366,  368,  368,  368,  370,  371,
      372,  373,  373,  373,  374,  376,  376,  376,  377,  377,
      378,  380,  381,  381

    } ;

static yyconst YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    5,    1,    6,    7,    1,    8,    1,    1,    9,
       10,   11,   12,   13,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,   18,   19,    1,
        1,    1,    1,   20,   21,   22,   23,   24,   25,   26,
       27,   28,   29,   30,   31,   32,   33,   34,   35,   36,
       30,   37,   38,   39,   40,   41,   42,   30,   43,   44,
       45,    1,   46,    1,    1,    1,   47,   48,   49,   50,

       51,   52,   53,   54,   55,   30,   56,   57,   58,   59,
       60,   61,   30,   62,   63,   64,   65,   66,   67,   68,
       69,   70,   71,    1,   72,    1,    1,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   73,   73,   73,   73,   73,   73,   73,   73,   73,
       73,   74,   74,   75,   75,   75,   75,   75,   75,   75,

       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   77,
       77,   77,   77,   77,   74,   74,   74,   74,   74,   74,
       74,   74,   74,   74,   74
    } ;

static yyconst YY_CHAR yy_meta[78] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    1,    1,    4,    1,    1,    1,
        5,    5,    5,    5,    5,    5,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    1,    1,    5,    5,    5,    5,
        5,    5,    6,    6,    6,    6,    6,    6,    6,    6,
        6,    6,    6,    6,    6,    6,    6,    6,    6,    6,
        1,    1,    2,    2,    1,    1,    1
    } ;

static yyconst flex_uint16_t yy_base[323] =
    {   0,
        0,   10,   32,   37,   59,    0,  136,  213,  290,  367,
      444,  521,  156,  163,  652,  776,    4,  776,  618,  776,
      776,    8,   98,  115,  776,  776,  612,  163,   11,  776,
       23,  604,  167,    0,  776,  776,  776,  584,  776,   34,
       14,  776,    0,    0,  128,  145,  155,   11,  127,  210,
      135,  170,  214,  214,  214,  203,  132,  146,  776,  510,
      279,  260,  513,  207,  487,  276,    0,   35,  776,  776,
      776,  546,   42,    0,   41,  776,  776,  182,  542,    0,
      174,  776,  484,  776,  776,  776,  511,  175,  776,  190,
      776,  776,  776,  447,  448,  216,  188,  249,  428,  425,

      422,  196,  274,  277,  408,  405,  401,    0,   39,  454,
        0,    0,  225,  280,  274,  277,  292,  283,  301,  294,
      300,  307,  313,  347,  364,  367,  369,  360,  356,  373,
      359,  373,  362,  363,  415,    0,    0,  410,  381,    0,
      411,    0,  318,    0,    0,  377,  370,  376,  376,  349,
      346,  334,  331,    0,  381,  379,  366,  377,  382,    0,
      422,  387,  436,  445,    0,  437,  445,  433,    0,  452,
      443,  448,  440,  451,  448,  449,  459,  448,  449,  347,
      328,  308,  307,  287,  284,  284,  456,  255,  254,    0,
        0,  484,    0,    0,    0,    0,  494,    0,  513,    0,

      515,    0,  514,  523,  520,  519,  513,    0,  515,  524,
        0,  293,  218,  206,    0,  198,  194,  185,  527,    0,
      519,  522,  535,    0,  199,    0,    0,  534,  525,  530,
      540,    0,  145,    0,  129,  776,  525,    0,    0,  544,
        0,  560,  549,  570,  570,  579,    0,  113,  776,  565,
        0,  565,  584,  578,  571,  576,  579,    0,    0,  591,
        0,  593,  580,  581,  594,  595,    0,    0,  583,  776,
      591,  586,  593,  596,    0,    0,  605,    0,  776,  597,
      600,    0,  607,  617,    0,    0,  616,  623,    0,  776,
        0,  776,  776,  677,  683,  689,  695,  701,  707,  713,

      719,  722,  725,  727,  731,  735,  739,  742,  744,  746,
      748,  750,  752,  754,  756,  758,  760,  762,  764,  766,
      768,  770
    } ;

static yyconst flex_int16_t yy_def[323] =
    {   0,
      294,  294,  295,  295,  293,    5,  296,  296,  297,  297,
      298,  298,  299,  299,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  300,  293,  293,
      293,  293,  301,  302,  293,  293,  293,  293,  293,  293,
      293,  293,  303,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  293,  304,
      304,  304,  304,  304,  304,  304,  305,  293,  293,  293,
      293,  293,  293,  306,  293,  293,  293,  293,  293,  307,
      293,  293,  307,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  300,  300,  293,  293,

      293,  293,  301,  301,  293,  293,  293,  308,  293,  293,
      303,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  305,  293,  306,  307,  307,  293,  293,  293,  293,
      293,  293,  293,  309,  293,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  307,  293,  293,  293,  293,  293,  310,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,

      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  307,  293,  293,  293,  311,
      304,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  312,  304,  307,  293,  293,  293,  313,  304,  304,
      304,  293,  304,  304,  304,  304,  314,  304,  293,  293,
      315,  304,  293,  304,  304,  304,  304,  316,  304,  293,
      317,  304,  293,  304,  304,  304,  304,  318,  293,  293,
      304,  293,  304,  304,  304,  319,  293,  304,  293,  304,
      304,  320,  293,  304,  304,  321,  293,  304,  322,  293,
      304,  293,    0,  293,  293,  293,  293,  293,  293,  293,

      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293
    } ;

static yyconst flex_uint16_t yy_nxt[854] =
    {   0,
      293,   17,   18,   19,   17,   90,   20,  293,   90,  293,
       21,   17,   18,   19,   17,   22,   20,  293,   92,   23,
       21,   92,   24,   93,  102,   22,   93,  102,  110,   23,
      109,  118,   24,   26,   18,   27,   26,   28,   26,   18,
       27,   26,   28,  143,   92,   92,  143,   29,   24,   93,
       93,   92,   29,  110,  293,  109,   93,  118,   24,   30,
       31,   18,   32,   31,   33,   34,   35,   36,   37,   30,
       38,   39,   38,   30,   40,   41,   30,   42,   43,   44,
       45,   46,   47,   48,   44,   49,   50,   51,   44,   44,
       44,   44,   52,   44,   44,   53,   54,   55,   56,   57,

       58,   44,   44,   59,   30,   60,   45,   61,   47,   62,
       63,   49,   50,   64,   44,   44,   44,   52,   44,   65,
       53,   54,   66,   56,   57,   58,   44,   44,   44,   30,
       30,   30,   30,   30,   30,   30,   30,   31,   18,   32,
       31,   30,   30,   30,   30,   30,   30,   30,   39,   96,
       30,   68,   94,   30,   30,   30,  133,   86,   18,   87,
       86,   95,  113,  119,   86,   18,   87,   86,   98,  114,
      134,   88,  104,  123,   96,  116,  259,  115,   88,  117,
       30,   69,  133,   90,   92,   92,   90,  113,  119,   93,
       93,   90,  249,   98,   90,  114,  134,  102,  123,  248,

      102,  116,  115,  242,  124,  117,   30,   30,   30,   30,
       30,   30,   30,   30,   31,   18,   32,   31,   30,   30,
       30,   30,   30,   30,   30,   39,   89,   30,   68,  124,
       30,   30,   30,   89,  125,  236,  132,   99,  100,  101,
      126,  105,  106,  107,  120,  123,  127,  121,  128,  149,
      130,  122,  129,  131,   98,  235,  156,   30,   69,  234,
      125,  132,   99,  100,  101,  139,  126,  233,  215,  120,
      123,  127,  121,  128,  149,  130,  122,  129,  131,  104,
      118,  156,  104,   30,   30,   30,   30,   30,   30,   30,
       70,   71,   18,   72,   71,   70,   70,   70,   70,   70,

       70,   70,   73,  114,   71,   75,  118,   70,   70,   70,
      232,  115,  130,  157,  159,  131,  158,  137,  160,  143,
      161,  162,  143,   99,  100,  101,  103,   97,  165,  114,
      163,  164,  136,  166,   70,   70,  115,  141,  157,  159,
      131,  218,  158,  217,  160,  161,  216,  162,  105,  106,
      107,  105,  106,  107,  165,  163,  164,  215,  214,  166,
       76,   70,   70,   70,   70,   70,   70,   70,   71,   18,
       72,   71,   70,   70,   70,   70,   70,   70,   70,   73,
      167,   71,   75,  168,   70,   70,   70,  169,  170,  171,
      213,  172,  174,  175,  212,  176,  177,  155,  178,  173,

      179,  187,  191,  189,  192,  167,  103,  193,  168,  194,
      196,   70,   70,  169,  170,  171,  172,  174,  188,  175,
      176,   97,  177,  178,  173,  179,  186,  187,  191,  192,
      185,  175,  193,  184,  182,  194,  196,   76,   70,   70,
       70,   70,   70,   70,   77,   78,   18,   79,   78,   77,
       77,   77,   77,   77,   77,   77,   77,  175,   77,   81,
      195,   82,   77,   77,  197,  198,  181,  180,  199,  200,
      155,  201,  202,  153,  203,  183,  204,  152,  205,  206,
      103,  207,  208,  209,  219,  195,  210,  211,   77,   77,
      197,  198,   83,  199,  151,  200,  201,  150,  202,  203,

       97,  148,  204,  205,  147,  206,  207,  208,  221,  209,
      219,  210,  211,   91,   77,   84,   77,   77,   77,   77,
       77,   77,   78,   18,   79,   78,   77,   77,   77,   77,
       77,   77,   77,   77,  221,   77,   81,  222,   82,   77,
       77,  223,  224,  146,   91,  225,  226,  227,   91,  228,
      229,  230,  231,  237,  140,  239,  240,  241,  243,  138,
      244,  245,  246,  222,  250,   77,   77,  223,  224,   83,
      225,  135,  226,  227,  228,  229,  230,  252,  231,  237,
      239,  240,  253,  241,  243,  244,  245,  254,  246,  250,
      255,   77,   84,   77,   77,   77,   77,   77,  256,  257,

      109,  260,  252,  262,  263,  264,   91,  265,  253,  266,
      267,  269,  254,  271,   91,  272,  255,  273,  274,  275,
       91,  277,  278,  279,  256,  257,  260,  280,  262,  281,
      263,  264,  265,  283,  266,  267,  284,  269,  285,  271,
      272,  287,  273,  288,  274,  275,  277,  278,  279,  290,
      291,  293,  280,  293,  281,  293,  293,  293,  293,  283,
      293,  284,  293,  285,  293,  293,  287,  293,  293,  288,
      293,  293,  293,  293,  290,  293,  291,   16,   16,   16,
       16,   16,   16,   25,   25,   25,   25,   25,   25,   67,
       67,   67,   67,   67,   67,   74,   74,   74,   74,   74,

       74,   80,   80,   80,   80,   80,   80,   85,   85,   85,
       85,   85,   85,   97,  293,   97,   97,   97,   97,  103,
      293,  103,  103,  103,  103,  108,  108,  111,  111,  111,
      111,  112,  112,  142,  142,  142,  142,  144,  144,  144,
      144,  145,  145,  145,  145,  154,  154,  190,  190,  220,
      220,  238,  238,  247,  247,  251,  251,  258,  258,  261,
      261,  268,  268,  270,  270,  276,  276,  282,  282,  286,
      286,  289,  289,  292,  292,   15,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,

      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293
    } ;

static yyconst flex_int16_t yy_chk[854] =
    {   0,
        0,    1,    1,    1,    1,   17,    1,    0,   17,    0,
        1,    2,    2,    2,    2,    1,    2,    0,   22,    1,
        2,   29,    1,   22,   31,    2,   29,   31,   41,    2,
       41,   48,    2,    3,    3,    3,    3,    3,    4,    4,
        4,    4,    4,   73,   40,   68,   73,    3,    1,   40,
       68,   75,    4,  109,    0,  109,   75,   48,    2,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,

        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    7,    7,    7,    7,
        7,    7,    7,    7,    7,    7,    7,    7,    7,   24,
        7,    7,   23,    7,    7,    7,   57,   13,   13,   13,
       13,   23,   45,   49,   14,   14,   14,   14,   28,   46,
       58,   13,   33,   51,   24,   47,  248,   46,   14,   47,
        7,    7,   57,   78,   81,   88,   78,   45,   49,   81,
       88,   90,  235,   97,   90,   46,   58,  102,   51,  233,

      102,   47,   46,  225,   52,   47,    7,    7,    7,    7,
        7,    7,    7,    8,    8,    8,    8,    8,    8,    8,
        8,    8,    8,    8,    8,    8,   13,    8,    8,   52,
        8,    8,    8,   14,   53,  218,   56,   28,   28,   28,
       53,   33,   33,   33,   50,   64,   54,   50,   54,   96,
       55,   50,   54,   55,   98,  217,  113,    8,    8,  216,
       53,   56,   97,   97,   97,   64,   53,  214,  213,   50,
       64,   54,   50,   54,   96,   55,   50,   54,   55,  103,
       62,  113,  104,    8,    8,    8,    8,    8,    8,    8,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,

        9,    9,    9,   61,    9,    9,   62,    9,    9,    9,
      212,   61,   66,  114,  116,   66,  115,   62,  117,  143,
      118,  119,  143,   98,   98,   98,  189,  188,  122,   61,
      120,  121,   61,  123,    9,    9,   61,   66,  114,  116,
       66,  186,  115,  185,  117,  118,  184,  119,  103,  103,
      103,  104,  104,  104,  122,  120,  121,  183,  182,  123,
        9,    9,    9,    9,    9,    9,    9,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
      124,   10,   10,  124,   10,   10,   10,  125,  126,  127,
      181,  128,  129,  130,  180,  131,  132,  155,  133,  128,

      134,  149,  156,  153,  157,  124,  152,  158,  124,  159,
      162,   10,   10,  125,  126,  127,  128,  129,  151,  130,
      131,  150,  132,  133,  128,  134,  148,  149,  156,  157,
      147,  141,  158,  146,  139,  159,  162,   10,   10,   10,
       10,   10,   10,   10,   11,   11,   11,   11,   11,   11,
       11,   11,   11,   11,   11,   11,   11,  141,   11,   11,
      161,   11,   11,   11,  163,  164,  138,  135,  166,  167,
      110,  168,  170,  107,  171,  141,  172,  106,  173,  174,
      105,  175,  176,  177,  187,  161,  178,  179,   11,   11,
      163,  164,   11,  166,  101,  167,  168,  100,  170,  171,

       99,   95,  172,  173,   94,  174,  175,  176,  192,  177,
      187,  178,  179,   87,   11,   11,   11,   11,   11,   11,
       11,   12,   12,   12,   12,   12,   12,   12,   12,   12,
       12,   12,   12,   12,  192,   12,   12,  197,   12,   12,
       12,  199,  201,   83,   79,  203,  204,  205,   72,  206,
      207,  209,  210,  219,   65,  221,  222,  223,  228,   63,
      229,  230,  231,  197,  237,   12,   12,  199,  201,   12,
      203,   60,  204,  205,  206,  207,  209,  240,  210,  219,
      221,  222,  242,  223,  228,  229,  230,  243,  231,  237,
      244,   12,   12,   12,   12,   12,   12,   12,  245,  246,

       38,  250,  240,  252,  253,  254,   32,  255,  242,  256,
      257,  260,  243,  262,   27,  263,  244,  264,  265,  266,
       19,  269,  271,  272,  245,  246,  250,  273,  252,  274,
      253,  254,  255,  277,  256,  257,  280,  260,  281,  262,
      263,  283,  264,  284,  265,  266,  269,  271,  272,  287,
      288,   15,  273,    0,  274,    0,    0,    0,    0,  277,
        0,  280,    0,  281,    0,    0,  283,    0,    0,  284,
        0,    0,    0,    0,  287,    0,  288,  294,  294,  294,
      294,  294,  294,  295,  295,  295,  295,  295,  295,  296,
      296,  296,  296,  296,  296,  297,  297,  297,  297,  297,

      297,  298,  298,  298,  298,  298,  298,  299,  299,  299,
      299,  299,  299,  300,    0,  300,  300,  300,  300,  301,
        0,  301,  301,  301,  301,  302,  302,  303,  303,  303,
      303,  304,  304,  305,  305,  305,  305,  306,  306,  306,
      306,  307,  307,  307,  307,  308,  308,  309,  309,  310,
      310,  311,  311,  312,  312,  313,  313,  314,  314,  315,
      315,  316,  316,  317,  317,  318,  318,  319,  319,  320,
      320,  321,  321,  322,  322,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,

      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
      293,  293,  293
    } ;

extern int yy_flex_debug;
int yy_flex_debug = 0;

static yy_state_type *yy_state_buf=0, *yy_state_ptr=0;
static char *yy_full_match;
static int yy_lp;
#define REJECT \
{ \
*yy_cp = (yy_hold_char); /* undo effects of setting up yytext */ \
yy_cp = (yy_full_match); /* restore poss. backed-over text */ \
++(yy_lp); \
goto find_rule; \
}

#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "../lexer/theme-lexer.l"
/*
 * rofi
 *
 * MIT/X11 License
 * Copyright 2013-2017 Qball Cow <qball@gmpclient.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#line 35 "../lexer/theme-lexer.l"
#include <stdio.h>
#include <glib.h>
#include <helper.h>
#include <math.h>
#include <strings.h>
#include "rofi.h"
#include "theme.h"

#include "theme-parser.h"
#include "css-colors.h"

#define LOG_DOMAIN "Parser"
int last_state = 0;

/**
 * Type of Object to parse.
 */
typedef enum {
    /** Parse a file */
    PT_FILE,
    /** Parse a string */
    PT_STRING
} ParseType;

/**
 * Parse object
 */
typedef struct _ParseObject {
    /** Type */
    ParseType type;

    /** File pointer */
    FILE *filein;
    char *filename;

    /** Length of string  */
    int str_len;
    /** String */
    const char *input_str;
    /** Position in file */
    YYLTYPE  location;
} ParseObject;


GList  *imported_files = NULL;
GList  *prev_imported_files = NULL;
GQueue *file_queue = NULL;
GQueue *queue = NULL;

ParseObject *current = NULL;



static double rofi_theme_parse_convert_hex ( char high, char low)
{
    uint8_t retv = 0;

    int t = g_ascii_toupper ( high );
    t = ( t > '9')? (t-'A'+10):(t-'0');
    retv = t<<4;
    t = g_ascii_toupper ( low );
    t = ( t > '9')? (t-'A'+10):(t-'0');
    retv +=t;
    return retv/255.0;
}

#line 103 "../lexer/theme-lexer.l"

#define YY_INPUT(buf,result,max_size) \
{\
    if ( current == NULL ) {\
        result = 0;\
    } else {\
        switch ( current->type ) { \
            case PT_FILE:\
            {\
                errno =0; \
                while ( (result = (int) fread(buf, 1, max_size, current->filein))==0 && ferror(current->filein)) \
                { \
                    if( errno != EINTR) \
                    { \
                        YY_FATAL_ERROR( "input in flex scanner failed" ); \
                        break; \
                    } \
                    errno=0; \
                    clearerr(current->filein); \
                } \
                break;\
            }\
            case PT_STRING:\
            {\
                yy_size_t len = MIN (max_size, current->str_len);\
                if ( len > 0 ){\
                    memcpy (buf, current->input_str, len);\
                    current->input_str+=len;\
                    current->str_len-=len;\
                    result = len;\
                } else {\
                    result = 0;\
                }\
            }\
        }\
    }\
}


#define YY_USER_ACTION {\
    yylloc->last_column+= yyleng;\
}
#define YY_LLOC_START {\
    yylloc->first_line = yylloc->last_line;\
    yylloc->first_column = yylloc->last_column;\
}
// UANY    {ASC}|{U2}{U}|{U3}{U}{U}|{U4}{U}{U}{U}
// UONLY   {U2}{U}|{U3}{U}{U}|{U4}{U}{U}{U}
/* Position */
/* Line Style */
/* ANGLES */
/* LINE STYLE */
/* Orientation */
/* Color schema */






#line 951 "lexer/theme-lexer.c"

#define INITIAL 0
#define INCLUDE 1
#define PROPERTIES 2
#define PROPERTIES_LIST 3
#define NAMESTR 4
#define SECTION 5
#define DEFAULTS 6

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy (void );

int yyget_debug (void );

void yyset_debug (int debug_flag  );

YY_EXTRA_TYPE yyget_extra (void );

void yyset_extra (YY_EXTRA_TYPE user_defined  );

FILE *yyget_in (void );

void yyset_in  (FILE * _in_str  );

FILE *yyget_out (void );

void yyset_out  (FILE * _out_str  );

			int yyget_leng (void );

char *yyget_text (void );

int yyget_lineno (void );

void yyset_lineno (int _line_number  );

YYSTYPE * yyget_lval (void );

void yyset_lval (YYSTYPE * yylval_param  );

       YYLTYPE *yyget_lloc (void );
    
        void yyset_lloc (YYLTYPE * yylloc_param  );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param,YYLTYPE * yylloc_param );

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param )
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
        YYSTYPE * yylval;
    
        YYLTYPE * yylloc;
    
    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

        /* Create the reject buffer large enough to save one state per allowed character. */
        if ( ! (yy_state_buf) )
            (yy_state_buf) = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  );
            if ( ! (yy_state_buf) )
                YY_FATAL_ERROR( "out of dynamic memory in yylex()" );

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	{
#line 242 "../lexer/theme-lexer.l"



YY_LLOC_START


if ( queue == NULL ){
    queue = g_queue_new ( );
    yylloc->filename = current->filename;
    // unsure why todo this.
    yylloc->first_line = yylloc->last_line = 1;
    yylloc->first_column = yylloc->last_column = 1;
}


  /**
   * General code for handling comments.
   * Both C and C++ style comments, including nexting.
   */

#line 1218 "lexer/theme-lexer.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);

		(yy_state_ptr) = (yy_state_buf);
		*(yy_state_ptr)++ = yy_current_state;

yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 294 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
			*(yy_state_ptr)++ = yy_current_state;
			++yy_cp;
			}
		while ( yy_current_state != 293 );

yy_find_action:
		yy_current_state = *--(yy_state_ptr);
		(yy_lp) = yy_accept[yy_current_state];
find_rule: /* we branch to this label when backing up */
		for ( ; ; ) /* until we find what rule we matched */
			{
			if ( (yy_lp) && (yy_lp) < yy_accept[yy_current_state + 1] )
				{
				yy_act = yy_acclist[(yy_lp)];
					{
					(yy_full_match) = yy_cp;
					break;
					}
				}
			--yy_cp;
			yy_current_state = *--(yy_state_ptr);
			(yy_lp) = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
YY_RULE_SETUP
#line 262 "../lexer/theme-lexer.l"
{
    int c = input();
    while ( c != 0 && c != EOF){
        if (c == '\n') {
            yylloc->last_column = 1;
            yylloc->last_line ++;
            break;
        }
        yylloc->last_column++;
        c = input();
    }
    YY_LLOC_START
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 275 "../lexer/theme-lexer.l"
{
    int c = 0, p;
    int nesting_depth = 1;
    while (nesting_depth) {
        p = c;
        c = input();
        switch (c) {
        case '*': yylloc->last_column++; if (p == '/') { c = 0; nesting_depth++; } break;
        case '/': yylloc->last_column++; if (p == '*') { c = 0; nesting_depth--; } break;
        case '\n':  {
            yylloc->last_column = 1;
            yylloc->last_line ++;
            break;
        }
        case 0: nesting_depth = 0; break;
        case EOF: nesting_depth = 0; break;
        default:
            yylloc->last_column++;
        ;
        }
    }
    YY_LLOC_START
}
	YY_BREAK
/**
     * HANDLE INCLUDES
     */
case 3:
YY_RULE_SETUP
#line 302 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(INCLUDE);
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 306 "../lexer/theme-lexer.l"
{
    rofi_theme_reset();
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(INCLUDE);
}
	YY_BREAK
/** Skip all whitespace */
case 5:
YY_RULE_SETUP
#line 312 "../lexer/theme-lexer.l"
{}
	YY_BREAK
/** Parse path. Last element in this INCLUDE */
case 6:
YY_RULE_SETUP
#line 315 "../lexer/theme-lexer.l"
{
    yytext[yyleng-1] = '\0';
    ParseObject *top = g_queue_peek_head ( file_queue );
    g_assert ( top != NULL );
    char *file2 = helper_get_theme_path ( &yytext[1] );
    char *filename = rofi_theme_parse_prepare_file ( file2, top->filename );
    g_free ( file2 );
    if ( g_list_find_custom ( imported_files, filename, (GCompareFunc)g_strcmp0 ) != NULL ) {
        g_debug ( "Skipping file: '%s' already parsed.", filename );
    } else {
        g_debug ( "Parsing file: '%s'", filename );
        FILE *f = fopen ( filename, "rb" );
        if ( f ) {
            top->location = *yylloc;
            ParseObject *po = g_malloc0(sizeof(ParseObject));
            po->type = PT_FILE;
            po->filename = filename;
            po->filein = f;
            current = po;
            g_queue_push_head ( file_queue, po );
            imported_files = g_list_append ( imported_files, po->filename );

            yypush_buffer_state (yy_create_buffer ( 0, YY_BUF_SIZE ));
            yylloc->first_line = yylloc->last_line = 1;
            yylloc->first_column = yylloc->last_column = 1;
            yylloc->filename = current->filename;
        } else {
            char *str = g_markup_printf_escaped ( "Failed to open theme: <i>%s</i>\nError: <b>%s</b>",
                    filename, strerror ( errno ) );
            rofi_add_error_message ( g_string_new ( str ) );
            g_free ( str );
            g_free(filename);
        }
    }
    // Pop out of include. */
    BEGIN(GPOINTER_TO_INT(g_queue_pop_head ( queue )));
}
	YY_BREAK
/** Everythin not yet parsed is an error. */
case 7:
YY_RULE_SETUP
#line 353 "../lexer/theme-lexer.l"
{
    return T_ERROR_INCLUDE;
}
	YY_BREAK
/**
     * END INCLUDES
     */
/**
     * Handle defaults:  * { ... }
     */
case 8:
YY_RULE_SETUP
#line 365 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(DEFAULTS);
    return T_CONFIGURATION;

}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 371 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(DEFAULTS);
    return T_PDEFAULTS;
}
	YY_BREAK
/** Skip all whitespace */
case 10:
YY_RULE_SETUP
#line 377 "../lexer/theme-lexer.l"
{}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 378 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(SECTION);
    return T_BOPEN;
}
	YY_BREAK
/** Everythin not yet parsed is an error. */
case 12:
YY_RULE_SETUP
#line 384 "../lexer/theme-lexer.l"
{
    return T_ERROR_DEFAULTS;
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 388 "../lexer/theme-lexer.l"
{ g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) ); BEGIN(NAMESTR);return T_NAME_PREFIX;}
	YY_BREAK
/* Go into parsing an section*/
case 14:
YY_RULE_SETUP
#line 390 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(SECTION);
    return T_BOPEN;
}
	YY_BREAK
/* Pop out of parsing an section. */
case 15:
YY_RULE_SETUP
#line 396 "../lexer/theme-lexer.l"
{
    g_queue_pop_head ( queue );
    BEGIN(GPOINTER_TO_INT(g_queue_pop_head ( queue )));
    return T_BCLOSE;
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 402 "../lexer/theme-lexer.l"
{ return T_NSEP; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 403 "../lexer/theme-lexer.l"
{ return T_SSEP; }
	YY_BREAK
/* Alias color to text-color */
case 18:
YY_RULE_SETUP
#line 405 "../lexer/theme-lexer.l"
{ yylval->sval = g_strdup("text-color"); return T_PROP_NAME;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 406 "../lexer/theme-lexer.l"
{ yylval->sval = g_strdup(yytext); return T_PROP_NAME;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 407 "../lexer/theme-lexer.l"
{ yylval->sval = g_strdup(yytext); return T_NAME_ELEMENT;}
	YY_BREAK
/* After Namestr/Classstr we want to go to state str, then to  { */
case 21:
YY_RULE_SETUP
#line 410 "../lexer/theme-lexer.l"
; // ignore all whitespace
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 411 "../lexer/theme-lexer.l"
; // ignore all whitespace
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 413 "../lexer/theme-lexer.l"
{ g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) ); BEGIN(PROPERTIES); return T_PSEP; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 414 "../lexer/theme-lexer.l"
{ BEGIN(GPOINTER_TO_INT ( g_queue_pop_head ( queue ))); return T_PCLOSE;}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 415 "../lexer/theme-lexer.l"
{ yylval->bval= g_strcmp0(yytext, "true") == 0; return T_BOOLEAN;}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 416 "../lexer/theme-lexer.l"
{ yylval->fval = g_ascii_strtod(yytext, NULL); return T_DOUBLE;}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 417 "../lexer/theme-lexer.l"
{ yylval->ival = (int)g_ascii_strtoll(yytext, NULL, 10); return T_INT;}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 418 "../lexer/theme-lexer.l"
{ yytext[yyleng-1] = '\0'; yylval->sval = g_strcompress(&yytext[1]); return T_STRING;}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 420 "../lexer/theme-lexer.l"
{
    yylval->sval = g_strdup(yytext);
    return T_LINK;
}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 425 "../lexer/theme-lexer.l"
{ return T_UNIT_EM; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 426 "../lexer/theme-lexer.l"
{ return T_UNIT_CH; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 427 "../lexer/theme-lexer.l"
{ return T_UNIT_PX; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 428 "../lexer/theme-lexer.l"
{ return T_PERCENT; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 429 "../lexer/theme-lexer.l"
{ return T_SOLID;   }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 430 "../lexer/theme-lexer.l"
{ return T_DASH;    }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 432 "../lexer/theme-lexer.l"
{ return T_INHERIT; }
	YY_BREAK
/**
  * Color parsing. It is easier to do this at lexer level.
  * Other schemes are done at yacc level.
  */
case 37:
YY_RULE_SETUP
#line 438 "../lexer/theme-lexer.l"
{
    yylval->colorval.red   = rofi_theme_parse_convert_hex(yytext[1],yytext[2]);
    yylval->colorval.green = rofi_theme_parse_convert_hex(yytext[3],yytext[4]);
    yylval->colorval.blue  = rofi_theme_parse_convert_hex(yytext[5],yytext[6]);
    yylval->colorval.alpha = rofi_theme_parse_convert_hex(yytext[7],yytext[8]);
    return T_COLOR;
}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 445 "../lexer/theme-lexer.l"
{
    yylval->colorval.alpha = 1.0;
    yylval->colorval.red   = rofi_theme_parse_convert_hex(yytext[1],yytext[2]);
    yylval->colorval.green = rofi_theme_parse_convert_hex(yytext[3],yytext[4]);
    yylval->colorval.blue  = rofi_theme_parse_convert_hex(yytext[5],yytext[6]);
    return T_COLOR;
}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 452 "../lexer/theme-lexer.l"
{
    yylval->colorval.alpha = 1.0;
    yylval->colorval.red   = rofi_theme_parse_convert_hex(yytext[1],yytext[1]);
    yylval->colorval.green = rofi_theme_parse_convert_hex(yytext[2],yytext[2]);
    yylval->colorval.blue  = rofi_theme_parse_convert_hex(yytext[3],yytext[3]);
    return T_COLOR;
}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 459 "../lexer/theme-lexer.l"
{
    yylval->colorval.alpha = rofi_theme_parse_convert_hex(yytext[4],yytext[4]);
    yylval->colorval.red   = rofi_theme_parse_convert_hex(yytext[1],yytext[1]);
    yylval->colorval.green = rofi_theme_parse_convert_hex(yytext[2],yytext[2]);
    yylval->colorval.blue  = rofi_theme_parse_convert_hex(yytext[3],yytext[3]);
    return T_COLOR;
}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 466 "../lexer/theme-lexer.l"
{
    yylval->colorval.alpha = rofi_theme_parse_convert_hex(yytext[5],yytext[6]);
    yylval->colorval.red   = rofi_theme_parse_convert_hex(yytext[7],yytext[8]);
    yylval->colorval.green = rofi_theme_parse_convert_hex(yytext[9],yytext[10]);
    yylval->colorval.blue  = rofi_theme_parse_convert_hex(yytext[11],yytext[12]);
    return T_COLOR;
}
	YY_BREAK
/* Color schemes */
case 42:
YY_RULE_SETUP
#line 474 "../lexer/theme-lexer.l"
{ return T_COL_RGBA;       }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 475 "../lexer/theme-lexer.l"
{ return T_COL_HSL;        }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 476 "../lexer/theme-lexer.l"
{ return T_COL_HWB;        }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 477 "../lexer/theme-lexer.l"
{ return T_COL_CMYK;       }
	YY_BREAK
/* Fluff */
case 46:
YY_RULE_SETUP
#line 479 "../lexer/theme-lexer.l"
{ return T_PARENT_LEFT;    }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 480 "../lexer/theme-lexer.l"
{ return T_PARENT_RIGHT;   }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 481 "../lexer/theme-lexer.l"
{ return T_COMMA;          }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 482 "../lexer/theme-lexer.l"
{
    g_queue_push_head ( queue, GINT_TO_POINTER (YY_START) );
    BEGIN(PROPERTIES_LIST);
    return T_LIST_OPEN;
}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 487 "../lexer/theme-lexer.l"
{
    BEGIN(GPOINTER_TO_INT(g_queue_pop_head ( queue )));
    return T_LIST_CLOSE;
}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 491 "../lexer/theme-lexer.l"
{ return T_FORWARD_SLASH;  }
	YY_BREAK
/* Position */
case 52:
YY_RULE_SETUP
#line 493 "../lexer/theme-lexer.l"
{ return T_POS_CENTER;     }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 494 "../lexer/theme-lexer.l"
{ return T_POS_EAST;       }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 495 "../lexer/theme-lexer.l"
{ return T_POS_WEST;       }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 496 "../lexer/theme-lexer.l"
{ return T_POS_SOUTH;      }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 497 "../lexer/theme-lexer.l"
{ return T_POS_NORTH;      }
	YY_BREAK
/* Highlight style */
case 57:
YY_RULE_SETUP
#line 499 "../lexer/theme-lexer.l"
{ return T_NONE;           }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 500 "../lexer/theme-lexer.l"
{ return T_BOLD;           }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 501 "../lexer/theme-lexer.l"
{ return T_ITALIC;         }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 502 "../lexer/theme-lexer.l"
{ return T_UNDERLINE;      }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 503 "../lexer/theme-lexer.l"
{ return T_STRIKETHROUGH;  }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 504 "../lexer/theme-lexer.l"
{ return T_SMALLCAPS;      }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 506 "../lexer/theme-lexer.l"
{ return T_ANGLE_DEG;      }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 507 "../lexer/theme-lexer.l"
{ return T_ANGLE_RAD;      }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 508 "../lexer/theme-lexer.l"
{ return T_ANGLE_GRAD;     }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 509 "../lexer/theme-lexer.l"
{ return T_ANGLE_TURN;     }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 511 "../lexer/theme-lexer.l"
{ return ORIENTATION_HORI; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 512 "../lexer/theme-lexer.l"
{ return ORIENTATION_VERT; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 514 "../lexer/theme-lexer.l"
{
    return T_COLOR_TRANSPARENT;
}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 517 "../lexer/theme-lexer.l"
{
    for ( unsigned int iter = 0; iter < num_CSSColors; iter++){
        if ( strcasecmp(yytext, CSSColors[iter].name )== 0 ) {
            yylval->colorval.alpha = 1.0;
            yylval->colorval.red   = CSSColors[iter].r/255.0;
            yylval->colorval.green = CSSColors[iter].g/255.0;
            yylval->colorval.blue  = CSSColors[iter].b/255.0;
            return T_COLOR_NAME;
        }
    }
    REJECT;
}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 530 "../lexer/theme-lexer.l"
{
    ParseObject *po = g_queue_pop_head ( file_queue );
    if ( po ) {
        if ( po->type == PT_FILE ){
            fclose ( po->filein );
        }
        g_free (  po );
    }
    po = g_queue_peek_head ( file_queue );
    if ( po == NULL ) {
        g_queue_free ( queue );
        // Reset pointer to NULL
        queue = NULL;
        yyterminate();
    } else {
        yypop_buffer_state();
        current = po;
        *yylloc = current->location;
        BEGIN(GPOINTER_TO_INT ( g_queue_pop_head ( queue )));
    }
}
	YY_BREAK
case 71:
/* rule 71 can match eol */
YY_RULE_SETUP
#line 552 "../lexer/theme-lexer.l"
{
        yylloc->last_column = 1;
        yylloc->last_line ++;
};
	YY_BREAK
case 72:
/* rule 72 can match eol */
YY_RULE_SETUP
#line 556 "../lexer/theme-lexer.l"
{
        yylloc->last_column = 1;
        yylloc->last_line ++;
};
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 560 "../lexer/theme-lexer.l"
{
    return T_ERROR;
}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 563 "../lexer/theme-lexer.l"
{
    return T_ERROR_SECTION;
}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 566 "../lexer/theme-lexer.l"
{
    yylval->sval = g_strdup(yytext);
    return T_ELEMENT;
}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 571 "../lexer/theme-lexer.l"
{
    return T_ERROR_PROPERTY;
}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 574 "../lexer/theme-lexer.l"
{
    return T_ERROR_NAMESTRING;
}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 577 "../lexer/theme-lexer.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1892 "lexer/theme-lexer.c"
			case YY_STATE_EOF(INCLUDE):
			case YY_STATE_EOF(PROPERTIES):
			case YY_STATE_EOF(PROPERTIES_LIST):
			case YY_STATE_EOF(NAMESTR):
			case YY_STATE_EOF(SECTION):
			case YY_STATE_EOF(DEFAULTS):
				yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	(yy_state_ptr) = (yy_state_buf);
	*(yy_state_ptr)++ = yy_current_state;

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 294 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
		*(yy_state_ptr)++ = yy_current_state;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    
	YY_CHAR yy_c = 1;
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 294 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (flex_int16_t) yy_c];
	yy_is_jam = (yy_current_state == 293);
	if ( ! yy_is_jam )
		*(yy_state_ptr)++ = yy_current_state;

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = (yy_size_t)size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,(int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (yyconst char* msg )
{
			(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

    (yy_state_buf) = 0;
    (yy_state_ptr) = 0;
    (yy_full_match) = 0;
    (yy_lp) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    yyfree ( (yy_state_buf) );
    (yy_state_buf)  = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 577 "../lexer/theme-lexer.l"




gboolean rofi_theme_parse_file ( const char *file )
{
    char *file2 = helper_get_theme_path ( file );
    char *filename = rofi_theme_parse_prepare_file ( file2, NULL );
    g_free ( file2 );

    yyin = fopen ( filename, "rb" );
    if ( yyin == NULL ) {
        char *str = g_markup_printf_escaped ( "Failed to open theme: <i>%s</i>\nError: <b>%s</b>",
                filename, strerror ( errno ) );
        rofi_add_error_message ( g_string_new ( str ) );
        g_free ( str );
        g_free ( filename );
        return TRUE;
    }

    /** Add Parse object */
    file_queue = g_queue_new ();
    ParseObject *po = g_malloc0(sizeof(ParseObject));
    po->type = PT_FILE;
    po->filename = filename;
    po->filein = yyin;
    current = po;
    imported_files = g_list_append ( imported_files, po->filename );
    g_queue_push_head ( file_queue, po );
    g_debug ( "Parsing top file: '%s'", filename );

    int parser_retv = yyparse ( file );
    yylex_destroy ();
    yyin = NULL;

    while ( (po = g_queue_pop_head ( file_queue ) )) {
        if ( po ) {
            if ( po->type == PT_FILE ){
                fclose ( po->filein );
            }
            g_free ( po );
        }
    }
    // Free up.
    g_list_foreach ( imported_files, (GFunc)g_free, NULL);
    g_list_free ( imported_files );
    g_queue_free ( file_queue );
    imported_files = NULL;
    file_queue = NULL;
    if ( parser_retv != 0 ) {
        return TRUE;
    }
    return FALSE;
}
gboolean rofi_theme_parse_string ( const char *string )
{
    yyin      = NULL;

    /** Add Parse object */
    file_queue = g_queue_new ();
    ParseObject *po = g_malloc0(sizeof(ParseObject));
    po->type = PT_STRING;
    po->input_str = string;
    po->str_len   = strlen(string);
    current = po;
    g_queue_push_head ( file_queue, po );
    g_debug ( "Parsing string: '%s'", string );

    int parser_retv = yyparse ( string );
    yylex_destroy ();

    while ( (po = g_queue_pop_head ( file_queue ) )) {
        if ( po ) {
            if ( po->type == PT_FILE ){
                fclose ( po->filein );
            }
            g_free ( po );
        }
    }
    // Free up.
    g_list_foreach ( imported_files, (GFunc)g_free, NULL);
    g_list_free ( imported_files );
    imported_files = NULL;
    g_queue_free ( file_queue );
    file_queue = NULL;
    if ( parser_retv != 0 ) {
        return TRUE;
    }
    return FALSE;
}

