/*

 File generated by ../../tools/common_config.py from common_config.input

 Copyright (c) 2010 Fizians SAS. <http://www.fizians.com>
 This file is part of Rozofs.

 Rozofs is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published
 by the Free Software Foundation, version 2.

 Rozofs is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see
 <http://www.gnu.org/licenses/>.
 */
#ifndef _COMMON_CONFIG_READ_SHOW_H
#define _COMMON_CONFIG_READ_SHOW_H

#include <stdint.h>
#include <string.h>
#include <errno.h>
#include <libconfig.h>
#include <unistd.h>
#include <inttypes.h>
#include <sys/types.h>
/*____________________________________________________________________________________________*/
static inline void common_config_generated_show(char * argv[], uint32_t tcpRef, void *bufRef) {
char *pChar = uma_dbg_get_buffer();

  if (argv[1] != NULL) {
    if (strcmp(argv[1],"reload")==0) {
      common_config_read(NULL);
    }
  }
 
  if (config_file_is_read==0) {
    pChar += rozofs_string_append(pChar,"Can not read configuration file ");
  }
  pChar += rozofs_string_append(pChar,config_file_name);
  pChar += rozofs_eol(pChar);
  pChar += rozofs_eol(pChar);

  /*
  ** global scope configuration elements
  */
  pChar += rozofs_string_append(pChar,"#\n");
  pChar += rozofs_string_append(pChar,"# global scope configuration elements\n");
  pChar += rozofs_string_append(pChar,"#\n\n");
  pChar += rozofs_string_append(pChar,"// Number of core files that each module is allowed to keep.\n");
  pChar += rozofs_string_append(pChar,"// Older core files are kept while newest are removed.	\n");
  COMMON_CONFIG_SHOW_INT_OPT(nb_core_file,1,"0:8");
  pChar += rozofs_string_append(pChar,"// Directory where the core files are stored.\n");
  COMMON_CONFIG_SHOW_STRING(core_file_directory,"/var/run/rozofs_core");
  pChar += rozofs_string_append(pChar,"// Enables to take into account the NUMA architecture of the board in \n");
  pChar += rozofs_string_append(pChar,"// order to collocate some RozoFS modules on the same node for memory\n");
  pChar += rozofs_string_append(pChar,"// access efficiency.\n");
  COMMON_CONFIG_SHOW_BOOL(numa_aware,False);
  pChar += rozofs_string_append(pChar,"// Number of slices in the STORIO.\n");
  COMMON_CONFIG_SHOW_INT_OPT(storio_slice_number,1024,"8:(32*1024)");
  pChar += rozofs_string_append(pChar,"// File distribution mode upon cluster, storages and devices. Check rozofs.conf manual.\n");
  pChar += rozofs_string_append(pChar,"// 0      = size balancing\n");
  pChar += rozofs_string_append(pChar,"// 1      = weigthed round robin\n");
  pChar += rozofs_string_append(pChar,"// 2 or 3 = strict round robin\n");
  COMMON_CONFIG_SHOW_INT_OPT(file_distribution_rule,0,"0:10");
  pChar += rozofs_string_append(pChar,"// DSCP for exchanges from/to the STORIO.\n");
  COMMON_CONFIG_SHOW_INT_OPT(storio_dscp,46,"0:46");
  pChar += rozofs_string_append(pChar,"// DSCP for exchanges from/to the EXPORTD.\n");
  COMMON_CONFIG_SHOW_INT_OPT(export_dscp,34,"0:34");

  /*
  ** export scope configuration elements
  */
  pChar += rozofs_string_append(pChar,"#\n");
  pChar += rozofs_string_append(pChar,"# export scope configuration elements\n");
  pChar += rozofs_string_append(pChar,"#\n\n");
  pChar += rozofs_string_append(pChar,"// Max number of file that the exportd can remove from storages in a run.\n");
  pChar += rozofs_string_append(pChar,"// A new run occurs every 2 seconds.\n");
  COMMON_CONFIG_SHOW_INT_OPT(trashed_file_per_run,7,"0:5000");
  pChar += rozofs_string_append(pChar,"// High trash water mark when FID recycling is activated.\n");
  pChar += rozofs_string_append(pChar,"// When the trash has already this number of files, files are no more\n");
  pChar += rozofs_string_append(pChar,"// deleted but recycled.\n");
  COMMON_CONFIG_SHOW_INT_OPT(trash_high_threshold,1000,"0:1000000");
  pChar += rozofs_string_append(pChar,"// Whether FID recycling feature is activated.\n");
  COMMON_CONFIG_SHOW_BOOL(fid_recycle,False);
  COMMON_CONFIG_SHOW_INT_OPT(export_buf_cnt,128,"32:1024");
  pChar += rozofs_string_append(pChar,"// To activate export writebehind attributes thread.\n");
  COMMON_CONFIG_SHOW_BOOL(export_attr_thread,True);
  pChar += rozofs_string_append(pChar,"// Support of deleted directory/file versioning.\n");
  COMMON_CONFIG_SHOW_BOOL(export_versioning,False);
  pChar += rozofs_string_append(pChar,"// Number of MB to account a file for during file distribution phase\n");
  COMMON_CONFIG_SHOW_INT(alloc_estimated_mb,1);
  pChar += rozofs_string_append(pChar,"// Delay from which a rozofsmoun client is declared disconnected and its \n");
  pChar += rozofs_string_append(pChar,"// file locks are automatically removed\n");
  COMMON_CONFIG_SHOW_INT_OPT(client_flock_timeout,30,"15:600");
  pChar += rozofs_string_append(pChar,"// Time out between export and storage for remove and stat\n");
  COMMON_CONFIG_SHOW_INT_OPT(mproto_timeout,10,"1:60");
  pChar += rozofs_string_append(pChar,"// Directory to use on the export to build temporary files.\n");
  pChar += rozofs_string_append(pChar,"// Used for instance to build list of files to rebuild.\n");
  COMMON_CONFIG_SHOW_STRING(export_temporary_dir,"/tmp");
  pChar += rozofs_string_append(pChar,"// To activate workaround that make mkdir respond OK instead of EEXIST\n");
  pChar += rozofs_string_append(pChar,"// when the directory is already created \n");
  COMMON_CONFIG_SHOW_BOOL(mkdir_ok_instead_of_eexist,False);
  pChar += rozofs_string_append(pChar,"// To activate workaround that make mknod respond OK instead of EEXIST\n");
  pChar += rozofs_string_append(pChar,"// when the file is already created \n");
  COMMON_CONFIG_SHOW_BOOL(mknod_ok_instead_of_eexist,False);

  /*
  ** client scope configuration elements
  */
  pChar += rozofs_string_append(pChar,"#\n");
  pChar += rozofs_string_append(pChar,"# client scope configuration elements\n");
  pChar += rozofs_string_append(pChar,"#\n\n");
  pChar += rozofs_string_append(pChar,"// Whether STORCLI acknowleges write request on inverse or forward STORIO responses.\n");
  COMMON_CONFIG_SHOW_BOOL(wr_ack_on_inverse,False);
  pChar += rozofs_string_append(pChar,"// To activate rozofsmount reply fuse threads.\n");
  COMMON_CONFIG_SHOW_BOOL(rozofsmount_fuse_reply_thread,False);
  pChar += rozofs_string_append(pChar,"// To activate fast reconnect from client to exportd\n");
  COMMON_CONFIG_SHOW_BOOL(client_fast_reconnect,False);

  /*
  ** storage scope configuration elements
  */
  pChar += rozofs_string_append(pChar,"#\n");
  pChar += rozofs_string_append(pChar,"# storage scope configuration elements\n");
  pChar += rozofs_string_append(pChar,"#\n\n");
  pChar += rozofs_string_append(pChar,"// Number of disk threads in the STORIO.\n");
  COMMON_CONFIG_SHOW_INT_OPT(nb_disk_thread,4,"2:32");
  pChar += rozofs_string_append(pChar,"// Whether STORIO is in multiple (1 STORIO per cluster) \n");
  pChar += rozofs_string_append(pChar,"// or single mode (only 1 STORIO).\n");
  COMMON_CONFIG_SHOW_BOOL(storio_multiple_mode,True);
  pChar += rozofs_string_append(pChar,"// Whether CRC32 MUST be checked by STORIO.\n");
  COMMON_CONFIG_SHOW_BOOL(crc32c_check,True);
  pChar += rozofs_string_append(pChar,"// Whether CRC32 MUST be computed by STORIO.\n");
  COMMON_CONFIG_SHOW_BOOL(crc32c_generate,True);
  pChar += rozofs_string_append(pChar,"// Whether CRC32 MUST be absolutly hardware computed by STORIO.\n");
  COMMON_CONFIG_SHOW_BOOL(crc32c_hw_forced,False);
  pChar += rozofs_string_append(pChar,"// Whether STORIO device monitoring should avoid reading from \n");
  pChar += rozofs_string_append(pChar,"// devices when no access have occured for read or write. This\n");
  pChar += rozofs_string_append(pChar,"// enables disk spin down to occur.\n");
  COMMON_CONFIG_SHOW_BOOL(allow_disk_spin_down,False);
  pChar += rozofs_string_append(pChar,"// Over which device usage threashold should the STORIO log the event. \n");
  COMMON_CONFIG_SHOW_INT_OPT(disk_usage_threshold,0,"0:100");
  pChar += rozofs_string_append(pChar,"// Over which device read delay threashold should the STORIO log the event. \n");
  COMMON_CONFIG_SHOW_INT(disk_read_threshold,0);
  pChar += rozofs_string_append(pChar,"// Over which device write delay threashold should the STORIO log the event. \n");
  COMMON_CONFIG_SHOW_INT(disk_write_threshold,0);
  pChar += rozofs_string_append(pChar,"// Number of STORIO receive buffer.\n");
  COMMON_CONFIG_SHOW_INT_OPT(storio_buf_cnt,128,"64:1024");
  pChar += rozofs_string_append(pChar,"// Number of block to which the chunk files should be truncated on storage \n");
  pChar += rozofs_string_append(pChar,"// node at the time it is recycled.\n");
  COMMON_CONFIG_SHOW_INT(recycle_truncate_blocks,0);
  pChar += rozofs_string_append(pChar,"// Name of an executable file that the storaged should call at startup\n");
  COMMON_CONFIG_SHOW_STRING(storaged_start_script,"");
  pChar += rozofs_string_append(pChar,"// Whether the storage has to automount the devices\n");
  COMMON_CONFIG_SHOW_BOOL(device_automount,False);
  pChar += rozofs_string_append(pChar,"// automount path where the devices should be mounted\n");
  COMMON_CONFIG_SHOW_STRING(device_automount_path,"/srv/rozofs/storages");
  pChar += rozofs_string_append(pChar,"// Device mounting options\n");
  COMMON_CONFIG_SHOW_STRING(device_automount_option,"");
  pChar += rozofs_string_append(pChar,"// Paralellism factor for device self healing feature\n");
  COMMON_CONFIG_SHOW_INT_OPT(device_self_healing_process,8,"1:64");
  pChar += rozofs_string_append(pChar,"// Directory to use on the storage node to build temporary files.\n");
  pChar += rozofs_string_append(pChar,"// Used for instance by the rebuild process.\n");
  COMMON_CONFIG_SHOW_STRING(storage_temporary_dir,"/tmp");

  uma_dbg_send(tcpRef, bufRef, TRUE, uma_dbg_get_buffer());
  return;
}
/*____________________________________________________________________________________________*/
static inline void common_config_generated_read(char * fname) {
  config_t          cfg; 

  if (config_file_is_read == 0) {
    uma_dbg_addTopic("cconf",show_common_config);
    if (fname == NULL) {
      strcpy(config_file_name,ROZOFS_DEFAULT_CONFIG);
    }
    else {
      strcpy(config_file_name,fname); 
    } 
  }

  config_init(&cfg);
  config_file_is_read = 1;
  if (config_read_file(&cfg, config_file_name) == CONFIG_FALSE) {
    if (errno == ENOENT) {
      info("cant read %s: %s (line %d).", config_file_name, config_error_text(&cfg),
      config_error_line(&cfg));
    }
    else {
      severe("cant read %s: %s (line %d).", config_file_name, config_error_text(&cfg),
               config_error_line(&cfg));
    }
    config_file_is_read = 0;
  }

  /*
  ** global scope configuration elements
  */
  // Number of core files that each module is allowed to keep. 
  // Older core files are kept while newest are removed.	 
  COMMON_CONFIG_READ_INT_MINMAX(nb_core_file,1,0,8);
  // Directory where the core files are stored. 
  COMMON_CONFIG_READ_STRING(core_file_directory,"/var/run/rozofs_core");
  // Enables to take into account the NUMA architecture of the board in  
  // order to collocate some RozoFS modules on the same node for memory 
  // access efficiency. 
  COMMON_CONFIG_READ_BOOL(numa_aware,False);
  // Number of slices in the STORIO. 
  COMMON_CONFIG_READ_INT_MINMAX(storio_slice_number,1024,8,(32*1024));
  // File distribution mode upon cluster, storages and devices. Check rozofs.conf manual. 
  // 0      = size balancing 
  // 1      = weigthed round robin 
  // 2 or 3 = strict round robin 
  COMMON_CONFIG_READ_INT_MINMAX(file_distribution_rule,0,0,10);
  // DSCP for exchanges from/to the STORIO. 
  COMMON_CONFIG_READ_INT_MINMAX(storio_dscp,46,0,46);
  // DSCP for exchanges from/to the EXPORTD. 
  COMMON_CONFIG_READ_INT_MINMAX(export_dscp,34,0,34);
  /*
  ** export scope configuration elements
  */
  // Max number of file that the exportd can remove from storages in a run. 
  // A new run occurs every 2 seconds. 
  COMMON_CONFIG_READ_INT_MINMAX(trashed_file_per_run,7,0,5000);
  // High trash water mark when FID recycling is activated. 
  // When the trash has already this number of files, files are no more 
  // deleted but recycled. 
  COMMON_CONFIG_READ_INT_MINMAX(trash_high_threshold,1000,0,1000000);
  // Whether FID recycling feature is activated. 
  COMMON_CONFIG_READ_BOOL(fid_recycle,False);
  COMMON_CONFIG_READ_INT_MINMAX(export_buf_cnt,128,32,1024);
  // To activate export writebehind attributes thread. 
  COMMON_CONFIG_READ_BOOL(export_attr_thread,True);
  // Support of deleted directory/file versioning. 
  COMMON_CONFIG_READ_BOOL(export_versioning,False);
  // Number of MB to account a file for during file distribution phase 
  COMMON_CONFIG_READ_INT(alloc_estimated_mb,1);
  // Delay from which a rozofsmoun client is declared disconnected and its  
  // file locks are automatically removed 
  COMMON_CONFIG_READ_INT_MINMAX(client_flock_timeout,30,15,600);
  // Time out between export and storage for remove and stat 
  COMMON_CONFIG_READ_INT_MINMAX(mproto_timeout,10,1,60);
  // Directory to use on the export to build temporary files. 
  // Used for instance to build list of files to rebuild. 
  COMMON_CONFIG_READ_STRING(export_temporary_dir,"/tmp");
  // To activate workaround that make mkdir respond OK instead of EEXIST 
  // when the directory is already created  
  COMMON_CONFIG_READ_BOOL(mkdir_ok_instead_of_eexist,False);
  // To activate workaround that make mknod respond OK instead of EEXIST 
  // when the file is already created  
  COMMON_CONFIG_READ_BOOL(mknod_ok_instead_of_eexist,False);
  /*
  ** client scope configuration elements
  */
  // Whether STORCLI acknowleges write request on inverse or forward STORIO responses. 
  COMMON_CONFIG_READ_BOOL(wr_ack_on_inverse,False);
  // To activate rozofsmount reply fuse threads. 
  COMMON_CONFIG_READ_BOOL(rozofsmount_fuse_reply_thread,False);
  // To activate fast reconnect from client to exportd 
  COMMON_CONFIG_READ_BOOL(client_fast_reconnect,False);
  /*
  ** storage scope configuration elements
  */
  // Number of disk threads in the STORIO. 
  COMMON_CONFIG_READ_INT_MINMAX(nb_disk_thread,4,2,32);
  // Whether STORIO is in multiple (1 STORIO per cluster)  
  // or single mode (only 1 STORIO). 
  COMMON_CONFIG_READ_BOOL(storio_multiple_mode,True);
  // Whether CRC32 MUST be checked by STORIO. 
  COMMON_CONFIG_READ_BOOL(crc32c_check,True);
  // Whether CRC32 MUST be computed by STORIO. 
  COMMON_CONFIG_READ_BOOL(crc32c_generate,True);
  // Whether CRC32 MUST be absolutly hardware computed by STORIO. 
  COMMON_CONFIG_READ_BOOL(crc32c_hw_forced,False);
  // Whether STORIO device monitoring should avoid reading from  
  // devices when no access have occured for read or write. This 
  // enables disk spin down to occur. 
  COMMON_CONFIG_READ_BOOL(allow_disk_spin_down,False);
  // Over which device usage threashold should the STORIO log the event.  
  COMMON_CONFIG_READ_INT_MINMAX(disk_usage_threshold,0,0,100);
  // Over which device read delay threashold should the STORIO log the event.  
  COMMON_CONFIG_READ_INT(disk_read_threshold,0);
  // Over which device write delay threashold should the STORIO log the event.  
  COMMON_CONFIG_READ_INT(disk_write_threshold,0);
  // Number of STORIO receive buffer. 
  COMMON_CONFIG_READ_INT_MINMAX(storio_buf_cnt,128,64,1024);
  // Number of block to which the chunk files should be truncated on storage  
  // node at the time it is recycled. 
  COMMON_CONFIG_READ_INT(recycle_truncate_blocks,0);
  // Name of an executable file that the storaged should call at startup 
  COMMON_CONFIG_READ_STRING(storaged_start_script,"");
  // Whether the storage has to automount the devices 
  COMMON_CONFIG_READ_BOOL(device_automount,False);
  // automount path where the devices should be mounted 
  COMMON_CONFIG_READ_STRING(device_automount_path,"/srv/rozofs/storages");
  // Device mounting options 
  COMMON_CONFIG_READ_STRING(device_automount_option,"");
  // Paralellism factor for device self healing feature 
  COMMON_CONFIG_READ_INT_MINMAX(device_self_healing_process,8,1,64);
  // Directory to use on the storage node to build temporary files. 
  // Used for instance by the rebuild process. 
  COMMON_CONFIG_READ_STRING(storage_temporary_dir,"/tmp");
 
  config_destroy(&cfg);
}
#endif
