/*
  Copyright (c) 2010 Fizians SAS. <http://www.fizians.com>
  This file is part of Rozofs.

  Rozofs is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, version 2.

  Rozofs is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see
  <http://www.gnu.org/licenses/>.
 */
#ifndef RUC_OBSERVER_API_H
#define RUC_OBSERVER_API_H

#include <rozofs/common/types.h>

#include "ruc_common.h"
#include "ruc_list.h"
// 64BITS typedef void (*ruc_observer_cbk) (uint32_t userRef, uint32 srvParam);
typedef void (*ruc_observer_cbk) (void * userRef, void *srvParam);

#define ruc_observer_attachEventMACRO(servAttachFunc,event,priority,userRef,cbk) servAttachFunc(#cbk,event,priority,userRef,cbk)
#define ruc_observer_attachMACRO(servAttachFunc,priority,userRef,cbk) servAttachFunc(#cbk,priority,userRef,cbk)


/*----------------------------------------------
**   init of the observer service
**----------------------------------------------
**  IN :
**     . maxServer = number server context
**     . maxClient = number of client context
**  OUT : RUC_OK or RUC_NOK
**-----------------------------------------------
*/
uint32_t ruc_observer_init(uint32_t maxClient, uint32_t maxServer);
/*----------------------------------------------
**   Declare a server
**----------------------------------------------
**  IN :
**     . name : name of the server
**     . nbEvent : number of events generated
**                 by the server
**
**  OUT : Server reference or -1
**-----------------------------------------------
*/
uint32_t ruc_observer_declareServer(char * name, uint32_t nbEvent) ;
/*----------------------------------------------
**   Create a client context
**----------------------------------------------
**  IN :
**     . servRef : reference of the server to bind on
**     . clientName : name of the client callback function
**     . event : event generated by the server to bind on
**     . priority : priority within the client list
**     . userRef : 1rst call back parameter
**     . cbk : callback function address
**  OUT : the client reference or -1
**-----------------------------------------------
*/
uint32_t ruc_observer_createClient(uint32_t           servRef,
				 char           * clientName,
				 uint32_t           event,
				 uint32_t           priority,
//64BITS				 uint32_t           userRef,
				 void           *userRef,
				 ruc_observer_cbk cbk);

/*----------------------------------------------
**   remove a client context
**----------------------------------------------
**  IN :
**     . cltRef : the client context reference
**  OUT : RUC_OK or RUC_NOK
**-----------------------------------------------
*/
uint32_t ruc_observer_removeClient(uint32_t cltRef);

/*----------------------------------------------
**   Process a call back when the server generates
**   an event
**----------------------------------------------
**  IN :
**     . srvRef : the server reference
**     . event : the event generated
**     . srvParam : a parameter determined by the server
**  OUT : none
**-----------------------------------------------
*/
// 64BITS void  ruc_observer_serverEvent(uint32_t srvRef, uint32 event, uint32 srvParam);
void  ruc_observer_serverEvent(uint32_t srvRef, uint32_t event, void *srvParam);

/**
* Observer debug-> print the current configuration
*/
void  ruc_observer_debug_conf();
#endif
