/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <stdio.h>
#include <stdlib.h>
#include <rpc/pmap_clnt.h>
#include <string.h>
#include <memory.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <rozofs/rpc/sproto.h>

#ifndef SIG_PF
#define SIG_PF void(*)(int)
#endif
#include <rozofs/rozofs.h>
#include <rozofs/core/rozofs_rpc_non_blocking_generic_srv.h>
#include <rozofs/core/ruc_buffer_api.h>
#include <rozofs/rpc/rozofs_rpc_util.h>
#include "eproto_nb.h"
#include "eprotosvc_nb.h"



/*
**__________________________________________________________________________
*/
/**
  Server callback  for GW_PROGRAM protocol:
    
     GW_INVALIDATE_SECTIONS
     GW_INVALIDATE_ALL
     GW_CONFIGURATION
     GW_POLL
     
  That callback is called upon receiving a GW_PROGRAM message
  from the master exportd

    
  @param socket_ctx_p: pointer to the af unix socket
  @param socketId: reference of the socket (not used)
 
   @retval : TRUE-> xmit ready event expected
  @retval : FALSE-> xmit  ready event not expected
*/
void expnb_req_rcv_cbk(void *userRef,uint32_t  socket_ctx_idx, void *recv_buf)
{
    uint32_t  *com_hdr_p;
    rozofs_rpc_call_hdr_t   hdr;
    sp_status_ret_t  arg_err;
    char * arguments;
    int size = 0;

    rozorpc_srv_ctx_t *rozorpc_srv_ctx_p = NULL;
    
    com_hdr_p  = (uint32_t*) ruc_buf_getPayload(recv_buf); 
    com_hdr_p +=1;   /* skip the size of the rpc message */

    memcpy(&hdr,com_hdr_p,sizeof(rozofs_rpc_call_hdr_t));
    scv_call_hdr_ntoh(&hdr);
    /*
    ** allocate a context for the duration of the transaction since it might be possible
    ** that the gateway needs to interrogate the exportd and thus needs to save the current
    ** request until receiving the response from the exportd
    */
    rozorpc_srv_ctx_p = rozorpc_srv_alloc_context();
    if (rozorpc_srv_ctx_p == NULL)
    {
       fatal(" Out of rpc context");    
    }
    /*
    ** save the initial transaction id, received buffer and reference of the connection
    */
    rozorpc_srv_ctx_p->src_transaction_id = hdr.hdr.xid;
    rozorpc_srv_ctx_p->recv_buf  = recv_buf;
    rozorpc_srv_ctx_p->socketRef = socket_ctx_idx;
    
    /*
    ** Allocate buffer for decoded aeguments
    */
    rozorpc_srv_ctx_p->decoded_arg = ruc_buf_getBuffer(decoded_rpc_buffer_pool);
    if (rozorpc_srv_ctx_p->decoded_arg == NULL) {
      rozorpc_srv_ctx_p->xmitBuf = rozorpc_srv_ctx_p->recv_buf;
      rozorpc_srv_ctx_p->recv_buf = NULL;
      rozorpc_srv_ctx_p->xdr_result =(xdrproc_t) xdr_sp_status_ret_t;
      arg_err.status = SP_FAILURE;
      arg_err.sp_status_ret_t_u.error = ENOMEM;        
      rozorpc_srv_forward_reply(rozorpc_srv_ctx_p,(char*)&arg_err);
      rozorpc_srv_release_context(rozorpc_srv_ctx_p);    
      return;
    }    
    arguments = ruc_buf_getPayload(rozorpc_srv_ctx_p->decoded_arg);

    void (*local)(void *, rozorpc_srv_ctx_t *);

    switch (hdr.proc) {
     case EP_NULL:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_void;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_void;
	     local =  ep_null_1_svc_nb;
	     break;

     case EP_GEO_POLL:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_void;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_void;
	     local =  ep_geo_poll_1_svc_nb;
	     break;

     case EP_MOUNT:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mount_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mount_ret_t;
	     local =  ep_mount_1_svc_nb;
	     size = sizeof(epgw_mount_arg_t);
	     break;

		 
     case EP_MOUNT_MSITE:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mount_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mount_msite_ret_t;
	     local =  ep_mount_msite_1_svc_nb;
	     size = sizeof(epgw_mount_arg_t);
	     break;
		 
     case EP_UMOUNT:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_uint32_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_umount_1_svc_nb;
	     size = sizeof(uint32_t);
	     break;

     case EP_STATFS:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_uint32_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_statfs_ret_t;
	     local =  ep_statfs_1_svc_nb;
	     size = sizeof(uint32_t);
	     break;

     case EP_LOOKUP:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lookup_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_lookup_1_svc_nb;
	     size = sizeof(epgw_lookup_arg_t);
	     break;

     case EP_GETATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mfile_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_getattr_1_svc_nb;
	     size = sizeof(epgw_mfile_arg_t);
	     break;

     case EP_SETATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_setattr_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_setattr_1_svc_nb;
	     size = sizeof(epgw_setattr_arg_t);
	     break;

     case EP_READLINK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mfile_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_readlink_ret_t;
	     local =  ep_readlink_1_svc_nb;
	     size = sizeof(epgw_mfile_arg_t);
	     break;

     case EP_MKNOD:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mknod_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_mknod_1_svc_nb;
	     size = sizeof(epgw_mknod_arg_t);
	     break;

     case EP_MKDIR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_mkdir_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_mkdir_1_svc_nb;
	     size = sizeof(epgw_mkdir_arg_t);
	     break;

     case EP_UNLINK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_unlink_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_fid_ret_t;
	     local =  ep_unlink_1_svc_nb;
	     size = sizeof(epgw_unlink_arg_t);
	     break;

     case EP_RMDIR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_rmdir_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_fid_ret_t;
	     local =  ep_rmdir_1_svc_nb;
	     size = sizeof(epgw_rmdir_arg_t);
	     break;

     case EP_SYMLINK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_symlink_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_symlink_1_svc_nb;
	     size = sizeof(epgw_symlink_arg_t);
	     break;

     case EP_SYMLINK2:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_symlink2_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_symlink2_1_svc_nb;
	     size = sizeof(epgw_symlink2_arg_t);
	     break;


     case EP_RENAME:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_rename_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_rename_ret_t;
	     local =  ep_rename_1_svc_nb;
	     size = sizeof(epgw_rename_arg_t);
	     break;

     case EP_READDIR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_readdir_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_readdir_ret_t;
	     local =  ep_readdir_1_svc_nb;
	     size = sizeof(epgw_readdir_arg_t);
	     break;

     case EP_READ_BLOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_io_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_read_block_ret_t;
	     local =  ep_read_block_1_svc_nb;
	     size = sizeof(epgw_io_arg_t);
	     break;

     case EP_WRITE_BLOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_write_block_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_write_block_1_svc_nb;
	     size = sizeof(epgw_write_block_arg_t);
	     break;

     case EP_LINK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_link_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_mattr_ret_t;
	     local =  ep_link_1_svc_nb;
	     size = sizeof(epgw_link_arg_t);
	     break;

     case EP_SETXATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_setxattr_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_setxattr_ret_t;
	     local =  ep_setxattr_1_svc_nb;
	     size = sizeof(epgw_setxattr_arg_t);
	     break;

     case EP_GETXATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_getxattr_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_getxattr_ret_t;
	     local =  ep_getxattr_1_svc_nb;
	     size = sizeof(epgw_getxattr_arg_t);
	     break;

     case EP_REMOVEXATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_removexattr_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_removexattr_1_svc_nb;
	     size = sizeof(epgw_removexattr_arg_t);
	     break;

     case EP_LISTXATTR:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_listxattr_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_listxattr_ret_t;
	     local =  ep_listxattr_1_svc_nb;
	     size = sizeof(epgw_listxattr_arg_t);
	     break;

     case EP_LIST_CLUSTER:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_cluster_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_cluster_ret_t;
	     local =  ep_list_cluster_1_svc_nb;
	     size = sizeof(epgw_cluster_arg_t);
	     break;

     case EP_LIST_CLUSTER2:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_cluster_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_cluster2_ret_t;
	     local =  ep_list_cluster2_1_svc_nb;
	     size = sizeof(epgw_cluster_arg_t);
	     break;

     case EP_CONF_STORAGE:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_conf_stor_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_conf_ret_t;
	     local =  ep_conf_storage_1_svc_nb;
	     size = sizeof(epgw_conf_stor_arg_t);
	     break;

     case EP_POLL_CONF:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_ep_gateway_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_poll_conf_1_svc_nb;
	     size = sizeof(ep_gateway_t);
	     break;

     case EP_CONF_EXPGW:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_ep_path_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_ep_gw_gateway_configuration_ret_t;
	     local =  ep_conf_expgw_1_svc_nb;
	     size = sizeof(ep_path_t);
	     break;

     case EP_SET_FILE_LOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lock_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_lock_ret_t;
	     local =  ep_set_file_lock_1_svc_nb;
	     size = sizeof(epgw_lock_arg_t);
	     break;

     case EP_GET_FILE_LOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lock_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_lock_ret_t;
	     local =  ep_get_file_lock_1_svc_nb;
	     size = sizeof(epgw_lock_arg_t);
	     break;

     case EP_CLEAR_OWNER_FILE_LOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lock_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_clear_owner_file_lock_1_svc_nb;
	     size = sizeof(epgw_lock_arg_t);
	     break;

     case EP_CLEAR_CLIENT_FILE_LOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lock_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_clear_client_file_lock_1_svc_nb;
	     size = sizeof(epgw_lock_arg_t);
	     break;

     case EP_POLL_FILE_LOCK:
	     rozorpc_srv_ctx_p->arg_decoder = (xdrproc_t) xdr_epgw_lock_arg_t;
	     rozorpc_srv_ctx_p->xdr_result = (xdrproc_t) xdr_epgw_status_ret_t;
	     local =  ep_poll_file_lock_1_svc_nb;
	     size = sizeof(epgw_lock_arg_t);
	     break;
    default:
      rozorpc_srv_ctx_p->xmitBuf = rozorpc_srv_ctx_p->recv_buf;
      rozorpc_srv_ctx_p->recv_buf = NULL;
      rozorpc_srv_ctx_p->xdr_result =(xdrproc_t) xdr_sp_status_ret_t;
      arg_err.status = SP_FAILURE;
      arg_err.sp_status_ret_t_u.error = EPROTO;        
      rozorpc_srv_forward_reply(rozorpc_srv_ctx_p,(char*)&arg_err);
      rozorpc_srv_release_context(rozorpc_srv_ctx_p);    
      return;
    }
    
    memset(arguments,0, size);
    ruc_buf_setPayloadLen(rozorpc_srv_ctx_p->decoded_arg,size); // for debug 
    
    /*
    ** decode the payload of the rpc message
    */
    if (!rozorpc_srv_getargs_with_position (recv_buf, (xdrproc_t) rozorpc_srv_ctx_p->arg_decoder, 
                                            (caddr_t) arguments, &rozorpc_srv_ctx_p->position)) 
    {    
      rozorpc_srv_ctx_p->xmitBuf = rozorpc_srv_ctx_p->recv_buf;
      rozorpc_srv_ctx_p->recv_buf = NULL;
      rozorpc_srv_ctx_p->xdr_result = (xdrproc_t)xdr_sp_status_ret_t;
      arg_err.status = SP_FAILURE;
      arg_err.sp_status_ret_t_u.error = errno;        
      rozorpc_srv_forward_reply(rozorpc_srv_ctx_p,(char*)&arg_err);
      /*
      ** release the context
      */
      rozorpc_srv_release_context(rozorpc_srv_ctx_p);    
      return;
    }  
    
    /*
    ** call the user call-back
    */
    (*local)(arguments, rozorpc_srv_ctx_p);    
}
