#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os.path
import subprocess
import time
import re
import shlex
import datetime
from optparse import OptionParser

import sys
  
objects = []
modules = []
  
#_______________________________________________
class conf_obj:

  def __init__(self,name,module,genre,default,comment,minmax=None):

    self.name     = name
    self.module   = module
    self.genre    = genre
    self.default  = default
    self.mini=None
    self.maxi=None
    self.comment = comment

    if minmax != None:
      try:
        self.mini=minmax.split(':')[0]
	self.maxi=minmax.split(':')[1]
      except:
        print "%s %s bad min:max \"%s\""%(genre,name,minmax)
        raise ValueError()    


    if module not in modules: modules.append(module)
   
    objects.append(self)

#    print "%s is %s in %s"%(name,genre,module)

  def write_in_struct(self):

    for comment in self.comment:  print "  %s"%(comment) 
     
    if self.genre == "STRING":
      print "  char *      %s;"%(self.name) 
    else:
      print "  uint32_t    %s;"%(self.name)

  def write_in_show(self):  
    for comment in self.comment: print "  pChar += rozofs_string_append(pChar,\"%s\\n\");"%(comment)
    if self.mini != None:
      print "  COMMON_CONFIG_SHOW_%s_OPT(%s,%s,\"%s:%s\");"%(self.genre,self.name,self.default,self.mini,self.maxi) 
    else:
      print "  COMMON_CONFIG_SHOW_%s(%s,%s);"%(self.genre,self.name,self.default) 
              
  def read(self):
    for comment in self.comment: print "  %s "%(comment)
    if self.mini == None:
      print "  COMMON_CONFIG_READ_%s(%s,%s);"%(self.genre,self.name,self.default)       
    else:
      print "  COMMON_CONFIG_READ_%s_MINMAX(%s,%s,%s,%s);"%(self.genre,self.name,self.default,self.mini,self.maxi)                

#_______________________________________________
class conf_int(conf_obj):

  def __init__(self,name,module,default,comment,minmax=None):
    try: int(default)
    except:
      print "INT %s has not an integer default value \"%s\""%(name,default)
      raise ValueError()
    conf_obj.__init__(self,name,module,"INT",default,comment,minmax)

#_______________________________________________
class conf_string(conf_obj):

  def __init__(self,name,module,default,comment):
    conf_obj.__init__(self,name,module,"STRING",default,comment)

#_______________________________________________
class conf_bool(conf_obj):

  def __init__(self,name,module,default,comment):
    try: bool(default)
    except:
      print "BOOL %s has not a boolean default value \"%s\""%(name,default)
      raise ValueError()
    conf_obj.__init__(self,name,module,"BOOL",default,comment)    
#_______________________________________________
def start_file(name):
  global save_stdout
  
  save_stdout = sys.stdout
  sys.stdout = open("%s.h"%(name),"w")


  print "/*"
  print ""  
  print " File generated by ../../tools/common_config.py from common_config.input"
  print ""
  print " Copyright (c) 2010 Fizians SAS. <http://www.fizians.com>"
  print " This file is part of Rozofs."
  print ""
  print " Rozofs is free software; you can redistribute it and/or modify"
  print " it under the terms of the GNU General Public License as published"
  print " by the Free Software Foundation, version 2."
  print ""
  print " Rozofs is distributed in the hope that it will be useful, but"
  print " WITHOUT ANY WARRANTY; without even the implied warranty of"
  print " MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU"
  print " General Public License for more details."
  print ""
  print " You should have received a copy of the GNU General Public License"
  print " along with this program.  If not, see"
  print " <http://www.gnu.org/licenses/>."
  print " */"
  print "#ifndef _%s_H"%(name.upper())
  print "#define _%s_H"%(name.upper())
  print ""
  print "#include <stdint.h>"
  print "#include <string.h>"
  print "#include <errno.h>"
  print "#include <libconfig.h>"
  print "#include <unistd.h>"
  print "#include <inttypes.h>"
  print "#include <sys/types.h>"

#_______________________________________________
def end_file():
  global save_stdout
  
  print "#endif"
  sys.stdout.close()
  sys.stdout = save_stdout    


#_______________________________________________
def go_read_file():
  comment =  []
  
  if not os.path.exists("./common_config.input"):
    print "Missing file common_config.input"
    sys.exit(1)
    
  with open("./common_config.input","r") as finput:
  
    for line in finput:
 
      if len(line.split()) == 0: continue
      if line[0] == '#': continue         

      try:
        if line[0] == '/' and line[1] == '/':
	  genre = "//"
	else:
	  genre=line.split()[0]  
      except: 
        genre=line.split()[0]
      	
      if genre == "//": 
        comment.append(line[:-1])
	continue
	
      module=line.split()[1]
      name=line.split()[2]
      if genre != "STRING": 
        default=line.split()[3]
      else:
        default='"'+line.split('"')[1]+'"'
	
      if genre == "INT":
        if len(line.split()) == 5:
	  obj = conf_int(name,module,default,comment,line.split()[4])
	else:
	  obj = conf_int(name,module,default,comment)  
      elif genre == "BOOL":
        obj = conf_bool(name,module,default,comment)
      elif genre == "STRING": 
        obj = conf_string(name,module,default,comment)
      else:
        print "Unknown type %s for %s"%(genre,name)	
      comment =  []	

#_______________________________________________
def go_build_struct():
  print ""
  print "void common_config_read(char * fname);"
  print ""
  print "typedef struct _common_config_global_t {"
  for module in modules:
    print ""  
    print "  /*"
    print "  ** %s scope configuration elements"%(module)
    print "  */"
    print ""
    for obj in objects:
      if obj.module == module:     
        obj.write_in_struct()    
  print "} common_config_t;\n"
  
  print "extern common_config_t common_config;"
  #print "extern int             config_file_is_read;"
  #print "extern char            config_file_name[];"  
#_______________________________________________
def go_build_show(): 
  print "/*____________________________________________________________________________________________*/"
  print "static inline void common_config_generated_show(char * argv[], uint32_t tcpRef, void *bufRef) {"
  print "char *pChar = uma_dbg_get_buffer();"
  print ""
  print "  if (argv[1] != NULL) {"
  print "    if (strcmp(argv[1],\"reload\")==0) {"  
  print "      common_config_read(NULL);"
  print "    }"
  print "  }"
  print " "   
  print "  if (config_file_is_read==0) {"
  print "    pChar += rozofs_string_append(pChar,\"Can not read configuration file \");"    
  print "  }"
  print "  pChar += rozofs_string_append(pChar,config_file_name);"
  print "  pChar += rozofs_eol(pChar);"
  print "  pChar += rozofs_eol(pChar);"

  for module in modules:
    print ""
    print "  /*"
    print "  ** %s scope configuration elements"%(module)
    print "  */"
    print "  pChar += rozofs_string_append(pChar,\"#\\n\");"    
    print "  pChar += rozofs_string_append(pChar,\"# %s scope configuration elements\\n\");"%(module)   
    print "  pChar += rozofs_string_append(pChar,\"#\\n\\n\");"    
    for obj in objects:
      if obj.module == module:     
        obj.write_in_show() 
	   
  print "" 
  print "  uma_dbg_send(tcpRef, bufRef, TRUE, uma_dbg_get_buffer());"
  print "  return;"     
  print "}"

#_______________________________________________
def go_build_read():   
  print "/*____________________________________________________________________________________________*/"
  print "static inline void common_config_generated_read(char * fname) {"
  print "  config_t          cfg; "
  print ""
  print "  if (config_file_is_read == 0) {"
  print "    uma_dbg_addTopic(\"cconf\",show_common_config);"
  print "    if (fname == NULL) {"
  print "      strcpy(config_file_name,ROZOFS_DEFAULT_CONFIG);"
  print "    }"
  print "    else {"
  print "      strcpy(config_file_name,fname); "   
  print "    } "
  print "  }"
  print ""
  print "  config_init(&cfg);"
  print "  config_file_is_read = 1;"
  print "  if (config_read_file(&cfg, config_file_name) == CONFIG_FALSE) {"
  print "    if (errno == ENOENT) {"
  print "      info(\"cant read %s: %s (line %d).\", config_file_name, config_error_text(&cfg),"
  print "      config_error_line(&cfg));"
  print "    }"
  print "    else {"
  print "      severe(\"cant read %s: %s (line %d).\", config_file_name, config_error_text(&cfg),"
  print "               config_error_line(&cfg));"
  print "    }"	    
  print "    config_file_is_read = 0;"	    
  print "  }"
  print ""


  for module in modules:
    print "  /*"
    print "  ** %s scope configuration elements"%(module)
    print "  */"
    for obj in objects:
      if obj.module == module:     
        obj.read() 

  print " "
  print "  config_destroy(&cfg);"
  print "}" 
  
go_read_file()

start_file("common_config")
go_build_struct()
end_file()

start_file("common_config_read_show")
go_build_show()
go_build_read()
end_file()
