/* The following code was generated by JFlex 1.4.1 on 6/11/09 9:34 AM */

/*
 * 11/13/2004
 *
 * LispTokenMaker.java - Scanner for the Lisp programming language.
 * Copyright (C) 2004 Robert Futrell
 * robert_futrell at users.sourceforge.net
 * http://fifesoft.com/rsyntaxtextarea
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for the Lisp programming language.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated LispTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class LispTokenMaker extends AbstractJFlexTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int EOL_COMMENT = 3;
  public static final int STRING = 1;
  public static final int YYINITIAL = 0;
  public static final int MLC = 2;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\1\0\1\14\1\10\22\0\1\14\1\34\1\73"+
    "\1\11\1\1\1\34\1\37\1\42\2\25\1\32\1\26\1\42\1\23"+
    "\1\24\1\35\1\4\1\71\1\71\5\6\2\3\1\40\1\16\1\27"+
    "\1\30\1\33\1\36\1\41\3\5\1\21\1\22\1\21\5\1\1\20"+
    "\13\1\1\17\2\1\1\42\1\12\1\42\1\31\1\2\1\0\1\56"+
    "\1\64\1\55\1\54\1\52\1\47\1\61\1\43\1\50\1\1\1\67"+
    "\1\51\1\63\1\60\1\57\1\45\1\72\1\62\1\46\1\44\1\7"+
    "\1\70\1\53\1\66\1\65\1\1\1\10\1\15\1\10\1\36\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\1\2\2\3\1\2\2\1\1\4\1\5"+
    "\1\6\1\7\1\6\1\1\1\10\5\6\17\2\1\11"+
    "\1\12\1\13\1\14\1\15\1\12\1\16\5\12\1\17"+
    "\3\12\1\1\1\20\1\3\1\21\1\20\1\21\1\20"+
    "\1\22\1\20\1\2\1\23\1\0\1\6\10\2\1\24"+
    "\14\2\1\24\12\2\1\13\1\25\10\0\1\1\1\21"+
    "\1\0\2\22\12\2\1\0\1\2\1\24\13\2\1\0"+
    "\1\24\16\2\10\0\1\1\7\2\1\24\3\2\1\0"+
    "\20\2\3\0\11\2\2\0\1\26\2\0\1\27\1\1"+
    "\10\2\1\0\3\2\2\0\13\2\3\0\5\2\4\0"+
    "\1\1\5\2\1\0\1\2\10\0\12\2\3\0\1\24"+
    "\2\2\1\0\1\2\16\0\3\2\1\0\4\2\4\0"+
    "\2\2\21\0\2\2\3\0\2\2\4\0\1\2\21\0"+
    "\1\2\5\0\2\2\23\0\1\2\201\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\74\0\170\0\264\0\360\0\u012c\0\u0168\0\u01a4"+
    "\0\u01e0\0\u021c\0\u0258\0\u021c\0\u0294\0\u02d0\0\u021c\0\u030c"+
    "\0\u0348\0\u021c\0\u0384\0\u03c0\0\u03fc\0\u021c\0\u0438\0\u0474"+
    "\0\u04b0\0\u04ec\0\u0528\0\u0564\0\u05a0\0\u05dc\0\u0618\0\u0654"+
    "\0\u0690\0\u06cc\0\u0708\0\u0744\0\u0780\0\u07bc\0\u021c\0\u07f8"+
    "\0\u0834\0\u021c\0\u021c\0\u0870\0\u021c\0\u08ac\0\u08e8\0\u0924"+
    "\0\u0960\0\u099c\0\u021c\0\u09d8\0\u0a14\0\u0a50\0\u0a8c\0\u0ac8"+
    "\0\u0ac8\0\u0ac8\0\u0b04\0\u0b40\0\u0b7c\0\u0bb8\0\u0bf4\0\u0c30"+
    "\0\u021c\0\u02d0\0\u0c6c\0\u0ca8\0\u0ce4\0\u0d20\0\u0d5c\0\u0d98"+
    "\0\u0dd4\0\u0e10\0\u0e4c\0\u012c\0\u0e88\0\u0ec4\0\u0f00\0\u0f3c"+
    "\0\u0f78\0\u0fb4\0\u0ff0\0\u102c\0\u1068\0\u10a4\0\u10e0\0\u111c"+
    "\0\u1158\0\u1194\0\u11d0\0\u120c\0\u1248\0\u1284\0\u12c0\0\u12fc"+
    "\0\u1338\0\u1374\0\u13b0\0\u021c\0\u021c\0\u13ec\0\u1428\0\u1464"+
    "\0\u14a0\0\u14dc\0\u1518\0\u1554\0\u1590\0\u15cc\0\u1608\0\u1644"+
    "\0\u0ac8\0\u1680\0\u16bc\0\u16f8\0\u1734\0\u1770\0\u17ac\0\u17e8"+
    "\0\u1824\0\u1860\0\u189c\0\u18d8\0\u1914\0\u1950\0\u198c\0\u19c8"+
    "\0\u1a04\0\u1a40\0\u1a7c\0\u1ab8\0\u1af4\0\u1b30\0\u1b6c\0\u1ba8"+
    "\0\u1be4\0\u1c20\0\u1c5c\0\u021c\0\u1c98\0\u1cd4\0\u1d10\0\u1d4c"+
    "\0\u1d88\0\u1dc4\0\u1e00\0\u1e3c\0\u1e78\0\u1eb4\0\u1ef0\0\u1f2c"+
    "\0\u1f68\0\u1fa4\0\u1fe0\0\u201c\0\u2058\0\u2094\0\u20d0\0\u210c"+
    "\0\u2148\0\u2184\0\u21c0\0\u21fc\0\u2238\0\u2274\0\u22b0\0\u22ec"+
    "\0\u2328\0\u2364\0\u23a0\0\u23dc\0\u2418\0\u2454\0\u2490\0\u24cc"+
    "\0\u2508\0\u2544\0\u2580\0\u25bc\0\u25f8\0\u2634\0\u2670\0\u26ac"+
    "\0\u26e8\0\u2724\0\u2760\0\u279c\0\u27d8\0\u2814\0\u2850\0\u288c"+
    "\0\u28c8\0\u2904\0\u2940\0\u297c\0\u29b8\0\u29f4\0\u2a30\0\u2a6c"+
    "\0\u2aa8\0\u2ae4\0\u2b20\0\u2b5c\0\u2b98\0\u2bd4\0\u2c10\0\u2c4c"+
    "\0\u2c88\0\u2cc4\0\u2d00\0\u2d3c\0\u2d78\0\u2db4\0\u2df0\0\u2e2c"+
    "\0\u2e68\0\u2ea4\0\u2ee0\0\u2f1c\0\u2f58\0\u2f94\0\u2fd0\0\u300c"+
    "\0\u3048\0\u3084\0\u30c0\0\u30fc\0\u3138\0\u3174\0\u31b0\0\u31ec"+
    "\0\u3228\0\u3264\0\u32a0\0\u32dc\0\u3318\0\u3354\0\u3390\0\u33cc"+
    "\0\u3408\0\u3444\0\u3480\0\u34bc\0\u2bd4\0\u34f8\0\u2c88\0\u3534"+
    "\0\u3570\0\u35ac\0\u35e8\0\u3624\0\u3660\0\u369c\0\u36d8\0\u3714"+
    "\0\u3750\0\u378c\0\u37c8\0\u3804\0\u3840\0\u387c\0\u38b8\0\u38f4"+
    "\0\u3930\0\u396c\0\u39a8\0\u39e4\0\u3a20\0\u3a5c\0\u3a98\0\u3ad4"+
    "\0\u3b10\0\u3b4c\0\u3b88\0\u3bc4\0\u3c00\0\u3c3c\0\u3c78\0\u3cb4"+
    "\0\u3cf0\0\u3d2c\0\u3d68\0\u3da4\0\u3de0\0\u3e1c\0\u3e58\0\u3e94"+
    "\0\u3ed0\0\u3f0c\0\u3f48\0\u3f84\0\u3fc0\0\u3ffc\0\u4038\0\u4074"+
    "\0\u40b0\0\u40ec\0\u4128\0\u4164\0\u41a0\0\u41dc\0\u4218\0\u4254"+
    "\0\u4290\0\u42cc\0\u4308\0\u4344\0\u4380\0\u43bc\0\u43f8\0\u4434"+
    "\0\u4470\0\u44ac\0\u44e8\0\u4524\0\u4560\0\u459c\0\u45d8\0\u4614"+
    "\0\u4650\0\u468c\0\u46c8\0\u4704\0\u4740\0\u477c\0\u47b8\0\u47f4"+
    "\0\u4830\0\u486c\0\u48a8\0\u48e4\0\u4920\0\u495c\0\u4998\0\u49d4"+
    "\0\u4a10\0\u4a4c\0\u4a88\0\u4ac4\0\u4b00\0\u4b3c\0\u4b78\0\u4bb4"+
    "\0\u4bf0\0\u4c2c\0\u4c68\0\u4ca4\0\u4ce0\0\u4d1c\0\u4d58\0\u4d94"+
    "\0\u4dd0\0\u4e0c\0\u4e48\0\u4e84\0\u4ec0\0\u4efc\0\u4f38\0\u4f74"+
    "\0\u4fb0\0\u4fec\0\u5028\0\u5064\0\u50a0\0\u50dc\0\u5118\0\u5154"+
    "\0\u5190\0\u51cc\0\u5208\0\u5244\0\u5280\0\u52bc\0\u52f8\0\u5334"+
    "\0\u5370\0\u53ac\0\u53e8\0\u5424\0\u5460\0\u549c\0\u54d8\0\u5514"+
    "\0\u5550\0\u558c\0\u55c8\0\u5604\0\u5640\0\u567c\0\u56b8\0\u56f4"+
    "\0\u5730\0\u576c\0\u57a8\0\u57e4\0\u5820\0\u585c\0\u5898\0\u58d4"+
    "\0\u5910\0\u594c\0\u5988\0\u59c4\0\u5a00\0\u5a3c\0\u5a78\0\u5ab4"+
    "\0\u5af0\0\u5b2c\0\u5b68\0\u5ba4\0\u5be0\0\u5c1c\0\u5c58\0\u5c94"+
    "\0\u5cd0\0\u5d0c\0\u5d48\0\u5d84\0\u5dc0\0\u5dfc\0\u5e38\0\u5e74"+
    "\0\u5eb0\0\u5eec\0\u5f28\0\u5f64\0\u5fa0\0\u5fdc\0\u6018\0\u6054"+
    "\0\u6090\0\u60cc\0\u6108\0\u6144\0\u6180\0\u61bc\0\u61f8\0\u6234"+
    "\0\u6270\0\u62ac\0\u62e8\0\u6324\0\u6360\0\u639c\0\u63d8\0\u6414"+
    "\0\u6450\0\u648c\0\u64c8\0\u6504\0\u6540\0\u657c\0\u65b8\0\u65f4"+
    "\0\u6630\0\u666c\0\u66a8\0\u66e4\0\u6720\0\u675c\0\u6798\0\u67d4"+
    "\0\u6810\0\u684c\0\u6888\0\u68c4\0\u6900\0\u693c\0\u6978\0\u69b4"+
    "\0\u69f0\0\u6a2c\0\u6a68\0\u6aa4\0\u6ae0\0\u6b1c\0\u6b58\0\u6b94"+
    "\0\u6bd0\0\u6c0c\0\u6c48\0\u6c84\0\u6cc0\0\u6cfc\0\u6d38\0\u6d74"+
    "\0\u6db0\0\u6dec\0\u6e28\0\u6e64\0\u6ea0\0\u6edc\0\u6f18\0\u6f54"+
    "\0\u6f90\0\u6fcc\0\u7008\0\u7044\0\u7080\0\u70bc\0\u70f8\0\u7134"+
    "\0\u7170\0\u71ac\0\u71e8\0\u7224\0\u7260\0\u729c\0\u72d8\0\u7314";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\5\2\6\1\7\1\10\1\6\1\7\1\11\1\12"+
    "\1\13\1\5\1\14\1\15\1\16\1\17\4\6\1\20"+
    "\1\21\1\22\1\23\1\24\3\16\1\25\2\16\1\26"+
    "\1\27\1\26\1\5\1\12\1\30\1\31\1\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\3\6\1\44\1\45\1\46\4\6\1\7\1\6\1\47"+
    "\12\50\1\51\1\52\57\50\1\53\13\54\1\55\1\54"+
    "\1\56\25\54\1\57\3\54\1\60\3\54\1\61\20\54"+
    "\13\62\1\63\27\62\1\64\3\62\1\65\3\62\1\66"+
    "\20\62\10\5\1\0\2\5\4\0\4\5\16\0\1\5"+
    "\1\0\30\5\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\30\6\1\0\3\70"+
    "\2\7\1\70\1\7\1\70\1\0\2\70\4\0\1\70"+
    "\1\71\1\72\1\73\1\0\1\74\14\0\1\70\1\0"+
    "\4\70\1\72\1\70\1\71\1\73\1\70\1\72\14\70"+
    "\1\7\1\70\1\0\3\70\1\75\1\76\1\70\1\76"+
    "\1\70\1\0\2\70\4\0\1\77\1\71\1\72\1\73"+
    "\1\0\1\74\14\0\1\70\1\0\4\70\1\72\1\70"+
    "\1\71\1\73\1\70\1\72\11\70\1\77\2\70\1\76"+
    "\1\70\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\15\6\1\100\12\6\75\0"+
    "\10\5\1\0\2\5\2\0\1\101\1\0\4\5\16\0"+
    "\1\5\1\0\30\5\15\0\1\15\107\0\1\26\66\0"+
    "\1\26\4\0\1\26\46\0\2\74\1\0\1\74\62\0"+
    "\1\74\30\0\1\26\1\0\1\26\72\0\1\102\1\26"+
    "\73\0\1\26\2\0\1\103\70\0\1\26\6\0\1\26"+
    "\34\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\13\6\1\104\14\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\1\105\12\6\1\106\6\6\1\107\5\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\17\6\1\110\10\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\5\6\1\111\14\6\1\112\5\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\6\6\1\113\21\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\4\6\1\114"+
    "\10\6\1\115\1\116\11\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\7\6"+
    "\1\117\3\6\1\120\1\121\13\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\1\6\1\122\10\6\1\123\4\6\1\124\5\6\1\125"+
    "\2\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\1\126\4\6\1\127\22\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\7\6\1\130\4\6\1\131\13\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\1\6\1\122\5\6\1\132\2\6"+
    "\1\123\1\133\1\134\13\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\3\6"+
    "\1\135\15\6\1\136\6\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\7\6"+
    "\1\137\20\6\1\0\1\5\6\6\1\140\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\13\6\1\141"+
    "\14\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\6\6\1\142\10\6\1\143"+
    "\10\6\1\0\12\50\2\0\57\50\1\0\13\144\1\0"+
    "\60\144\13\54\1\0\1\54\1\0\25\54\1\0\3\54"+
    "\1\0\3\54\1\0\20\54\11\0\1\145\126\0\1\146"+
    "\73\0\1\147\3\0\1\150\76\0\1\151\20\0\13\62"+
    "\1\0\27\62\1\0\3\62\1\0\3\62\1\0\20\62"+
    "\44\0\1\152\73\0\1\153\3\0\1\154\76\0\1\155"+
    "\20\0\7\5\1\156\1\0\2\5\4\0\4\5\16\0"+
    "\1\5\1\0\30\5\1\0\10\70\1\0\2\70\4\0"+
    "\4\70\16\0\1\70\1\0\30\70\1\0\3\70\2\157"+
    "\1\70\1\157\1\70\1\0\2\70\4\0\4\70\1\160"+
    "\2\0\1\160\12\0\1\70\1\0\26\70\1\157\1\70"+
    "\1\0\3\70\2\74\1\70\1\74\1\70\1\0\2\70"+
    "\4\0\2\70\1\72\1\73\16\0\1\70\1\0\4\70"+
    "\1\72\2\70\1\73\1\70\1\72\14\70\1\74\1\70"+
    "\1\0\3\70\2\75\1\70\1\75\1\70\1\0\2\70"+
    "\4\0\2\70\1\72\1\73\1\0\1\74\14\0\1\70"+
    "\1\0\4\70\1\72\2\70\1\73\1\70\1\72\14\70"+
    "\1\75\1\70\1\0\3\70\1\75\1\76\1\70\1\76"+
    "\1\70\1\0\2\70\4\0\1\70\1\161\1\72\1\73"+
    "\1\0\1\74\14\0\1\70\1\0\4\70\1\72\1\70"+
    "\1\161\1\73\1\70\1\72\14\70\1\76\1\70\1\0"+
    "\3\70\4\162\1\70\1\0\2\70\4\0\2\70\2\162"+
    "\16\0\1\70\1\0\4\70\1\162\2\70\1\162\1\70"+
    "\3\162\5\70\1\162\4\70\1\162\1\70\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\6\6\1\163\1\6\1\164\17\6\31\0\1\26"+
    "\2\0\1\16\40\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\15\6\1\165\12\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\7\6\1\114\7\6\1\166\10\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\16\6\1\167\11\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\2\6\1\170\25\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\14\6"+
    "\1\171\13\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\16\6\1\172\11\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\20\6\1\173\7\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\7\6\1\174\20\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\1\175\15\0\1\5\1\0"+
    "\30\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\15\6\1\176\12\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\1\6\1\177\26\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\20\6\1\200\1\201\6\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\12\6"+
    "\1\202\1\6\1\203\13\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\22\6"+
    "\1\107\5\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\13\6\1\204\14\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\17\6\1\205\10\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\13\6\1\206\14\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\7\6"+
    "\1\207\20\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\1\6\1\210\26\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\4\6\1\211\5\6\1\212\15\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\1\213\6\0\1\214\6\0\1\5\1\0\1\6\1\215"+
    "\4\6\1\216\21\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\17\6\1\124"+
    "\10\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\1\6\1\217\1\6\1\220"+
    "\24\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\15\6\1\221\12\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\3\6\1\222\24\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\14\6\1\223\13\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\1\6\1\224"+
    "\1\6\1\225\23\6\1\226\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\6\6"+
    "\1\227\21\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\12\6\1\230\15\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\14\6\1\231\13\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\7\6\1\232\20\6\45\0\1\233\74\0\1\234"+
    "\77\0\1\235\75\0\1\236\64\0\1\237\74\0\1\240"+
    "\77\0\1\241\75\0\1\242\20\0\3\5\4\243\1\5"+
    "\1\0\2\5\4\0\2\5\2\243\16\0\1\5\1\0"+
    "\4\5\1\243\2\5\1\243\1\5\3\243\5\5\1\243"+
    "\4\5\1\243\1\5\1\0\3\70\2\157\1\70\1\157"+
    "\1\70\1\0\2\70\4\0\2\70\1\72\1\70\16\0"+
    "\1\70\1\0\4\70\1\72\4\70\1\72\14\70\1\157"+
    "\1\70\4\0\2\157\1\0\1\157\62\0\1\157\2\0"+
    "\3\70\4\162\1\70\1\0\2\70\4\0\1\70\1\161"+
    "\2\162\16\0\1\70\1\0\4\70\1\162\1\70\1\161"+
    "\1\162\1\70\3\162\5\70\1\162\4\70\1\162\1\70"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\7\6\1\244\20\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\5\6\1\245\22\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\11\6"+
    "\1\246\16\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\14\6\1\247\13\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\21\6\1\250\6\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\7\6\1\251\20\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\12\6"+
    "\1\252\3\6\1\253\6\6\1\254\2\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\15\6\1\255\12\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\21\6"+
    "\1\256\6\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\1\6\1\114\26\6"+
    "\46\0\1\257\26\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\14\6\1\260\13\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\7\0\1\214\6\0\1\5\1\0\30\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\21\6\1\261\6\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\7\6"+
    "\1\262\20\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\13\6\1\263\14\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\2\6\1\114\25\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\3\6\1\220\24\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\14\6"+
    "\1\264\13\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\6\6\1\265\21\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\15\6\1\114\12\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\1\266\27\6\1\0\1\5\6\6\1\207\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\1\6"+
    "\1\267\1\270\1\271\1\6\1\272\4\6\1\273\3\6"+
    "\1\274\1\6\1\275\4\6\1\276\2\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\6\6\1\277\21\6\47\0\1\300\3\0\1\301"+
    "\3\0\1\302\15\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\5\6\1\303\22\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\5\6\1\304\22\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\12\6\1\305\15\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\7\6"+
    "\1\114\20\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\11\6\1\114\16\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\7\6\1\223\20\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\17\6\1\174\10\6\1\0\1\5\6\6\1\306"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\30\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\1\6\1\307\26\6\1\0"+
    "\1\5\6\6\1\310\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\30\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\1\6"+
    "\1\311\26\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\17\6\1\312\10\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\12\6\1\313\15\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\13\6\1\313\14\6\46\0\1\314\66\0\1\315"+
    "\105\0\1\234\45\0\1\316\114\0\1\317\66\0\1\320"+
    "\105\0\1\240\45\0\1\321\47\0\3\5\4\322\1\5"+
    "\1\0\2\5\4\0\2\5\2\322\16\0\1\5\1\0"+
    "\4\5\1\322\2\5\1\322\1\5\3\322\5\5\1\322"+
    "\4\5\1\322\1\5\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\3\6\1\323"+
    "\24\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\15\6\1\324\12\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\6\6\1\325\21\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\10\6\1\114\17\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\14\6\1\326"+
    "\13\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\12\6\1\123\15\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\6\6\1\327\21\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\7\0\1\214\6\0"+
    "\1\5\1\0\15\6\1\114\7\6\2\114\1\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\5\6\1\330\22\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\13\6\1\331\14\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\14\6\1\332"+
    "\13\6\57\0\1\333\15\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\17\6\1\334"+
    "\10\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\11\6\1\335\16\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\6\6\1\323\21\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\6\6\1\336\21\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\17\6\1\114"+
    "\10\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\1\337\15\0\1\5\1\0\30\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\1\340\15\0"+
    "\1\5\1\0\30\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\22\6\1\341"+
    "\5\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\13\6\1\342\14\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\1\6\1\343\5\6\1\344\20\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\15\6\1\345\12\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\6\6\1\346\5\6\1\347\13\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\7\6\1\350\20\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\7\6\1\351"+
    "\3\6\1\352\14\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\13\6\1\264"+
    "\14\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\13\6\1\353\14\6\66\0"+
    "\1\354\74\0\1\355\56\0\1\356\22\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\20\6\1\357\7\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\3\6\1\174"+
    "\24\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\1\114\27\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\17\6\1\360\10\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\13\6"+
    "\1\361\14\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\5\6\1\362\22\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\5\6\1\363\22\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\14\6\1\34\13\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\24\6"+
    "\1\114\3\6\41\0\1\315\5\0\1\234\62\0\1\364"+
    "\37\0\1\316\1\365\5\316\1\0\1\365\4\0\1\365"+
    "\4\316\4\365\1\0\1\365\1\0\1\365\1\0\1\365"+
    "\1\316\5\365\30\316\41\0\1\320\5\0\1\240\62\0"+
    "\1\366\37\0\1\321\1\367\5\321\1\0\1\367\4\0"+
    "\1\367\4\321\4\367\1\0\1\367\1\0\1\367\1\0"+
    "\1\367\1\321\5\367\30\321\1\0\3\5\4\370\1\5"+
    "\1\0\2\5\4\0\2\5\2\370\16\0\1\5\1\0"+
    "\4\5\1\370\2\5\1\370\1\5\3\370\5\5\1\370"+
    "\4\5\1\370\1\5\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\3\6\1\114"+
    "\24\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\11\6\1\371\16\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\7\6\1\372\20\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\11\6\1\373\16\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\13\6\1\374"+
    "\14\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\11\6\1\220\16\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\6\6\1\114\21\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\6\6\1\375\21\6\56\0\1\376\16\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\7\6\1\377\20\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\13\6\1\114"+
    "\14\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\6\6\1\373\21\6\54\0"+
    "\1\u0100\63\0\1\u0101\1\0\1\u0102\1\u0103\1\0\1\u0104"+
    "\4\0\1\u0105\1\u0106\1\u0107\14\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\2\6"+
    "\1\220\25\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\12\6\1\u0108\4\6"+
    "\1\u0109\10\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\17\6\1\u010a\10\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\1\6\1\u010b\26\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\7\6\1\u010c\20\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\13\6"+
    "\1\244\14\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\15\6\1\u010d\12\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\15\6\1\u010e\12\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\1\6\1\u010f\26\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\12\6"+
    "\1\u0110\15\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\5\6\1\u0111\11\6"+
    "\1\220\10\6\64\0\1\u0112\54\0\1\u0113\100\0\1\u0114"+
    "\22\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\7\6\1\323\20\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\15\6\1\u0115\12\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\17\6"+
    "\1\u0116\10\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\17\6\1\220\10\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\2\6\1\u0117\25\6\36\0\1\316"+
    "\73\0\1\321\36\0\3\5\4\6\1\5\1\0\2\5"+
    "\4\0\2\5\2\6\16\0\1\5\1\0\4\5\1\6"+
    "\2\5\1\6\1\5\3\6\5\5\1\6\4\5\1\6"+
    "\1\5\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\1\u0118\15\0\1\5\1\0\30\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\17\6\1\u0119\10\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\22\6"+
    "\1\114\5\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\5\6\1\u0111\22\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\1\u011a\15\0\1\5\1\0\30\6\70\0\1\u011b\4\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\1\u011c"+
    "\15\0\1\5\1\0\30\6\44\0\1\u011d\106\0\1\u011e"+
    "\73\0\1\u011f\61\0\1\u0120\3\0\1\u0121\1\u0122\102\0"+
    "\1\u0123\72\0\1\u0124\71\0\1\u0125\25\0\1\u0126\35\0"+
    "\1\u0127\26\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\24\6\1\u0128\3\6\1\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\13\6\1\u0129\14\6\1\0\1\5\6\6"+
    "\1\u012a\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\30\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\4\6\1\114\23\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\1\u012b\15\0\1\5\1\0\30\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\3\6\1\u012c\24\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\7\6\1\u012d"+
    "\20\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\1\u012e\27\6\1\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\17\6\1\u012f\10\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\20\6"+
    "\1\114\7\6\65\0\1\u0130\61\0\1\u0131\44\0\1\u0132"+
    "\50\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\1\u0133\15\0\1\5\1\0\30\6\1\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\1\6\1\u0134\26\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\6\6\1\u0135"+
    "\21\6\46\0\1\u0136\26\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\1\u0137\15\0\1\5\1\0\30\6"+
    "\64\0\1\u0138\66\0\1\u0139\67\0\1\u013a\73\0\1\u013b"+
    "\67\0\1\u013c\102\0\1\u013d\74\0\1\u013e\100\0\1\u013f"+
    "\67\0\1\u0140\61\0\1\u0141\106\0\1\u0142\2\0\1\u0143"+
    "\65\0\1\u0144\62\0\1\u0145\101\0\1\u0146\21\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\13\6\1\u0147\14\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\20\6"+
    "\1\u0148\7\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\12\6\1\174\15\6"+
    "\47\0\1\u0149\6\0\1\u014a\5\0\1\u014b\10\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\16\0\1\5"+
    "\1\0\1\6\1\u014c\26\6\1\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\17\6"+
    "\1\u014d\10\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\14\6\1\221\13\6"+
    "\1\0\1\5\7\6\1\0\1\5\1\67\4\0\4\6"+
    "\16\0\1\5\1\0\14\6\1\114\13\6\60\0\1\u014e"+
    "\76\0\1\u014f\57\0\1\300\74\0\1\u0150\24\0\1\5"+
    "\7\6\1\0\1\5\1\67\4\0\4\6\1\u0151\15\0"+
    "\1\5\1\0\30\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\7\6\1\u0152"+
    "\20\6\63\0\1\u0153\66\0\1\u0154\6\0\1\u0155\65\0"+
    "\1\u0156\76\0\1\u0157\74\0\1\u0158\71\0\1\214\56\0"+
    "\1\u0159\117\0\1\u015a\64\0\1\u015b\60\0\1\u015c\72\0"+
    "\1\u015d\36\0\1\u015e\140\0\1\u015f\64\0\1\u0160\100\0"+
    "\1\u0161\66\0\1\u0162\106\0\1\u0163\13\0\1\5\7\6"+
    "\1\0\1\5\1\67\4\0\4\6\16\0\1\5\1\0"+
    "\16\6\1\220\11\6\1\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\7\6\1\u0164"+
    "\20\6\53\0\1\u0165\12\0\1\u0166\65\0\1\u0167\66\0"+
    "\1\u0168\4\0\1\u0169\14\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\16\0\1\5\1\0\13\6\1\u016a"+
    "\14\6\1\0\1\5\7\6\1\0\1\5\1\67\4\0"+
    "\4\6\16\0\1\5\1\0\5\6\1\u016b\22\6\52\0"+
    "\1\u015d\102\0\1\u016c\75\0\1\u016d\66\0\1\u0154\2\0"+
    "\1\u016e\3\0\1\u0155\7\0\1\5\7\6\1\0\1\5"+
    "\1\67\4\0\4\6\1\u016f\15\0\1\5\1\0\30\6"+
    "\60\0\1\u0170\72\0\1\u0171\65\0\1\u0172\100\0\1\u0173"+
    "\70\0\1\214\103\0\1\u0174\34\0\1\u0175\126\0\1\u0176"+
    "\71\0\1\u0177\70\0\1\u0178\70\0\1\214\71\0\1\u0179"+
    "\77\0\1\u017a\73\0\1\u017b\71\0\1\u017c\34\0\1\u017d"+
    "\107\0\1\u017e\50\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\1\6\1\u017f\26\6"+
    "\45\0\1\u0180\112\0\1\u0181\70\0\1\u0182\2\0\1\u0183"+
    "\54\0\1\u0184\103\0\1\u0185\17\0\1\5\7\6\1\0"+
    "\1\5\1\67\4\0\4\6\16\0\1\5\1\0\15\6"+
    "\1\174\12\6\1\0\1\5\7\6\1\0\1\5\1\67"+
    "\4\0\4\6\16\0\1\5\1\0\12\6\1\114\15\6"+
    "\57\0\1\356\74\0\1\u0186\72\0\1\u0187\105\0\1\u0188"+
    "\47\0\1\u0189\75\0\1\u0157\105\0\1\u018a\75\0\1\u018b"+
    "\70\0\1\u018c\60\0\1\u018d\110\0\1\u018e\70\0\1\u018f"+
    "\67\0\1\u0190\44\0\1\u0191\114\0\1\u0192\100\0\1\u0193"+
    "\70\0\1\u0174\71\0\1\u0194\75\0\1\u0195\1\u0196\24\0"+
    "\1\5\7\6\1\0\1\5\1\67\4\0\4\6\16\0"+
    "\1\5\1\0\7\6\1\264\20\6\50\0\1\u0197\110\0"+
    "\1\u0198\63\0\1\u0199\64\0\1\u019a\71\0\1\u019b\100\0"+
    "\1\u019c\106\0\1\214\73\0\1\u0157\66\0\1\u019d\67\0"+
    "\1\u019e\75\0\1\214\76\0\1\u019f\76\0\1\u015d\67\0"+
    "\1\u01a0\67\0\1\u01a1\103\0\1\u01a2\34\0\1\u01a3\117\0"+
    "\1\u01a4\74\0\1\u01a5\101\0\1\u01a6\40\0\1\u01a7\114\0"+
    "\1\u01a8\77\0\1\u01a9\46\0\1\u01aa\127\0\1\u01ab\64\0"+
    "\1\u01ac\73\0\1\u01ad\102\0\1\u01ae\63\0\1\u01af\75\0"+
    "\1\u01b0\77\0\1\u01b1\67\0\1\u01b2\106\0\1\u01b3\32\0"+
    "\1\u01b4\124\0\1\u01b5\101\0\1\u01b6\73\0\1\u01b7\70\0"+
    "\1\u01b8\60\0\1\u01b9\73\0\1\u01ba\111\0\1\u01bb\62\0"+
    "\1\u0157\74\0\1\u01bc\72\0\1\u01bd\66\0\1\u01be\100\0"+
    "\1\u01bf\76\0\1\u01c0\104\0\1\u01bd\15\0\1\u01c1\130\0"+
    "\1\214\101\0\1\u01b1\72\0\1\u018e\72\0\1\u01c2\46\0"+
    "\1\u01c3\122\0\1\u01c4\100\0\1\u01c5\74\0\1\u01c6\63\0"+
    "\1\u01c7\102\0\1\u01c8\66\0\1\u01c9\107\0\1\u01ca\30\0"+
    "\1\u01cb\120\0\1\u01cc\75\0\1\u01cd\44\0\1\u01ce\122\0"+
    "\1\u01cf\65\0\1\u01d0\77\0\1\u01d1\71\0\1\u01d2\110\0"+
    "\1\u01c8\33\0\1\u01d3\127\0\1\u01d4\37\0\1\u01d5\126\0"+
    "\1\u0186\62\0\1\u01d6\111\0\1\u01d7\67\0\1\u013b\76\0"+
    "\1\u01bd\66\0\1\u01d8\41\0\1\u01d9\122\0\1\u01da\100\0"+
    "\1\u01db\60\0\1\u01dc\111\0\1\u01dd\71\0\1\u01de\61\0"+
    "\1\u01df\103\0\1\u01e0\73\0\1\u01e1\74\0\1\u01e2\100\0"+
    "\1\u0155\71\0\1\u01e3\34\0\1\u01e4\126\0\1\u01e5\67\0"+
    "\1\u01e6\44\0\1\u01e7\114\0\1\u01e8\107\0\1\u01e9\70\0"+
    "\1\u01ea\101\0\1\u01eb\66\0\1\u01ec\63\0\1\u01ed\107\0"+
    "\1\u01b1\57\0\1\u01ee\34\0\1\u01ef\146\0\1\u01f0\65\0"+
    "\1\u01f1\101\0\1\u01f2\75\0\1\u01f3\53\0\1\u01f4\114\0"+
    "\1\u01f5\52\0\1\u01f6\107\0\1\u01f7\63\0\1\u01f8\75\0"+
    "\1\u01f9\100\0\1\214\64\0\1\u01fa\102\0\1\u01f9\74\0"+
    "\1\u01fb\71\0\1\u01fc\65\0\1\u01b1\103\0\1\u01fd\75\0"+
    "\1\214\71\0\1\u01fe\57\0\1\u01ff\111\0\1\u0140\72\0"+
    "\1\214\70\0\1\u01ac\73\0\1\u0200\103\0\1\214\5\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[29520];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\5\1\1\11\1\1\1\11\2\1\1\11\2\1"+
    "\1\11\3\1\1\11\20\1\1\11\2\1\2\11\1\1"+
    "\1\11\5\1\1\11\15\1\1\11\1\0\41\1\2\11"+
    "\10\0\2\1\1\0\14\1\1\0\15\1\1\0\1\11"+
    "\16\1\10\0\14\1\1\0\20\1\3\0\11\1\2\0"+
    "\1\1\2\0\12\1\1\0\3\1\2\0\13\1\3\0"+
    "\5\1\4\0\6\1\1\0\1\1\10\0\12\1\3\0"+
    "\3\1\1\0\1\1\16\0\3\1\1\0\4\1\4\0"+
    "\2\1\21\0\2\1\3\0\2\1\4\0\1\1\21\0"+
    "\1\1\5\0\2\1\23\0\1\1\201\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[512];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */


	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public LispTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addToken(int, int, int)
	 */
	private void addHyperlinkToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, true);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 * @see #addHyperlinkToken(int, int, int)
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so, false);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 * @param hyperlink Whether this token is a hyperlink.
	 */
	public void addToken(char[] array, int start, int end, int tokenType,
						int startOffset, boolean hyperlink) {
		super.addToken(array, start,end, tokenType, startOffset, hyperlink);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { ";", null };
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.COMMENT_MULTILINE:
				state = MLC;
				start = text.offset;
				break;
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 * @exception   IOException  if any I/O-Error occurs.
	 */
	private boolean zzRefill() throws java.io.IOException {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) throws java.io.IOException {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public LispTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public LispTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 160) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 4: 
          { addNullToken(); return firstToken;
          }
        case 24: break;
        case 21: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead+1, Token.COMMENT_MULTILINE);
          }
        case 25: break;
        case 19: 
          { start = zzMarkedPos-2; yybegin(MLC);
          }
        case 26: break;
        case 5: 
          { addToken(Token.WHITESPACE);
          }
        case 27: break;
        case 18: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 28: break;
        case 17: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 29: break;
        case 20: 
          { addToken(Token.RESERVED_WORD);
          }
        case 30: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 31: break;
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 32: break;
        case 15: 
          { addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 33: break;
        case 11: 
          { /* Skip escaped chars. */
          }
        case 34: break;
        case 1: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 35: break;
        case 12: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 36: break;
        case 23: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_EOL); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos;
          }
        case 37: break;
        case 22: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); addHyperlinkToken(temp,zzMarkedPos-1, Token.COMMENT_MULTILINE); start = zzMarkedPos;
          }
        case 38: break;
        case 16: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 39: break;
        case 9: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 40: break;
        case 7: 
          { start = zzMarkedPos-1; yybegin(EOL_COMMENT);
          }
        case 41: break;
        case 3: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 42: break;
        case 6: 
          { addToken(Token.OPERATOR);
          }
        case 43: break;
        case 13: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 44: break;
        case 10: 
          { 
          }
        case 45: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
          }
        case 46: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case EOL_COMMENT: {
              addToken(start,zzStartRead-1, Token.COMMENT_EOL); addNullToken(); return firstToken;
            }
            case 513: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 514: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 515: break;
            case MLC: {
              addToken(start,zzStartRead-1, Token.COMMENT_MULTILINE); return firstToken;
            }
            case 516: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
