/* The following code was generated by JFlex 1.4.1 on 7/21/10 11:35 PM */

/*
 * 01/26/2008
 *
 * PerlTokenMaker.java - Scanner for Perl
 * Copyright (C) 2008 Robert Futrell
 * robert_futrell at users.sourceforge.net
 * http://fifesoft.com/rsyntaxtextarea
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import java.io.*;
import javax.swing.text.Segment;

import org.fife.ui.rsyntaxtextarea.*;


/**
 * Scanner for Perl.<p>
 *
 * This implementation was created using
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1; however, the generated file
 * was modified for performance.  Memory allocation needs to be almost
 * completely removed to be competitive with the handwritten lexers (subclasses
 * of <code>AbstractTokenMaker</code>, so this class has been modified so that
 * Strings are never allocated (via yytext()), and the scanner never has to
 * worry about refilling its buffer (needlessly copying chars around).
 * We can achieve this because RText always scans exactly 1 line of tokens at a
 * time, and hands the scanner this line as an array of characters (a Segment
 * really).  Since tokens contain pointers to char arrays instead of Strings
 * holding their contents, there is no need for allocating new memory for
 * Strings.<p>
 *
 * The actual algorithm generated for scanning has, of course, not been
 * modified.<p>
 *
 * If you wish to regenerate this file yourself, keep in mind the following:
 * <ul>
 *   <li>The generated PerlTokenMaker.java</code> file will contain two
 *       definitions of both <code>zzRefill</code> and <code>yyreset</code>.
 *       You should hand-delete the second of each definition (the ones
 *       generated by the lexer), as these generated methods modify the input
 *       buffer, which we'll never have to do.</li>
 *   <li>You should also change the declaration/definition of zzBuffer to NOT
 *       be initialized.  This is a needless memory allocation for us since we
 *       will be pointing the array somewhere else anyway.</li>
 *   <li>You should NOT call <code>yylex()</code> on the generated scanner
 *       directly; rather, you should use <code>getTokenList</code> as you would
 *       with any other <code>TokenMaker</code> instance.</li>
 * </ul>
 *
 * @author Robert Futrell
 * @version 0.5
 *
 */

public class PerlTokenMaker extends AbstractJFlexCTokenMaker {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** lexical states */
  public static final int HEREDOC_EOF_SINGLE_QUOTED = 5;
  public static final int HEREDOC_EOT_SINGLE_QUOTED = 7;
  public static final int HEREDOC_EOT_UNQUOTED = 6;
  public static final int STRING = 1;
  public static final int BACKTICKS = 3;
  public static final int YYINITIAL = 0;
  public static final int HEREDOC_EOF_UNQUOTED = 4;
  public static final int CHAR_LITERAL = 2;
  public static final int POD = 8;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\12\1\11\1\0\1\12\1\6\22\0\1\12\1\41\1\101"+
    "\1\7\1\30\1\24\1\43\1\45\1\21\1\25\1\36\1\32\1\22"+
    "\1\17\1\20\1\40\1\3\1\54\1\55\1\54\1\54\3\5\2\2"+
    "\1\22\1\22\1\33\1\34\1\37\1\42\1\23\3\4\1\15\1\16"+
    "\1\103\5\1\1\14\2\1\1\102\4\1\1\104\3\1\1\13\2\1"+
    "\1\21\1\10\1\21\1\35\1\1\1\31\1\53\1\63\1\64\1\50"+
    "\1\52\1\70\1\66\1\51\1\60\1\100\1\65\1\72\1\62\1\67"+
    "\1\47\1\46\1\74\1\57\1\73\1\61\1\71\1\56\1\76\1\75"+
    "\1\77\1\1\1\26\1\44\1\27\1\42\uff81\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\11\0\1\1\1\2\2\3\1\1\1\4\1\5\1\6"+
    "\1\7\1\2\1\10\1\2\1\1\1\7\1\10\1\1"+
    "\1\11\10\7\1\12\31\2\1\13\1\14\1\15\1\16"+
    "\2\14\1\17\1\14\1\20\1\21\1\22\1\14\1\23"+
    "\2\14\1\24\1\14\1\25\4\14\1\26\1\14\1\27"+
    "\1\14\1\30\2\14\1\31\1\14\1\32\1\3\1\33"+
    "\1\32\1\33\1\32\1\34\1\32\1\4\1\35\1\36"+
    "\1\0\3\36\11\0\1\7\6\2\1\37\2\2\1\37"+
    "\34\2\1\1\3\0\2\2\1\40\13\2\1\37\3\2"+
    "\1\40\1\37\6\2\1\40\2\2\1\37\3\2\3\0"+
    "\21\2\1\1\3\0\1\2\1\15\1\41\1\0\1\41"+
    "\1\0\1\20\1\42\1\0\1\42\1\0\1\14\1\43"+
    "\1\0\1\43\1\0\3\14\10\0\1\33\1\0\2\34"+
    "\16\0\40\2\1\40\1\2\1\0\2\40\5\2\1\40"+
    "\10\2\1\37\17\2\3\0\14\2\1\37\7\2\1\0"+
    "\1\1\5\0\1\44\1\0\1\44\15\0\1\45\5\0"+
    "\1\40\2\2\1\40\15\2\1\40\5\2\2\40\27\2"+
    "\1\40\22\2\1\40\1\2\1\0\2\40\1\46\5\0"+
    "\1\47\1\50\1\51\6\0\2\2\1\40\36\2\1\40"+
    "\11\2\12\0\17\2\1\40\4\2\1\0\1\52\1\53"+
    "\1\0\14\2\2\0\5\2\1\0\12\2";

  private static int [] zzUnpackAction() {
    int [] result = new int[573];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\105\0\212\0\317\0\u0114\0\u0159\0\u019e\0\u01e3"+
    "\0\u0228\0\u026d\0\u02b2\0\u02f7\0\u033c\0\u0381\0\u03c6\0\u0381"+
    "\0\u040b\0\u0450\0\u0495\0\u0381\0\u0381\0\u04da\0\u051f\0\u0564"+
    "\0\u05a9\0\u0381\0\u05ee\0\u0633\0\u0678\0\u06bd\0\u0702\0\u0747"+
    "\0\u0381\0\u078c\0\u0381\0\u07d1\0\u0816\0\u085b\0\u08a0\0\u08e5"+
    "\0\u092a\0\u096f\0\u09b4\0\u09f9\0\u0a3e\0\u0a83\0\u0ac8\0\u0b0d"+
    "\0\u0b52\0\u0b97\0\u0bdc\0\u0c21\0\u0c66\0\u0cab\0\u0cf0\0\u0d35"+
    "\0\u0d7a\0\u0dbf\0\u0e04\0\u0e49\0\u0381\0\u0e8e\0\u0ed3\0\u0381"+
    "\0\u0f18\0\u0f5d\0\u0381\0\u0fa2\0\u0fe7\0\u0381\0\u0381\0\u102c"+
    "\0\u0381\0\u1071\0\u10b6\0\u0381\0\u10fb\0\u0381\0\u1140\0\u1185"+
    "\0\u11ca\0\u120f\0\u0381\0\u1254\0\u0381\0\u1299\0\u0381\0\u12de"+
    "\0\u1323\0\u0381\0\u1368\0\u13ad\0\u13ad\0\u13ad\0\u13f2\0\u1437"+
    "\0\u147c\0\u14c1\0\u1506\0\u154b\0\u1590\0\u15d5\0\u161a\0\u165f"+
    "\0\u026d\0\u0381\0\u16a4\0\u16e9\0\u172e\0\u1773\0\u17b8\0\u17fd"+
    "\0\u1842\0\u1887\0\u18cc\0\u1911\0\u1956\0\u199b\0\u19e0\0\u1a25"+
    "\0\u1a6a\0\u1aaf\0\u1af4\0\u1b39\0\u1b7e\0\u02b2\0\u1bc3\0\u1c08"+
    "\0\u1c4d\0\u1c92\0\u1cd7\0\u1d1c\0\u1d61\0\u1da6\0\u1deb\0\u1e30"+
    "\0\u1e75\0\u1eba\0\u1eff\0\u1f44\0\u1f89\0\u1fce\0\u2013\0\u2058"+
    "\0\u209d\0\u20e2\0\u2127\0\u216c\0\u21b1\0\u21f6\0\u223b\0\u2280"+
    "\0\u22c5\0\u230a\0\u234f\0\u2394\0\u23d9\0\u241e\0\u2463\0\u24a8"+
    "\0\u02b2\0\u24ed\0\u2532\0\u2577\0\u25bc\0\u2601\0\u2646\0\u268b"+
    "\0\u26d0\0\u2715\0\u275a\0\u279f\0\u27e4\0\u2829\0\u286e\0\u28b3"+
    "\0\u28f8\0\u293d\0\u2982\0\u29c7\0\u2a0c\0\u2a51\0\u2a96\0\u2adb"+
    "\0\u2b20\0\u2b65\0\u2baa\0\u2bef\0\u2c34\0\u2c79\0\u2cbe\0\u2d03"+
    "\0\u2d48\0\u2d8d\0\u2dd2\0\u2e17\0\u2e5c\0\u2ea1\0\u2ee6\0\u2f2b"+
    "\0\u2f70\0\u2fb5\0\u2ffa\0\u303f\0\u3084\0\u30c9\0\u310e\0\u3153"+
    "\0\u3198\0\u31dd\0\u3222\0\u3267\0\u32ac\0\u32f1\0\u3336\0\u337b"+
    "\0\u0381\0\u33c0\0\u3405\0\u0381\0\u344a\0\u0381\0\u348f\0\u34d4"+
    "\0\u0381\0\u3519\0\u355e\0\u35a3\0\u35e8\0\u0381\0\u362d\0\u3672"+
    "\0\u36b7\0\u36fc\0\u3741\0\u3786\0\u37cb\0\u3810\0\u3855\0\u389a"+
    "\0\u38df\0\u3924\0\u3969\0\u39ae\0\u13ad\0\u39f3\0\u3a38\0\u3a7d"+
    "\0\u3ac2\0\u3b07\0\u3b4c\0\u3b91\0\u3bd6\0\u3c1b\0\u3c60\0\u3ca5"+
    "\0\u3cea\0\u3d2f\0\u3d74\0\u3db9\0\u3dfe\0\u3e43\0\u3e88\0\u3ecd"+
    "\0\u3f12\0\u3f57\0\u3f9c\0\u3fe1\0\u4026\0\u406b\0\u40b0\0\u40f5"+
    "\0\u413a\0\u417f\0\u41c4\0\u4209\0\u424e\0\u4293\0\u42d8\0\u431d"+
    "\0\u4362\0\u43a7\0\u43ec\0\u4431\0\u4476\0\u44bb\0\u1af4\0\u4500"+
    "\0\u4545\0\u458a\0\u45cf\0\u4614\0\u1af4\0\u4659\0\u469e\0\u46e3"+
    "\0\u4728\0\u476d\0\u47b2\0\u47f7\0\u483c\0\u4881\0\u48c6\0\u490b"+
    "\0\u4950\0\u4995\0\u49da\0\u4a1f\0\u4a64\0\u4aa9\0\u28f8\0\u4aee"+
    "\0\u4b33\0\u4b78\0\u4bbd\0\u4c02\0\u4c47\0\u4c8c\0\u4cd1\0\u4d16"+
    "\0\u4d5b\0\u4da0\0\u4de5\0\u4e2a\0\u4e6f\0\u4eb4\0\u4ef9\0\u4f3e"+
    "\0\u4f83\0\u4fc8\0\u500d\0\u5052\0\u5097\0\u50dc\0\u5121\0\u5166"+
    "\0\u51ab\0\u51f0\0\u5235\0\u527a\0\u52bf\0\u5304\0\u5349\0\u538e"+
    "\0\u53d3\0\u5418\0\u545d\0\u54a2\0\u54e7\0\u552c\0\u5571\0\u55b6"+
    "\0\u55fb\0\u5640\0\u5685\0\u56ca\0\u570f\0\u10fb\0\u5754\0\u120f"+
    "\0\u5799\0\u57de\0\u5823\0\u5868\0\u58ad\0\u58f2\0\u5937\0\u597c"+
    "\0\u59c1\0\u5a06\0\u5a4b\0\u5a90\0\u5ad5\0\u0381\0\u5b1a\0\u5b5f"+
    "\0\u5ba4\0\u5be9\0\u5c2e\0\u5c73\0\u5cb8\0\u5cfd\0\u21b1\0\u5d42"+
    "\0\u5d87\0\u5dcc\0\u5e11\0\u5e56\0\u5e9b\0\u5ee0\0\u5f25\0\u5f6a"+
    "\0\u5faf\0\u5ff4\0\u6039\0\u607e\0\u60c3\0\u6108\0\u614d\0\u6192"+
    "\0\u61d7\0\u621c\0\u1f44\0\u6261\0\u62a6\0\u62eb\0\u6330\0\u6375"+
    "\0\u63ba\0\u63ff\0\u6444\0\u6489\0\u64ce\0\u6513\0\u6558\0\u659d"+
    "\0\u65e2\0\u6627\0\u666c\0\u66b1\0\u66f6\0\u673b\0\u6780\0\u67c5"+
    "\0\u680a\0\u684f\0\u6894\0\u68d9\0\u691e\0\u6963\0\u69a8\0\u69ed"+
    "\0\u6a32\0\u6a77\0\u6abc\0\u6b01\0\u6b46\0\u6b8b\0\u6bd0\0\u6c15"+
    "\0\u6c5a\0\u6c9f\0\u6ce4\0\u6d29\0\u6d6e\0\u6db3\0\u6df8\0\u6e3d"+
    "\0\u6e82\0\u6ec7\0\u6f0c\0\u0381\0\u6f51\0\u6f96\0\u6fdb\0\u7020"+
    "\0\u7065\0\u0381\0\u0381\0\u0381\0\u70aa\0\u70ef\0\u7134\0\u7179"+
    "\0\u71be\0\u7203\0\u7248\0\u728d\0\u1d1c\0\u72d2\0\u7317\0\u735c"+
    "\0\u73a1\0\u73e6\0\u742b\0\u7470\0\u74b5\0\u74fa\0\u753f\0\u7584"+
    "\0\u75c9\0\u760e\0\u7653\0\u7698\0\u76dd\0\u7722\0\u7767\0\u77ac"+
    "\0\u77f1\0\u7836\0\u787b\0\u78c0\0\u7905\0\u794a\0\u798f\0\u79d4"+
    "\0\u7a19\0\u7a5e\0\u7aa3\0\u286e\0\u7ae8\0\u7b2d\0\u7b72\0\u7bb7"+
    "\0\u7bfc\0\u7c41\0\u7c86\0\u7ccb\0\u7d10\0\u7d55\0\u7d9a\0\u7ddf"+
    "\0\u7e24\0\u7e69\0\u7eae\0\u7ef3\0\u7f38\0\u7f7d\0\u7fc2\0\u8007"+
    "\0\u804c\0\u8091\0\u80d6\0\u811b\0\u8160\0\u81a5\0\u81ea\0\u822f"+
    "\0\u8274\0\u82b9\0\u82fe\0\u8343\0\u8388\0\u83cd\0\u8412\0\u8457"+
    "\0\u849c\0\u84e1\0\u8526\0\u856b\0\u0381\0\u0381\0\u85b0\0\u85f5"+
    "\0\u863a\0\u867f\0\u86c4\0\u8709\0\u874e\0\u8793\0\u87d8\0\u881d"+
    "\0\u8862\0\u88a7\0\u88ec\0\u8931\0\u8976\0\u89bb\0\u8a00\0\u8a45"+
    "\0\u8a8a\0\u8acf\0\u8b14\0\u8b59\0\u8b9e\0\u8be3\0\u8c28\0\u8c6d"+
    "\0\u8cb2\0\u8cf7\0\u8d3c\0\u8d81\0\u8dc6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[573];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\12\1\13\1\14\1\15\1\13\1\14\1\16\1\17"+
    "\1\12\1\20\1\21\4\13\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\2\24\1\31\1\32\1\33\1\34"+
    "\1\35\1\36\1\37\1\40\2\36\1\41\1\42\1\36"+
    "\1\43\1\44\1\45\1\46\1\47\1\50\1\51\2\14"+
    "\1\52\1\53\1\54\1\55\1\56\1\57\1\60\1\61"+
    "\1\62\1\63\1\64\1\65\1\66\1\67\1\70\1\71"+
    "\1\72\1\73\1\74\1\75\3\13\10\76\1\77\1\100"+
    "\11\76\2\101\3\76\1\102\50\76\1\103\3\76\10\104"+
    "\1\105\1\106\33\104\1\107\37\104\10\110\1\77\1\111"+
    "\11\110\2\112\3\110\1\113\1\114\53\110\10\115\1\77"+
    "\1\116\4\115\1\117\4\115\2\120\3\115\1\121\54\115"+
    "\10\122\1\77\1\123\4\122\1\124\66\122\10\115\1\77"+
    "\1\125\4\115\1\126\4\115\2\120\3\115\1\121\54\115"+
    "\10\122\1\77\1\127\4\122\1\130\66\122\11\131\1\132"+
    "\22\131\1\133\50\131\6\12\1\0\2\12\2\0\4\12"+
    "\4\0\1\12\4\0\1\12\15\0\33\12\1\0\4\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\33\13\1\0\3\13\2\134\2\14\1\134"+
    "\1\14\1\0\2\134\2\0\1\134\1\135\1\136\1\137"+
    "\1\0\1\140\2\0\1\134\4\0\1\134\15\0\2\134"+
    "\1\136\1\134\1\137\1\134\2\14\12\134\1\136\1\134"+
    "\1\135\6\134\1\0\1\134\1\136\3\134\1\141\1\142"+
    "\1\134\1\142\1\0\2\134\2\0\1\143\1\135\1\136"+
    "\1\137\1\0\1\140\2\0\1\134\4\0\1\134\15\0"+
    "\2\134\1\136\1\134\1\137\1\134\2\142\12\134\1\136"+
    "\1\134\1\135\2\134\1\143\3\134\1\0\1\134\1\136"+
    "\1\134\105\0\11\144\1\0\27\144\1\145\43\144\12\0"+
    "\1\21\111\0\1\41\14\0\1\41\2\0\1\41\47\0"+
    "\2\140\1\0\1\140\46\0\2\140\27\0\1\12\1\146"+
    "\2\12\1\146\1\12\1\0\2\12\2\0\4\146\4\0"+
    "\1\12\2\0\1\147\1\0\1\12\15\0\6\146\2\12"+
    "\23\146\1\0\3\146\1\0\1\150\2\0\1\150\6\0"+
    "\4\150\7\0\1\147\5\0\1\41\11\0\6\150\2\0"+
    "\23\150\1\0\3\150\1\0\1\150\2\0\1\150\6\0"+
    "\4\150\7\0\1\147\17\0\6\150\2\0\23\150\1\0"+
    "\3\150\1\12\1\146\2\151\1\146\1\151\1\0\2\151"+
    "\2\0\4\146\4\152\1\151\2\152\1\153\1\0\1\151"+
    "\15\152\6\146\2\151\23\146\1\152\3\146\32\0\1\41"+
    "\1\0\1\41\103\0\1\154\1\41\104\0\1\41\11\0"+
    "\1\155\1\156\1\0\1\157\1\160\5\0\1\161\2\0"+
    "\1\162\4\0\1\163\50\0\1\41\104\0\1\41\10\0"+
    "\1\41\33\0\1\41\37\0\1\41\2\0\1\164\101\0"+
    "\1\41\6\0\1\41\1\0\1\41\33\0\1\41\3\0"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\165\3\13\1\166\3\13"+
    "\1\167\1\170\10\13\1\171\7\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\172\10\13\1\173\4\13\1\174\4\13"+
    "\1\175\7\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\176\2\13\1\177\5\13\1\200\2\13\1\201\5\13"+
    "\1\202\7\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\203\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\204\3\13\1\205\2\13\1\206\10\13\1\207\2\13"+
    "\1\210\1\211\1\176\1\212\3\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\213\1\13\1\214\1\215\2\13"+
    "\1\216\2\13\1\217\6\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\220\1\221\25\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\222\1\223\4\13\1\224\1\13"+
    "\1\225\16\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\226\17\13\1\227\1\176\10\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\230\4\13\1\231\1\232\20\13"+
    "\1\0\3\13\1\12\5\13\1\0\1\12\1\233\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\7\0\1\234\1\235"+
    "\2\0\1\236\1\0\5\13\1\237\11\13\1\225\5\13"+
    "\1\240\3\13\1\241\1\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\12\13\1\242\11\13\1\243\6\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\244\1\13\1\245\1\13"+
    "\1\246\3\13\1\247\2\13\1\250\7\13\1\251\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\252\5\13"+
    "\1\253\20\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\254\2\13\1\255\4\13\1\256\2\13\1\257\7\13"+
    "\1\260\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\261\2\13\1\262\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\13\1\263\10\13\1\264\3\13\1\265\5\13"+
    "\1\266\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\13\13"+
    "\1\267\1\270\1\13\1\271\2\13\1\272\3\13\1\200"+
    "\5\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\1\13\1\273"+
    "\2\13\1\274\1\275\4\13\1\276\3\13\1\271\6\13"+
    "\1\277\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\7\0\1\300"+
    "\1\301\2\0\1\302\1\0\1\303\1\304\1\13\1\305"+
    "\1\306\4\13\1\307\1\310\1\311\2\13\1\312\4\13"+
    "\1\313\1\314\1\13\1\315\2\13\1\316\1\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\23\13\1\317\7\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\13\1\320\31\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\3\13\1\321\1\13\1\322"+
    "\3\13\1\323\21\13\1\0\3\13\1\12\5\13\1\0"+
    "\1\12\1\324\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\7\0\1\325\1\326\2\0\1\327\1\0\33\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\13\1\330\31\13\1\0"+
    "\3\13\10\76\2\0\11\76\2\0\3\76\1\0\50\76"+
    "\1\0\3\76\11\331\1\0\73\331\1\0\1\332\2\0"+
    "\1\332\6\0\4\332\7\0\1\333\17\0\6\332\2\0"+
    "\23\332\1\0\3\332\1\0\1\332\2\334\1\332\1\334"+
    "\1\0\2\334\2\0\4\332\7\334\1\335\1\0\16\334"+
    "\6\332\2\334\23\332\1\334\3\332\10\104\2\0\33\104"+
    "\1\0\37\104\11\336\1\0\73\336\10\110\2\0\11\110"+
    "\2\0\3\110\2\0\53\110\1\0\1\337\2\0\1\337"+
    "\6\0\4\337\7\0\1\340\17\0\6\337\2\0\23\337"+
    "\1\0\3\337\1\0\1\337\2\341\1\337\1\341\1\0"+
    "\2\341\2\0\4\337\7\341\1\342\1\0\16\341\6\337"+
    "\2\341\23\337\1\341\3\337\10\115\2\0\11\115\2\0"+
    "\3\115\1\0\64\115\2\0\11\115\2\0\3\115\1\0"+
    "\51\115\1\343\2\115\1\0\1\344\2\0\1\344\6\0"+
    "\4\344\7\0\1\345\17\0\6\344\2\0\23\344\1\0"+
    "\3\344\1\0\1\344\2\346\1\344\1\346\1\0\2\346"+
    "\2\0\4\344\7\346\1\347\1\0\16\346\6\344\2\346"+
    "\23\344\1\346\3\344\10\122\2\0\103\122\2\0\70\122"+
    "\1\350\2\122\10\115\2\0\11\115\2\0\3\115\1\0"+
    "\51\115\1\351\2\115\10\122\2\0\70\122\1\352\2\122"+
    "\11\131\1\0\22\131\1\0\50\131\46\0\1\353\1\354"+
    "\1\0\1\355\1\356\5\0\1\357\2\0\1\360\1\361"+
    "\3\0\1\362\14\0\6\134\1\0\2\134\2\0\4\134"+
    "\4\0\1\134\4\0\1\134\15\0\33\134\1\0\5\134"+
    "\2\363\1\134\1\363\1\0\2\134\2\0\4\134\1\364"+
    "\3\0\1\134\4\0\1\134\1\0\1\364\13\0\6\134"+
    "\2\363\23\134\1\0\5\134\2\140\1\134\1\140\1\0"+
    "\2\134\2\0\2\134\1\136\1\137\4\0\1\134\4\0"+
    "\1\134\15\0\2\134\1\136\1\134\1\137\1\134\2\140"+
    "\12\134\1\136\10\134\1\0\1\134\1\136\3\134\2\141"+
    "\1\134\1\141\1\0\2\134\2\0\2\134\1\136\1\137"+
    "\1\0\1\140\2\0\1\134\4\0\1\134\15\0\2\134"+
    "\1\136\1\134\1\137\1\134\2\141\12\134\1\136\10\134"+
    "\1\0\1\134\1\136\3\134\1\141\1\142\1\134\1\142"+
    "\1\0\2\134\2\0\1\134\1\365\1\136\1\137\1\0"+
    "\1\140\2\0\1\134\4\0\1\134\15\0\2\134\1\136"+
    "\1\134\1\137\1\134\2\142\12\134\1\136\1\134\1\365"+
    "\6\134\1\0\1\134\1\136\3\134\4\366\1\0\2\134"+
    "\2\0\2\134\2\366\4\0\1\134\4\0\1\134\15\0"+
    "\2\134\1\366\1\134\4\366\5\134\2\366\3\134\1\366"+
    "\10\134\1\0\1\134\1\366\1\134\11\144\1\0\73\144"+
    "\11\145\1\0\73\145\1\12\5\146\1\0\2\12\2\0"+
    "\4\146\4\0\1\12\4\0\1\12\15\0\33\146\1\0"+
    "\3\146\1\0\1\367\2\0\1\367\6\0\4\367\27\0"+
    "\6\367\2\0\23\367\1\0\3\367\1\0\5\150\5\0"+
    "\4\150\27\0\33\150\1\0\3\150\1\0\1\367\2\0"+
    "\1\367\2\0\2\152\2\0\4\367\7\152\1\0\17\152"+
    "\6\367\2\0\23\367\1\152\3\367\12\0\1\370\3\0"+
    "\1\371\12\0\1\372\2\0\1\41\10\0\1\373\33\0"+
    "\1\374\52\0\1\375\113\0\1\376\100\0\1\377\121\0"+
    "\1\u0100\76\0\1\u0101\75\0\1\u0102\1\u0103\100\0\1\u0104"+
    "\71\0\1\41\2\0\1\36\45\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\241\24\13\1\241\5\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\16\13\1\u0105\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\13\1\u0106\10\13\1\u0107\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\200\32\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\25\13\1\u0108\5\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\u0109\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\2\13\1\241\30\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\241\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\241\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\22\13\1\u010a\1\13\1\u010b\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\4\13\1\241\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\14\13\1\u010c\16\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\14\13\1\237\16\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\27\13\1\241\3\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\22\13\1\241\10\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\16\13\1\u0108\14\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\5\13\1\u010d\25\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\2\13\1\u010e\30\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\25\13\1\u010f\5\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\5\13\1\u0110\25\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\241\3\13\1\220\5\13"+
    "\1\u0111\20\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\5\13"+
    "\1\u0112\25\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\25\13"+
    "\1\241\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\16\13"+
    "\1\u0113\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\2\13"+
    "\1\176\30\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\5\13"+
    "\1\u0114\25\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\16\13"+
    "\1\241\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\24\13"+
    "\1\u0115\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\2\13"+
    "\1\u0116\2\13\1\u0117\2\13\1\u0118\2\13\1\u0119\2\13"+
    "\1\u011a\2\13\1\u011b\1\241\2\13\1\u011c\1\u011d\1\13"+
    "\1\u011e\2\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u011f\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u0120\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\2\13"+
    "\1\u0121\30\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\16\13"+
    "\1\u0122\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\2\13"+
    "\1\47\10\13\1\241\17\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\24\13\1\u0123\6\13\1\0\3\13\1\12\5\13"+
    "\1\0\1\12\1\324\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\7\0\1\325\1\326\2\0\1\327\1\0\23\13"+
    "\1\u0124\7\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u0125\7\13\1\u0126\16\13\1\0\3\13\6\233\1\u0127"+
    "\1\233\1\u0128\2\u0127\4\233\4\u0127\1\233\4\u0127\1\233"+
    "\15\u0127\33\233\1\u0127\3\233\40\234\1\u0129\44\234\41\235"+
    "\1\u0129\43\235\44\236\1\u0129\40\236\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\241\32\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\20\13"+
    "\1\u012a\12\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u012b\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u012c\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u012d\3\13\1\241\5\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\13\1\u012e\1\u0121\6\13\1\u012f\2\13\1\u0130"+
    "\16\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\24\13\1\u0131"+
    "\6\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\31\13\1\u0132"+
    "\1\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\1\176\32\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\13\1\u0133\31\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\31\13\1\214\1\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\24\13\1\u010d\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\u0134\17\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\u0135\17\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\237\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\267\17\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\13\1\u0136\31\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\176\17\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\27\13\1\u0137\3\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\11\13\1\u0138\21\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\24\13\1\u0139\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\21\13\1\u0122\11\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\13\1\u013a\31\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\12\13\1\u013b\20\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\5\13\1\u013c\25\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\22\13\1\u013d\10\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\u013e\1\13\1\u013f"+
    "\10\13\1\u0140\10\13\1\u0141\1\u0142\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\16\13\1\u0143\1\13\1\241\12\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\21\13\1\u0144\11\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\25\13\1\u0137\5\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\21\13\1\u0145\3\13"+
    "\1\u0146\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\13\13"+
    "\1\u0147\17\13\1\0\3\13\40\300\1\u0148\44\300\41\301"+
    "\1\u0149\43\301\44\302\1\u014a\40\302\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\11\13\1\u014b\12\13\1\u014c\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\174\4\13\1\u014d\14\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\12\13\1\u014e\1\13\1\u014f"+
    "\6\13\1\u0150\7\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\4\13\1\u0151\6\13\1\u0152\1\u0153\4\13\1\u011f\2\13"+
    "\1\u0154\6\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\5\13"+
    "\1\223\25\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\241\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\5\13"+
    "\1\174\15\13\1\u0155\7\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\5\13\1\u0156\25\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\15\13\1\u0157\15\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\256\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\11\13\1\174\21\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\14\13\1\u0158\10\13\1\u0159\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\u015a\31\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\11\13\1\176\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\12\13\1\u015b\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\11\13\1\310\1\u015c\6\13\1\u015d"+
    "\11\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\12\13\1\u015e"+
    "\20\13\1\0\3\13\6\324\1\u015f\1\324\1\u0160\2\u015f"+
    "\4\324\4\u015f\1\324\4\u015f\1\324\15\u015f\33\324\1\u015f"+
    "\3\324\40\325\1\u0161\44\325\41\326\1\u0162\43\326\44\327"+
    "\1\u0163\40\327\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\12\13\1\310\20\13"+
    "\1\0\3\13\1\0\5\332\5\0\4\332\27\0\33\332"+
    "\1\0\3\332\1\0\1\u0164\2\0\1\u0164\6\0\4\u0164"+
    "\27\0\6\u0164\2\0\23\u0164\1\0\3\u0164\1\0\1\u0164"+
    "\2\0\1\u0164\2\0\2\334\2\0\4\u0164\7\334\1\0"+
    "\17\334\6\u0164\2\0\23\u0164\1\334\3\u0164\1\0\5\337"+
    "\5\0\4\337\27\0\33\337\1\0\3\337\1\0\1\u0165"+
    "\2\0\1\u0165\6\0\4\u0165\27\0\6\u0165\2\0\23\u0165"+
    "\1\0\3\u0165\1\0\1\u0165\2\0\1\u0165\2\0\2\341"+
    "\2\0\4\u0165\7\341\1\0\17\341\6\u0165\2\0\23\u0165"+
    "\1\341\3\u0165\10\115\2\0\11\115\2\0\3\115\1\0"+
    "\52\115\1\u0166\1\115\1\0\5\344\5\0\4\344\27\0"+
    "\33\344\1\0\3\344\1\0\1\u0167\2\0\1\u0167\6\0"+
    "\4\u0167\27\0\6\u0167\2\0\23\u0167\1\0\3\u0167\1\0"+
    "\1\u0167\2\0\1\u0167\2\0\2\346\2\0\4\u0167\7\346"+
    "\1\0\17\346\6\u0167\2\0\23\u0167\1\346\3\u0167\10\122"+
    "\2\0\71\122\1\u0168\1\122\10\115\2\0\11\115\2\0"+
    "\3\115\1\0\53\115\1\u0166\10\122\2\0\72\122\1\u0168"+
    "\47\0\1\u0169\113\0\1\u016a\100\0\1\u016b\121\0\1\u016c"+
    "\76\0\1\u016d\75\0\1\u016e\1\u016f\122\0\1\u0170\62\0"+
    "\1\u0171\35\0\2\134\2\363\1\134\1\363\1\0\2\134"+
    "\2\0\2\134\1\136\1\134\4\0\1\134\4\0\1\134"+
    "\15\0\2\134\1\136\3\134\2\363\12\134\1\136\10\134"+
    "\1\0\1\134\1\136\1\134\2\0\2\363\1\0\1\363"+
    "\46\0\2\363\27\0\2\134\4\366\1\0\2\134\2\0"+
    "\1\134\1\365\2\366\4\0\1\134\4\0\1\134\15\0"+
    "\2\134\1\366\1\134\4\366\5\134\2\366\3\134\1\366"+
    "\1\134\1\365\6\134\1\0\1\134\1\366\1\134\1\0"+
    "\5\367\5\0\4\367\10\0\1\152\16\0\33\367\1\0"+
    "\3\367\12\0\1\370\16\0\1\372\13\0\1\373\33\0"+
    "\1\374\105\0\1\u0172\20\0\1\u0173\104\0\1\u0174\104\0"+
    "\1\u0175\136\0\1\u0176\106\0\1\u0104\105\0\1\u0177\101\0"+
    "\1\u0176\13\0\1\u0178\72\0\1\u0179\120\0\1\u017a\102\0"+
    "\1\u017b\77\0\1\u0176\25\0\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\17\13"+
    "\1\u017c\13\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\13\13"+
    "\1\u017d\17\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u017e\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\3\13"+
    "\1\241\27\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\21\13"+
    "\1\u017f\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\12\13"+
    "\1\u0180\20\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u015e\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\u0181\14\13\1\u0182\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\24\13\1\241\6\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\u0183\2\13\1\u0184\14\13\1\u0185\1\u0186\3\13"+
    "\1\u0187\5\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\176\5\13\1\u0188\20\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\16\13\1\176\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\13\13\1\241\11\13\1\u0189\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\21\13\1\u018a\11\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\u0132\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\11\13\1\u018b\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\23\13\1\u018c\7\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\176\31\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\2\13\1\u018d\30\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\u018e\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\23\13\1\u018f\7\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\10\13\1\241\22\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\5\13\1\u013b\25\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\174\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\23\13\1\u0190\7\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\12\13\1\u0191\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\2\13\1\47\30\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\12\13\1\175\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\13\13\1\u010d\17\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\24\13\1\u017f\6\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\21\13\1\u0192\11\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\u0193\26\13\1\0\3\13"+
    "\10\u0127\1\u0194\74\u0127\6\12\1\0\2\12\2\0\4\12"+
    "\4\0\1\12\4\0\1\12\15\0\1\12\1\u0128\10\12"+
    "\1\u0128\1\12\1\u0128\1\12\1\u0128\1\12\1\u0128\4\12"+
    "\1\u0128\1\12\1\u0128\3\12\1\0\3\12\46\0\2\u0129"+
    "\10\0\1\u0129\1\0\1\u0129\1\0\1\u0129\1\0\1\u0129"+
    "\4\0\1\u0129\1\0\1\u0129\7\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\11\13\1\u0195\4\13\1\u0122\1\13\1\u011c\4\13\1\223"+
    "\5\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\2\13\1\241"+
    "\11\13\1\u0196\16\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\25\13\1\214\5\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\13\13\1\u0197\5\13\1\u0154\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\241\13\13\1\237\13\13\1\310\2\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\13\1\u0198\31\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\13\1\u011f\31\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\24\13\1\u0199\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\174\32\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\25\13\1\u019a\5\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\13\1\241\31\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\u019b\2\13\1\u019c\12\13"+
    "\1\241\1\13\1\u019d\1\u019e\2\13\1\u019f\1\u01a0\5\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\15\13\1\241\15\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\u01a1\7\13"+
    "\1\u01a2\2\13\1\241\13\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\u01a3\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\16\13\1\u0145\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\14\13\1\200\16\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\25\13\1\u0145\5\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\12\13\1\u01a4\20\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\5\13\1\u013a\25\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\204\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\12\13\1\u01a5\20\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\u01a6\5\13\1\u01a7\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\3\13\1\u01a8\27\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\5\13\1\u01a9\25\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\20\13\1\u01aa\12\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\17\13\1\241\13\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\13\13\1\u01ab\17\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\5\13\1\174\25\13\1\0\3\13"+
    "\40\u0148\1\u01ac\44\u0148\41\u0149\1\u01ac\43\u0149\44\u014a\1\u01ac"+
    "\40\u014a\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\12\13\1\u01ad\20\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\12\13\1\u01ae\20\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\17\13\1\u01af\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\22\13\1\174\10\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\11\13\1\u01b0\4\13\1\u0122"+
    "\1\13\1\u011c\7\13\1\u01b1\2\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u01b2\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\17\13\1\u017f\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\u01b3\2\13\1\u0184\14\13\1\u0185\1\u0186"+
    "\3\13\1\u01b4\5\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\13\1\237\14\13\1\u0122\1\13\1\u011c\12\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\4\13\1\u01b5\26\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\2\13\1\u01b6\30\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\24\13\1\u01b7\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\25\13\1\u01b8\5\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\24\13\1\u01b9\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\13\1\u0181\7\13\1\u01b0"+
    "\1\13\1\u01ba\2\13\1\u01bb\6\13\1\u01bc\2\13\1\u01b1"+
    "\2\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\u01bd"+
    "\17\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\24\13\1\u01be"+
    "\6\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\u01bf"+
    "\17\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\u01c0"+
    "\17\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\200"+
    "\17\13\1\0\3\13\10\u015f\1\u01c1\74\u015f\6\u0160\1\u01c1"+
    "\1\u0160\1\u01c2\2\u01c1\4\u0160\4\u01c1\1\u0160\4\u01c1\1\u0160"+
    "\15\u01c1\33\u0160\1\u01c1\3\u0160\40\u0161\1\u01c3\44\u0161\41\u0162"+
    "\1\u01c3\43\u0162\44\u0163\1\u01c3\40\u0163\1\0\5\u0164\5\0"+
    "\4\u0164\10\0\1\334\16\0\33\u0164\1\0\3\u0164\1\0"+
    "\5\u0165\5\0\4\u0165\10\0\1\341\16\0\33\u0165\1\0"+
    "\3\u0165\1\0\5\u0167\5\0\4\u0167\10\0\1\346\16\0"+
    "\33\u0167\1\0\3\u0167\50\0\1\u01c4\106\0\1\u0171\105\0"+
    "\1\u01c5\101\0\1\u01c4\13\0\1\u01c6\72\0\1\u01c7\120\0"+
    "\1\u01c8\102\0\1\u01c9\101\0\1\u01ca\102\0\1\u01c4\130\0"+
    "\1\u01cb\1\u01cc\102\0\1\u01cd\104\0\1\u01ce\104\0\1\u01cf"+
    "\52\0\1\u01d0\103\0\1\u01d1\117\0\1\u0176\102\0\1\u01d2"+
    "\111\0\1\u0176\17\0\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\5\13\1\u01d3"+
    "\25\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\1\13\1\u01d4"+
    "\31\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\u01d5"+
    "\17\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\21\13\1\u01d6"+
    "\11\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\1\u01ab\32\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\24\13\1\u01d7\6\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\11\13\1\u01d8\16\13"+
    "\1\u01d9\2\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\13"+
    "\1\u01da\31\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\11\13"+
    "\1\u01d9\21\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u01db\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u01dc\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\22\13"+
    "\1\176\10\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\13\13"+
    "\1\214\17\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\7\13"+
    "\1\241\23\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\14\13"+
    "\1\241\16\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\214\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\1\u01dd"+
    "\1\13\1\u0121\21\13\1\u01de\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\u01df\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\310\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\12\13\1\u01e0\20\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\u01e1\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\16\13\1\u01e2\14\13\1\0\3\13\47\0"+
    "\1\u0194\10\0\1\u0194\1\0\1\u0194\1\0\1\u0194\1\0"+
    "\1\u0194\4\0\1\u0194\1\0\1\u0194\7\0\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\16\13\1\u011a\14\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\13\1\u01e3\31\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\12\13\1\u01e4\20\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\13\1\174\31\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\175\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\4\13\1\u017f\26\13\1\0\3\13\1\12\5\13"+
    "\1\0\2\12\2\0\4\13\4\0\1\12\4\0\1\12"+
    "\15\0\1\u01e5\3\13\1\u01e6\4\13\1\u01e7\6\13\1\u01e8"+
    "\7\13\1\u01e9\2\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\13\1\u01ea\31\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\11\13\1\u01eb\21\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\4\13\1\u01ec\26\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\13\1\u01ed\31\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\13\1\u01ee\2\13\1\u01ef\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\5\13\1\u01f0\25\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\24\13\1\u01f1\6\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\u0134\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\u01f2\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\241\17\13\1\176\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\25\13\1\u01f3\5\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\21\13\1\u0145\11\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\12\13\1\u014e\20\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\24\13\1\u01f4\6\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\13\13\1\u0108\17\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\4\13\1\310\26\13\1\0"+
    "\3\13\46\0\2\u01ac\2\0\1\u01ac\5\0\1\u01ac\1\0"+
    "\1\u01ac\1\0\1\u01ac\1\0\1\u01ac\4\0\1\u01ac\1\0"+
    "\1\u01ac\7\0\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\21\13\1\u01f5\11\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\241\2\13"+
    "\1\200\14\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u01f6\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\4\13"+
    "\1\u01f7\26\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\11\13"+
    "\1\323\21\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\2\13"+
    "\1\u01f8\30\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\11\13"+
    "\1\u01f9\6\13\1\u01e8\7\13\1\u01d9\2\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\u01fa\2\13\1\u01dc\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\16\13\1\174\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\31\13\1\241\1\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\5\13\1\175\25\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\13\13\1\175\17\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\12\13\1\u01a7\20\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\u018b\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\5\13\1\253\25\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\u01fb\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\u01fc\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\176\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\1\u01e5\32\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\5\13\1\u01fd\25\13\1\0"+
    "\3\13\10\u01c1\1\u01c3\74\u01c1\6\12\1\0\2\12\2\0"+
    "\4\12\4\0\1\12\4\0\1\12\15\0\2\12\1\u01c2"+
    "\13\12\1\u01c2\6\12\1\u01c2\5\12\1\0\3\12\50\0"+
    "\1\u01c3\13\0\1\u01c3\6\0\1\u01c3\61\0\1\u01fe\103\0"+
    "\1\u01ff\117\0\1\u01c4\102\0\1\u0200\111\0\1\u01c4\122\0"+
    "\1\u0201\1\u0202\103\0\1\u0203\1\u0204\103\0\1\u0205\1\u0206"+
    "\54\0\2\u0176\77\0\1\u0207\123\0\1\u0176\15\0\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\20\13\1\200\12\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u0208\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\u011f\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u01df\31\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u0209\31\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\u020a\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\25\13\1\u01db\5\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u01d9\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\u020b\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\12\13\1\170\20\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\12\13\1\u020c\20\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\25\13\1\200\5\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\200\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\2\13\1\225\30\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\5\13\1\u015e\25\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\2\13\1\200\30\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\u020d\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\12\13\1\u011f\20\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\u020e\26\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u020f\10\13\1\u0210\20\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\11\13\1\237\21\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\4\13\1\u020a\14\13\1\u0211"+
    "\1\13\1\u01e5\7\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\25\13\1\u01ec\5\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\4\13\1\u020a\13\13\1\u01e5\1\u0211\11\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\13\13\1\u0212\17\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\20\13\1\330\12\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\16\13\1\u0213\14\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\11\13\1\u0214\21\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\16\13\1\u0215\14\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\12\13\1\u0216\20\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\25\13\1\174\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\25\13\1\176\5\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\13\13\1\204\17\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\13\13\1\u0217\17\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\5\13\1\u011f\25\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\u0218\31\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\u0209\10\13\1\u0210\20\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\16\13\1\u0219\14\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\4\13\1\u0145\26\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\14\13\1\u021a\16\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\11\13\1\u021b\21\13"+
    "\1\0\3\13\54\0\2\u01c4\77\0\1\u021c\123\0\1\u01c4"+
    "\46\0\1\u01cb\104\0\1\u01cc\120\0\1\u021d\104\0\1\u021e"+
    "\140\0\1\u01cb\104\0\1\u01cc\63\0\1\u021f\24\0\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\31\13\1\170\1\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u0220\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\174\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\10\13\1\u01d9\22\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\u0221\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\23\13\1\u01be\7\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\u0222\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u0223\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u0224\31\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\5\13\1\u018b\25\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\4\13\1\u020a\10\13\1\u0225\15\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\17\13\1\u0226\13\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\10\13\1\u0227\22\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\3\13\1\176\27\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\21\13\1\200\11\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\1\u0228\32\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\30\13\1\310\2\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\17\13\1\u0229\13\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\u022a\26\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\11\13\1\u022b\21\13\1\0\3\13"+
    "\60\0\1\u022c\113\0\1\u022d\15\0\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\1\13\1\u01d9\31\13\1\0\3\13\1\12\5\13\1\0"+
    "\2\12\2\0\4\13\4\0\1\12\4\0\1\12\15\0"+
    "\4\13\1\241\12\13\1\241\13\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\21\13\1\u011b\11\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u022e\31\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\11\13\1\u022f\21\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\31\13\1\u0230\1\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\13\1\u0132\17\13\1\u011b\11\13\1\0"+
    "\3\13\1\12\5\13\1\0\2\12\2\0\4\13\4\0"+
    "\1\12\4\0\1\12\15\0\4\13\1\u020a\10\13\1\u0231"+
    "\15\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\5\13\1\u0121"+
    "\25\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\1\13\1\u0132"+
    "\31\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\13\13\1\u0232"+
    "\17\13\1\0\3\13\1\12\5\13\1\0\2\12\2\0"+
    "\4\13\4\0\1\12\4\0\1\12\15\0\5\13\1\u01b6"+
    "\25\13\1\0\3\13\67\0\1\u0233\103\0\1\u0176\16\0"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\4\13\1\u020a\10\13\1\u0234\15\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\12\13\1\u0235\20\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\5\13\1\u0236\13\13"+
    "\1\u011b\11\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\31\13"+
    "\1\u0237\1\13\1\0\3\13\1\12\5\13\1\0\2\12"+
    "\2\0\4\13\4\0\1\12\4\0\1\12\15\0\5\13"+
    "\1\241\25\13\1\0\3\13\66\0\1\u01c4\16\0\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\31\13\1\u0238\1\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\13\13\1\u01b6\17\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\2\13\1\u0239\30\13\1\0\3\13\1\12"+
    "\5\13\1\0\2\12\2\0\4\13\4\0\1\12\4\0"+
    "\1\12\15\0\1\u023a\20\13\1\u011b\11\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\21\13\1\u023b\11\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\2\13\1\175\30\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\1\13\1\315\31\13\1\0\3\13"+
    "\1\12\5\13\1\0\2\12\2\0\4\13\4\0\1\12"+
    "\4\0\1\12\15\0\5\13\1\u013b\15\13\1\u023c\7\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\14\13\1\u023d\16\13"+
    "\1\0\3\13\1\12\5\13\1\0\2\12\2\0\4\13"+
    "\4\0\1\12\4\0\1\12\15\0\15\13\1\u0199\15\13"+
    "\1\0\3\13";

  private static int [] zzUnpackTrans() {
    int [] result = new int[36363];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\11\0\4\1\1\11\1\1\1\11\3\1\2\11\4\1"+
    "\1\11\6\1\1\11\1\1\1\11\31\1\1\11\2\1"+
    "\1\11\2\1\1\11\2\1\2\11\1\1\1\11\2\1"+
    "\1\11\1\1\1\11\4\1\1\11\1\1\1\11\1\1"+
    "\1\11\2\1\1\11\14\1\1\0\2\1\1\11\11\0"+
    "\50\1\3\0\41\1\3\0\22\1\3\0\1\1\1\11"+
    "\1\1\1\0\1\11\1\0\1\11\1\1\1\0\1\11"+
    "\1\0\2\1\1\0\1\11\1\0\3\1\10\0\1\1"+
    "\1\0\2\1\16\0\42\1\1\0\40\1\3\0\24\1"+
    "\1\0\1\1\5\0\1\1\1\0\1\1\15\0\1\11"+
    "\5\0\105\1\1\0\2\1\1\11\5\0\3\11\6\0"+
    "\53\1\12\0\24\1\1\0\2\11\1\0\14\1\2\0"+
    "\5\1\1\0\12\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[573];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_UNQUOTED			= -1;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an single quoted EOF heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOF_SINGLE_QUOTED		= -2;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an unquoted/double quoted/backtick EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_UNQUOTED			= -3;

	/**
	 * Token type specific to PerlTokenMaker; this signals that we are inside
	 * an single quoted EOT heredoc.
	 */
	public static final int INTERNAL_HEREDOC_EOT_SINGLE_QUOTED		= -4;

	/**
	 * Token type specific to PerlTokenMaker; this signals we are in a POD
	 * block.
	 */
	public static final int INTERNAL_POD						= -5;

	/**
	 * Constructor.  This must be here because JFlex does not generate a
	 * no-parameter constructor.
	 */
	public PerlTokenMaker() {
	}


	/**
	 * Adds the token specified to the current linked list of tokens as an
	 * "end token;" that is, at <code>zzMarkedPos</code>.
	 *
	 * @param tokenType The token's type.
	 */
	private void addEndToken(int tokenType) {
		addToken(zzMarkedPos,zzMarkedPos, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int tokenType) {
		addToken(zzStartRead, zzMarkedPos-1, tokenType);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param tokenType The token's type.
	 */
	private void addToken(int start, int end, int tokenType) {
		int so = start + offsetShift;
		addToken(zzBuffer, start,end, tokenType, so);
	}


	/**
	 * Adds the token specified to the current linked list of tokens.
	 *
	 * @param array The character array.
	 * @param start The starting offset in the array.
	 * @param end The ending offset in the array.
	 * @param tokenType The token's type.
	 * @param startOffset The offset in the document at which this token
	 *                    occurs.
	 */
	public void addToken(char[] array, int start, int end, int tokenType, int startOffset) {
		super.addToken(array, start,end, tokenType, startOffset);
		zzStartRead = zzMarkedPos;
	}


	/**
	 * Returns the text to place at the beginning and end of a
	 * line to "comment" it in a this programming language.
	 *
	 * @return The start and end strings to add to a line to "comment"
	 *         it out.
	 */
	public String[] getLineCommentStartAndEnd() {
		return new String[] { "#", null };
	}


	/**
	 * Returns whether tokens of the specified type should have "mark
	 * occurrences" enabled for the current programming language.
	 *
	 * @param type The token type.
	 * @return Whether tokens of this type should have "mark occurrences"
	 *         enabled.
	 */
	public boolean getMarkOccurrencesOfTokenType(int type) {
		return type==Token.IDENTIFIER || type==Token.VARIABLE;
	}


	/**
	 * Returns the first token in the linked list of tokens generated
	 * from <code>text</code>.  This method must be implemented by
	 * subclasses so they can correctly implement syntax highlighting.
	 *
	 * @param text The text from which to get tokens.
	 * @param initialTokenType The token type we should start with.
	 * @param startOffset The offset into the document at which
	 *        <code>text</code> starts.
	 * @return The first <code>Token</code> in a linked list representing
	 *         the syntax highlighted text.
	 */
	public Token getTokenList(Segment text, int initialTokenType, int startOffset) {

		resetTokenList();
		this.offsetShift = -text.offset + startOffset;

		// Start off in the proper state.
		int state = Token.NULL;
		switch (initialTokenType) {
			case Token.LITERAL_STRING_DOUBLE_QUOTE:
				state = STRING;
				start = text.offset;
				break;
			case Token.LITERAL_CHAR:
				state = CHAR_LITERAL;
				start = text.offset;
				break;
			case Token.LITERAL_BACKQUOTE:
				state = BACKTICKS;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_UNQUOTED:
				state = HEREDOC_EOF_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOF_SINGLE_QUOTED:
				state = HEREDOC_EOF_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_UNQUOTED:
				state = HEREDOC_EOT_UNQUOTED;
				start = text.offset;
				break;
			case INTERNAL_HEREDOC_EOT_SINGLE_QUOTED:
				state = HEREDOC_EOT_SINGLE_QUOTED;
				start = text.offset;
				break;
			case INTERNAL_POD:
				state = POD;
				start = text.offset;
				break;
			default:
				state = Token.NULL;
		}

		s = text;
		try {
			yyreset(zzReader);
			yybegin(state);
			return yylex();
		} catch (IOException ioe) {
			ioe.printStackTrace();
			return new DefaultToken();
		}

	}


	/**
	 * Refills the input buffer.
	 *
	 * @return      <code>true</code> if EOF was reached, otherwise
	 *              <code>false</code>.
	 * @exception   IOException  if any I/O-Error occurs.
	 */
	private boolean zzRefill() throws java.io.IOException {
		return zzCurrentPos>=s.offset+s.count;
	}


	/**
	 * Resets the scanner to read from a new input stream.
	 * Does not close the old reader.
	 *
	 * All internal variables are reset, the old input stream 
	 * <b>cannot</b> be reused (internal buffer is discarded and lost).
	 * Lexical state is set to <tt>YY_INITIAL</tt>.
	 *
	 * @param reader   the new input stream 
	 */
	public final void yyreset(java.io.Reader reader) throws java.io.IOException {
		// 's' has been updated.
		zzBuffer = s.array;
		/*
		 * We replaced the line below with the two below it because zzRefill
		 * no longer "refills" the buffer (since the way we do it, it's always
		 * "full" the first time through, since it points to the segment's
		 * array).  So, we assign zzEndRead here.
		 */
		//zzStartRead = zzEndRead = s.offset;
		zzStartRead = s.offset;
		zzEndRead = zzStartRead + s.count - 1;
		zzCurrentPos = zzMarkedPos = s.offset;
		zzLexicalState = YYINITIAL;
		zzReader = reader;
		zzAtEOF  = false;
	}




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PerlTokenMaker(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PerlTokenMaker(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 174) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public org.fife.ui.rsyntaxtextarea.Token yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 2: 
          { addToken(Token.IDENTIFIER);
          }
        case 44: break;
        case 34: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 45: break;
        case 39: 
          { if (start==zzStartRead) { addToken(Token.COMMENT_DOCUMENTATION); yybegin(YYINITIAL); }
          }
        case 46: break;
        case 26: 
          { addToken(Token.ERROR_NUMBER_FORMAT);
          }
        case 47: break;
        case 11: 
          { start = zzMarkedPos-1; yybegin(STRING);
          }
        case 48: break;
        case 36: 
          { if (start==zzStartRead) { addToken(Token.PREPROCESSOR); addNullToken(); return firstToken; }
          }
        case 49: break;
        case 32: 
          { addToken(Token.FUNCTION);
          }
        case 50: break;
        case 30: 
          { addToken(Token.VARIABLE);
          }
        case 51: break;
        case 1: 
          { addToken(Token.ERROR_IDENTIFIER);
          }
        case 52: break;
        case 24: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
          }
        case 53: break;
        case 4: 
          { addToken(Token.COMMENT_EOL); addNullToken(); return firstToken;
          }
        case 54: break;
        case 29: 
          { addToken(Token.PREPROCESSOR); addNullToken(); return firstToken;
          }
        case 55: break;
        case 38: 
          { if (start==zzStartRead) { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addToken(temp,zzMarkedPos-1, Token.COMMENT_EOL); start = zzMarkedPos; }
          }
        case 56: break;
        case 42: 
          { start = zzStartRead; yybegin(HEREDOC_EOF_SINGLE_QUOTED);
          }
        case 57: break;
        case 43: 
          { start = zzStartRead; yybegin(HEREDOC_EOT_SINGLE_QUOTED);
          }
        case 58: break;
        case 40: 
          { start = zzStartRead; yybegin(HEREDOC_EOF_UNQUOTED);
          }
        case 59: break;
        case 13: 
          { /* Skip escaped chars. */
          }
        case 60: break;
        case 18: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_CHAR);
          }
        case 61: break;
        case 28: 
          { addToken(Token.LITERAL_NUMBER_HEXADECIMAL);
          }
        case 62: break;
        case 21: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
          }
        case 63: break;
        case 6: 
          { addToken(Token.WHITESPACE);
          }
        case 64: break;
        case 10: 
          { start = zzMarkedPos-1; yybegin(CHAR_LITERAL);
          }
        case 65: break;
        case 3: 
          { addToken(Token.LITERAL_NUMBER_DECIMAL_INT);
          }
        case 66: break;
        case 33: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 67: break;
        case 20: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_BACKQUOTE);
          }
        case 68: break;
        case 15: 
          { yybegin(YYINITIAL); addToken(start,zzStartRead, Token.LITERAL_STRING_DOUBLE_QUOTE);
          }
        case 69: break;
        case 16: 
          { /* Skip escaped single quotes only, but this should still work. */
          }
        case 70: break;
        case 23: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
          }
        case 71: break;
        case 35: 
          { int temp=zzStartRead; addToken(start,zzStartRead-1, Token.PREPROCESSOR); addToken(temp,zzMarkedPos-1, Token.VARIABLE); start = zzMarkedPos;
          }
        case 72: break;
        case 37: 
          { addToken(Token.COMMENT_EOL); start = zzMarkedPos; yybegin(POD);
          }
        case 73: break;
        case 31: 
          { addToken(Token.RESERVED_WORD);
          }
        case 74: break;
        case 19: 
          { addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
          }
        case 75: break;
        case 8: 
          { addToken(Token.SEPARATOR);
          }
        case 76: break;
        case 5: 
          { addNullToken(); return firstToken;
          }
        case 77: break;
        case 7: 
          { addToken(Token.OPERATOR);
          }
        case 78: break;
        case 17: 
          { addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
          }
        case 79: break;
        case 25: 
          { addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_POD); return firstToken;
          }
        case 80: break;
        case 27: 
          { addToken(Token.LITERAL_NUMBER_FLOAT);
          }
        case 81: break;
        case 41: 
          { start = zzStartRead; yybegin(HEREDOC_EOT_UNQUOTED);
          }
        case 82: break;
        case 9: 
          { start = zzMarkedPos-1; yybegin(BACKTICKS);
          }
        case 83: break;
        case 12: 
          { 
          }
        case 84: break;
        case 14: 
          { addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
          }
        case 85: break;
        case 22: 
          { addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
          }
        case 86: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            switch (zzLexicalState) {
            case HEREDOC_EOF_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_SINGLE_QUOTED); return firstToken;
            }
            case 574: break;
            case HEREDOC_EOT_SINGLE_QUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_SINGLE_QUOTED); return firstToken;
            }
            case 575: break;
            case HEREDOC_EOT_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOT_UNQUOTED); return firstToken;
            }
            case 576: break;
            case STRING: {
              addToken(start,zzStartRead-1, Token.LITERAL_STRING_DOUBLE_QUOTE); return firstToken;
            }
            case 577: break;
            case BACKTICKS: {
              addToken(start,zzStartRead-1, Token.LITERAL_BACKQUOTE); return firstToken;
            }
            case 578: break;
            case YYINITIAL: {
              addNullToken(); return firstToken;
            }
            case 579: break;
            case HEREDOC_EOF_UNQUOTED: {
              addToken(start,zzStartRead-1, Token.PREPROCESSOR); addEndToken(INTERNAL_HEREDOC_EOF_UNQUOTED); return firstToken;
            }
            case 580: break;
            case CHAR_LITERAL: {
              addToken(start,zzStartRead-1, Token.LITERAL_CHAR); return firstToken;
            }
            case 581: break;
            case POD: {
              addToken(start,zzStartRead-1, Token.COMMENT_DOCUMENTATION); addEndToken(INTERNAL_POD); return firstToken;
            }
            case 582: break;
            default:
            return null;
            }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
