### WARNING: This file is auto-generated by the asana-api-meta repo. Do not
### edit it manually.

module Asana
  module Resources
    # Custom Fields store the metadata that is used in order to add user-specified
    # information to tasks in Asana. Be sure to reference the [Custom
    # Fields](/developers/documentation/getting-started/custom-fields) developer
    # documentation for more information about how custom fields relate to various
    # resources in Asana.
    class CustomField < Resource


      attr_reader :id

      attr_reader :created_at

      attr_reader :name

      attr_reader :type

      attr_reader :enum_options

      attr_reader :precision

      class << self
        # Returns the plural name of the resource.
        def plural_name
          'custom_fields'
        end

        # Returns the complete definition of a custom field's metadata.
        #
        # id - [Id] Globally unique identifier for the custom field.
        #
        # options - [Hash] the request I/O options.
        def find_by_id(client, id, options: {})

          self.new(parse(client.get("/custom_fields/#{id}", options: options)).first, client: client)
        end

        # Returns a list of the compact representation of all of the custom fields in a workspace.
        #
        # workspace - [Id] The workspace or organization to find custom field definitions in.
        # options - [Hash] the request I/O options.
        def find_by_workspace(client, workspace: required("workspace"), options: {})

          Resource.new(parse(client.get("/workspaces/#{workspace}/custom_fields", options: options)).first, client: client)
        end
      end

    end
  end
end