# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Insights
  module Models
    #
    # The parameters for the scaling action.
    #
    class ScaleAction

      include MsRestAzure

      # @return [ScaleDirection] the scale direction. Whether the scaling
      # action increases or decreases the number of instances. Possible values
      # include: 'None', 'Increase', 'Decrease'
      attr_accessor :direction

      # @return [String] the type of action that should occur, this must be set
      # to ChangeCount. Default value: 'ChangeCount' .
      attr_accessor :type

      # @return [String] the number of instances that are involved in the
      # scaling action. This value must be 1 or greater. The default value is
      # 1. Default value: '1' .
      attr_accessor :value

      # @return [Duration] the amount of time to wait since the last scaling
      # action before this action occurs. It must be between 1 week and 1
      # minute.
      attr_accessor :cooldown


      #
      # Mapper for ScaleAction class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ScaleAction',
          type: {
            name: 'Composite',
            class_name: 'ScaleAction',
            model_properties: {
              direction: {
                required: true,
                serialized_name: 'direction',
                type: {
                  name: 'Enum',
                  module: 'ScaleDirection'
                }
              },
              type: {
                required: true,
                is_constant: true,
                serialized_name: 'type',
                default_value: 'ChangeCount',
                type: {
                  name: 'String'
                }
              },
              value: {
                required: false,
                serialized_name: 'value',
                default_value: '1',
                type: {
                  name: 'String'
                }
              },
              cooldown: {
                required: true,
                serialized_name: 'cooldown',
                type: {
                  name: 'TimeSpan'
                }
              }
            }
          }
        }
      end
    end
  end
end
