/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */
/*
 *  Copyright (C) 2011  Ruby-GNOME2 Project Team
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA  02110-1301  USA
 */

#ifndef __RBGIO2CONVERSIONS_H__
#define __RBGIO2CONVERSIONS_H__

#define RVAL2GAPPINFO(o)                   (G_APP_INFO(RVAL2GOBJ(o)))
#define RVAL2GAPPLAUNCHCONTEXT(o)          (G_APP_LAUNCH_CONTEXT(RVAL2GOBJ(o)))
#define RVAL2GASYNCINITABLE(o)             (G_ASYNC_INITABLE(RVAL2GOBJ(o)))
#define RVAL2GASYNCRESULT(o)               (G_ASYNC_RESULT(RVAL2GOBJ(o)))
#define RVAL2GBUFFEREDINPUTSTREAM(o)       (G_BUFFERED_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GBUFFEREDOUTPUTSTREAM(o)      (G_BUFFERED_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GCANCELLABLE(o)               (G_CANCELLABLE(RVAL2GOBJ(o)))
#define RVAL2GCHARSETCONVERTER(o)          (G_CHARSET_CONVERTER(RVAL2GOBJ(o)))
#define RVAL2GCONVERTER(o)                 (G_CONVERTER(RVAL2GOBJ(o)))
#define RVAL2GCONVERTERINPUTSTREAM(o)      (G_CONVERTER_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GCONVERTEROUTPUTSTREAM(o)     (G_CONVERTER_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GDATAINPUTSTREAM(o)           (G_DATA_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GDATAOUTPUTSTREAM(o)          (G_DATA_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GDESKTOPAPPINFO(o)            (G_DESKTOP_APP_INFO(RVAL2GOBJ(o)))
#define RVAL2GDRIVE(o)                     (G_DRIVE(RVAL2GOBJ(o)))
#define RVAL2GEMBLEM(o)                    (G_EMBLEM(RVAL2GOBJ(o)))
#define RVAL2GEMBLEMEDICON(o)              (G_EMBLEMED_ICON(RVAL2GOBJ(o)))
#define RVAL2GFILE(o)                      (G_FILE(RVAL2GOBJ(o)))
#define RVAL2GFILEDESCRIPTORBASED(o)       (G_FILE_DESCRIPTOR_BASED(RVAL2GOBJ(o)))
#define RVAL2GFILEENUMERATOR(o)            (G_FILE_ENUMERATOR(RVAL2GOBJ(o)))
#define RVAL2GFILEICON(o)                  (G_FILE_ICON(RVAL2GOBJ(o)))
#define RVAL2GFILEINFO(o)                  (G_FILE_INFO(RVAL2GOBJ(o)))
#define RVAL2GFILEINPUTSTREAM(o)           (G_FILE_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GFILEIOSTREAM(o)              (G_FILE_IO_STREAM(RVAL2GOBJ(o)))
#define RVAL2GFILEMONITOR(o)               (G_FILE_MONITOR(RVAL2GOBJ(o)))
#define RVAL2GFILENAMECOMPLETER(o)         (G_FILENAME_COMPLETER(RVAL2GOBJ(o)))
#define RVAL2GFILEOUTPUTSTREAM(o)          (G_FILE_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GICON(o)                      (G_ICON(RVAL2GOBJ(o)))
#define RVAL2GINETADDRESS(o)               (G_INET_ADDRESS(RVAL2GOBJ(o)))
#define RVAL2GINITABLE(o)                  (G_INITABLE(RVAL2GOBJ(o)))
#define RVAL2GINPUTSTREAM(o)               (G_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GIOMODULE(o)                  (G_IO_MODULE(RVAL2GOBJ(o)))
#define RVAL2GIOSTREAM(o)                  (G_IO_STREAM(RVAL2GOBJ(o)))
#define RVAL2GLOADABLEICON(o)              (G_LOADABLE_ICON(RVAL2GOBJ(o)))
#define RVAL2GMEMORYINPUTSTREAM(o)         (G_MEMORY_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GMOUNT(o)                     (G_MOUNT(RVAL2GOBJ(o)))
#define RVAL2GMOUNTOPERATION(o)            (G_MOUNT_OPERATION(RVAL2GOBJ(o)))
#define RVAL2GNETWORKADDRESS(o)            (G_NETWORK_ADDRESS(RVAL2GOBJ(o)))
#define RVAL2GNETWORKSERVICE(o)            (G_NETWORK_SERVICE(RVAL2GOBJ(o)))
#define RVAL2GOUTPUTSTREAM(o)              (G_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GPERMISSION(o)                (G_PERMISSION(RVAL2GOBJ(o)))
#define RVAL2GRESOLVER(o)                  (G_RESOLVER(RVAL2GOBJ(o)))
#define RVAL2GSEEKABLE(o)                  (G_SEEKABLE(RVAL2GOBJ(o)))
#define RVAL2GSIMPLEASYNCRESULT(o)         (G_SIMPLE_ASYNC_RESULT(RVAL2GOBJ(o)))
#define RVAL2GSOCKET(o)                    (G_SOCKET(RVAL2GOBJ(o)))
#define RVAL2GSOCKETADDRESS(o)             (G_SOCKET_ADDRESS(RVAL2GOBJ(o)))
#define RVAL2GSOCKETADDRESSENUMERATOR(o)   (G_SOCKET_ADDRESS_ENUMERATOR(RVAL2GOBJ(o)))
#define RVAL2GSOCKETCLIENT(o)              (G_SOCKET_CLIENT(RVAL2GOBJ(o)))
#define RVAL2GSOCKETCONNECTABLE(o)         (G_SOCKET_CONNECTABLE(RVAL2GOBJ(o)))
#define RVAL2GSOCKETCONNECTION(o)          (G_SOCKET_CONNECTION(RVAL2GOBJ(o)))
#define RVAL2GSOCKETCONTROLMESSAGE(o)      (G_SOCKET_CONTROL_MESSAGE(RVAL2GOBJ(o)))
#define RVAL2GSOCKETLISTENER(o)            (G_SOCKET_LISTENER(RVAL2GOBJ(o)))
#define RVAL2GSOCKETSERVICE(o)             (G_SOCKET_SERVICE(RVAL2GOBJ(o)))
#define RVAL2GTHEMEDICON(o)                (G_THEMED_ICON(RVAL2GOBJ(o)))
#define RVAL2GUNIXCONNECTION(o)            (G_UNIX_CONNECTION(RVAL2GOBJ(o)))
#define RVAL2GUNIXFDLIST(o)                (G_UNIX_FD_LIST(RVAL2GOBJ(o)))
#define RVAL2GUNIXFDMESSAGE(o)             (G_UNIX_FD_MESSAGE(RVAL2GOBJ(o)))
#define RVAL2GUNIXINPUTSTREAM(o)           (G_UNIX_INPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GUNIXMOUNTMONITOR(o)          (G_UNIX_MOUNT_MONITOR(RVAL2GOBJ(o)))
#define RVAL2GUNIXOUTPUTSTREAM(o)          (G_UNIX_OUTPUT_STREAM(RVAL2GOBJ(o)))
#define RVAL2GUNIXSOCKETADDRESS(o)         (G_UNIX_SOCKET_ADDRESS(RVAL2GOBJ(o)))
#define RVAL2GVFS(o)                       (G_VFS(RVAL2GOBJ(o)))
#define RVAL2GVOLUME(o)                    (G_VOLUME(RVAL2GOBJ(o)))
#define RVAL2GVOLUMEMONITOR(o)             (G_VOLUME_MONITOR(RVAL2GOBJ(o)))
#define RVAL2GZLIBCOMPRESSOR(o)            (G_ZLIB_COMPRESSOR(RVAL2GOBJ(o)))
#define RVAL2GZLIBDECOMPRESSOR(o)          (G_ZLIB_DECOMPRESSOR(RVAL2GOBJ(o)))

#define RVAL2GFILEATTRIBUTEINFO(o)         ((GFileAttributeInfo*)RVAL2BOXED(o, G_TYPE_FILE_ATTRIBUTE_INFO))
#define GFILEATTRIBUTEINFO2RVAL(o)         (BOXED2RVAL(o, G_TYPE_FILE_ATTRIBUTE_INFO))
#define RVAL2GFILEATTRIBUTEINFOLIST(o)     ((GFileAttributeInfoList*)RVAL2BOXED(o, G_TYPE_FILE_ATTRIBUTE_INFO_LIST))
#define GFILEATTRIBUTEINFOLIST2RVAL(o)     (BOXED2RVAL(o, G_TYPE_FILE_ATTRIBUTE_INFO_LIST))
#define RVAL2GFILEATTRIBUTEMATCHER(o)      ((GFileAttributeMatcher*)RVAL2BOXED(o, G_TYPE_FILE_ATTRIBUTE_MATCHER))
#define GFILEATTRIBUTEMATCHER2RVAL(o)      (BOXED2RVAL(o, G_TYPE_FILE_ATTRIBUTE_MATCHER))
#define RVAL2GSRVTARGET(o)                 ((GSrvTarget*)RVAL2BOXED(o, G_TYPE_SRV_TARGET))
#define GSRVTARGET2RVAL(o)                 (BOXED2RVAL(o, G_TYPE_SRV_TARGET))

#define RVAL2GDATASTREAMBYTEORDER(o)       (RVAL2GENUM(o, G_TYPE_DATA_STREAM_BYTE_ORDER))
#define GDATASTREAMBYTEORDER2RVAL(o)       (GENUM2RVAL(o, G_TYPE_DATA_STREAM_BYTE_ORDER))
#define RVAL2GDATASTREAMNEWLINETYPE(o)     (RVAL2GENUM(o, G_TYPE_DATA_STREAM_NEWLINE_TYPE))
#define GDATASTREAMNEWLINETYPE2RVAL(o)     (GENUM2RVAL(o, G_TYPE_DATA_STREAM_NEWLINE_TYPE))
#define RVAL2GDRIVESTARTFLAGS(o)           (RVAL2GENUM(o, G_TYPE_DRIVE_START_FLAGS))
#define GDRIVESTARTFLAGS2RVAL(o)           (GENUM2RVAL(o, G_TYPE_DRIVE_START_FLAGS))
#define RVAL2GDRIVESTARTSTOPTYPE(o)        (RVAL2GENUM(o, G_TYPE_DRIVE_START_STOP_TYPE))
#define GDRIVESTARTSTOPTYPE2RVAL(o)        (GENUM2RVAL(o, G_TYPE_DRIVE_START_STOP_TYPE))
#define RVAL2GEMBLEMORIGIN(o)              (RVAL2GENUM(o, G_TYPE_EMBLEM_ORIGIN))
#define GEMBLEMORIGIN2RVAL(o)              (GENUM2RVAL(o, G_TYPE_EMBLEM_ORIGIN))
#define RVAL2GFILEATTRIBUTESTATUS(o)       (RVAL2GENUM(o, G_TYPE_FILE_ATTRIBUTE_STATUS))
#define GFILEATTRIBUTESTATUS2RVAL(o)       (GENUM2RVAL(o, G_TYPE_FILE_ATTRIBUTE_STATUS))
#define RVAL2GFILEATTRIBUTETYPE(o)         (RVAL2GENUM(o, G_TYPE_FILE_ATTRIBUTE_TYPE))
#define GFILEATTRIBUTETYPE2RVAL(o)         (GENUM2RVAL(o, G_TYPE_FILE_ATTRIBUTE_TYPE))
#define RVAL2GFILETYPE(o)                  (RVAL2GENUM(o, G_TYPE_FILE_TYPE))
#define GFILETYPE2RVAL(o)                  (GENUM2RVAL(o, G_TYPE_FILE_TYPE))
#define RVAL2GMOUNTMOUNTFLAGS(o)           (RVAL2GENUM(o, G_TYPE_MOUNT_MOUNT_FLAGS))
#define GMOUNTMOUNTFLAGS2RVAL(o)           (GENUM2RVAL(o, G_TYPE_MOUNT_MOUNT_FLAGS))
#define RVAL2GMOUNTOPERATIONRESULT(o)      (RVAL2GENUM(o, G_TYPE_MOUNT_OPERATION_RESULT))
#define GMOUNTOPERATIONRESULT2RVAL(o)      (GENUM2RVAL(o, G_TYPE_MOUNT_OPERATION_RESULT))
#define RVAL2GPASSWORDSAVE(o)              (RVAL2GENUM(o, G_TYPE_PASSWORD_SAVE))
#define GPASSWORDSAVE2RVAL(o)              (GENUM2RVAL(o, G_TYPE_PASSWORD_SAVE))
#define RVAL2GSOCKETFAMILY(o)              (RVAL2GENUM(o, G_TYPE_SOCKET_FAMILY))
#define GSOCKETFAMILY2RVAL(o)              (GENUM2RVAL(o, G_TYPE_SOCKET_FAMILY))
#define RVAL2GSOCKETPROTOCOL(o)            (RVAL2GENUM(o, G_TYPE_SOCKET_PROTOCOL))
#define GSOCKETPROTOCOL2RVAL(o)            (GENUM2RVAL(o, G_TYPE_SOCKET_PROTOCOL))
#define RVAL2GSOCKETTYPE(o)                (RVAL2GENUM(o, G_TYPE_SOCKET_TYPE))
#define GSOCKETTYPE2RVAL(o)                (GENUM2RVAL(o, G_TYPE_SOCKET_TYPE))

#define RVAL2GAPPINFOCREATEFLAGS(o)        (RVAL2GFLAGS(o, G_TYPE_APP_INFO_CREATE_FLAGS))
#define GAPPINFOCREATEFLAGS2RVAL(o)        (GFLAGS2RVAL(o, G_TYPE_APP_INFO_CREATE_FLAGS))
#define RVAL2GAPPLICATIONFLAGS(o)          (RVAL2GFLAGS(o, G_TYPE_APPLICATION_FLAGS))
#define GAPPLICATIONFLAGS2RVAL(o)          (GFLAGS2RVAL(o, G_TYPE_APPLICATION_FLAGS))
#define RVAL2GCONVERTERFLAGS(o)            (RVAL2GFLAGS(o, G_TYPE_CONVERTER_FLAGS))
#define GCONVERTERFLAGS2RVAL(o)            (GFLAGS2RVAL(o, G_TYPE_CONVERTER_FLAGS))
#define RVAL2GCONVERTERRESULT(o)           (RVAL2GFLAGS(o, G_TYPE_CONVERTER_RESULT))
#define GCONVERTERRESULT2RVAL(o)           (GFLAGS2RVAL(o, G_TYPE_CONVERTER_RESULT))
#define RVAL2GFILEATTRIBUTEINFOFLAGS(o)    (RVAL2GFLAGS(o, G_TYPE_FILE_ATTRIBUTE_INFO_FLAGS))
#define GFILEATTRIBUTEINFOFLAGS2RVAL(o)    (GFLAGS2RVAL(o, G_TYPE_FILE_ATTRIBUTE_INFO_FLAGS))
#define RVAL2GFILECOPYFLAGS(o)             (RVAL2GFLAGS(o, G_TYPE_FILE_COPY_FLAGS))
#define GFILECOPYFLAGS2RVAL(o)             (GFLAGS2RVAL(o, G_TYPE_FILE_COPY_FLAGS))
#define RVAL2GFILECREATEFLAGS(o)           (RVAL2GFLAGS(o, G_TYPE_FILE_CREATE_FLAGS))
#define GFILECREATEFLAGS2RVAL(o)           (GFLAGS2RVAL(o, G_TYPE_FILE_CREATE_FLAGS))
#define RVAL2GFILEMONITORFLAGS(o)          (RVAL2GFLAGS(o, G_TYPE_FILE_MONITOR_FLAGS))
#define GFILEMONITORFLAGS2RVAL(o)          (GFLAGS2RVAL(o, G_TYPE_FILE_MONITOR_FLAGS))
#define RVAL2GFILEQUERYINFOFLAGS(o)        (RVAL2GFLAGS(o, G_TYPE_FILE_QUERY_INFO_FLAGS))
#define GFILEQUERYINFOFLAGS2RVAL(o)        (GFLAGS2RVAL(o, G_TYPE_FILE_QUERY_INFO_FLAGS))
#define RVAL2GMOUNTUNMOUNTFLAGS(o)         (RVAL2GFLAGS(o, G_TYPE_MOUNT_UNMOUNT_FLAGS))
#define GMOUNTUNMOUNTFLAGS2RVAL(o)         (GFLAGS2RVAL(o, G_TYPE_MOUNT_UNMOUNT_FLAGS))
#define RVAL2GOUTPUTSTREAMSPLICEFLAGS(o)   (RVAL2GFLAGS(o, G_TYPE_OUTPUT_STREAM_SPLICE_FLAGS))
#define GOUTPUTSTREAMSPLICEFLAGS2RVAL(o)   (GFLAGS2RVAL(o, G_TYPE_OUTPUT_STREAM_SPLICE_FLAGS))
#define RVAL2GZLIBCOMPRESSORFORMAT(o)      (RVAL2GFLAGS(o, G_TYPE_ZLIB_COMPRESSOR_FORMAT))
#define GZLIBCOMPRESSORFORMAT2RVAL(o)      (GFLAGS2RVAL(o, G_TYPE_ZLIB_COMPRESSOR_FORMAT))

#endif /* __RBGIO2CONVERSIONS_H__ */
